/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractParallelJobQueue;
import org.osgi.service.event.EventAdmin;

public final class ParallelJobQueue
extends AbstractParallelJobQueue {
    private final BlockingQueue<JobHandler> queue = new LinkedBlockingQueue<JobHandler>();

    public ParallelJobQueue(String name, InternalQueueConfiguration config, JobConsumerManager jobConsumerManager, ThreadPoolManager threadPoolManager, EventAdmin eventAdmin, Scheduler scheduler) {
        super(name, config, jobConsumerManager, threadPoolManager, eventAdmin, scheduler);
    }

    @Override
    protected void put(JobHandler event) {
        try {
            this.isWaitingForNext = false;
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobHandler take() {
        try {
            this.isWaitingForNext = true;
            JobHandler jobHandler = this.queue.take();
            return jobHandler;
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.isWaitingForNext = false;
        }
        return null;
    }

    @Override
    protected boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }

    @Override
    protected Collection<JobHandler> removeAllJobs() {
        ArrayList<JobHandler> events = new ArrayList<JobHandler>();
        this.queue.drainTo(events);
        return events;
    }
}

