/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.timed;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.event.TimedEventStatusProvider;
import org.apache.sling.event.impl.jobs.timed.ScheduleInfo;
import org.apache.sling.event.impl.jobs.timed.TimedEventConfiguration;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={TimedEventStatusProvider.class, EventHandler.class, TopologyEventListener.class})
@Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/REMOVED", "org/apache/sling/api/resource/Resource/CHANGED", "org/osgi/framework/BundleEvent/STARTED", "org/osgi/framework/BundleEvent/UPDATED"})
public class TimedEventSender
implements Job,
TimedEventStatusProvider,
EventHandler,
TopologyEventListener {
    private static final String JOB_TOPIC = "topic";
    private static final String JOB_CONFIG = "config";
    private static final String JOB_SCHEDULE_INFO = "info";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean running;
    private volatile boolean active;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private TimedEventConfiguration config;
    @Reference
    private EventAdmin eventAdmin;
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private final Set<String> startedSchedulerJobs = new HashSet<String>();
    private Set<String> unloadedEvents = new HashSet<String>();
    private final AtomicBoolean threadStarted = new AtomicBoolean(false);

    @Activate
    protected void activate() {
        this.running = true;
    }

    @Deactivate
    protected void deactivate() {
        this.running = false;
        this.stopScheduling();
    }

    private void stopScheduling() {
        Scheduler localScheduler = this.scheduler;
        if (localScheduler != null) {
            for (String id : this.startedSchedulerJobs) {
                localScheduler.unschedule(id);
            }
        }
        this.startedSchedulerJobs.clear();
        this.queue.clear();
        try {
            this.queue.put(new Event("org/apache/sling/event/impl/jobs/STOPPED", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    private void startScheduling() {
        final long now = System.currentTimeMillis();
        Thread backgroundThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TimedEventSender.this.loadEvents(now);
                if (TimedEventSender.this.threadStarted.compareAndSet(false, true)) {
                    try {
                        TimedEventSender.this.runInBackground();
                    }
                    catch (Throwable t) {
                        TimedEventSender.this.logger.error("Background thread stopped with exception: " + t.getMessage(), t);
                        TimedEventSender.this.running = false;
                    }
                }
            }
        });
        backgroundThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInBackground() {
        Event event = null;
        while (this.running) {
            String path;
            if (event == null) {
                try {
                    event = this.queue.take();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                    this.running = false;
                }
            }
            if (event == null || !this.running) continue;
            if (event.getTopic().equals("org/apache/sling/api/resource/Resource/ADDED") || event.getTopic().equals("org/apache/sling/api/resource/Resource/CHANGED")) {
                path = (String)event.getProperty("path");
                event = null;
                ResourceResolver resolver = null;
                try {
                    ReadResult result;
                    resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                    Resource eventResource = resolver.getResource(path);
                    if (!"slingevent:TimedEvent".equals(eventResource.getResourceType()) || (result = this.readEvent(eventResource)) == null) continue;
                    if (result.hasReadErrors) {
                        Set<String> set = this.unloadedEvents;
                        synchronized (set) {
                            this.unloadedEvents.add(eventResource.getPath());
                            continue;
                        }
                    }
                    event = result.event;
                    continue;
                }
                catch (LoginException le) {
                    this.ignoreException((Exception)((Object)le));
                    continue;
                }
                finally {
                    if (resolver != null) {
                        resolver.close();
                    }
                    continue;
                }
            }
            if (event.getTopic().equals("org/apache/sling/api/resource/Resource/REMOVED")) {
                path = (String)event.getProperty("path");
                String jobId = ResourceUtil.getName((String)path);
                this.startedSchedulerJobs.remove(jobId);
                this.logger.debug("Stopping job with id : {}", (Object)jobId);
                this.scheduler.unschedule(jobId);
                event = null;
                continue;
            }
            if (!"org/apache/sling/event/impl/jobs/STOPPED".equals(event.getTopic())) {
                ScheduleInfo scheduleInfo = null;
                try {
                    scheduleInfo = new ScheduleInfo(event);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.error(iae.getMessage());
                }
                if (scheduleInfo != null && !this.processEvent(event, scheduleInfo)) {
                    try {
                        this.queue.put(event);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                        Thread.currentThread().interrupt();
                        this.running = false;
                    }
                }
                event = null;
                continue;
            }
            if ("org/apache/sling/event/impl/jobs/STOPPED".equals(event.getTopic())) {
                event = null;
                continue;
            }
            event = null;
        }
    }

    protected boolean processEvent(Event event, ScheduleInfo scheduleInfo) {
        Scheduler localScheduler = this.scheduler;
        if (localScheduler != null) {
            ScheduleOptions options;
            if (scheduleInfo.isStopEvent()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Stopping timed event " + event.getProperty("event.topic.timed") + "(" + scheduleInfo.jobId + ")");
                }
                this.startedSchedulerJobs.remove(scheduleInfo.jobId);
                localScheduler.unschedule(scheduleInfo.jobId);
                return true;
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            config.put(JOB_TOPIC, (String)event.getProperty("event.topic.timed"));
            String[] names = event.getPropertyNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    properties.put(names[i], event.getProperty(names[i]));
                }
            }
            config.put(JOB_CONFIG, properties);
            config.put(JOB_SCHEDULE_INFO, scheduleInfo);
            if (scheduleInfo.expression != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding timed event " + config.get(JOB_TOPIC) + "(" + scheduleInfo.jobId + ")" + " with cron expression " + scheduleInfo.expression);
                }
                options = localScheduler.EXPR(scheduleInfo.expression);
            } else if (scheduleInfo.period != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding timed event " + config.get(JOB_TOPIC) + "(" + scheduleInfo.jobId + ")" + " with period " + scheduleInfo.period);
                }
                Date startDate = new Date(System.currentTimeMillis() + scheduleInfo.period * 1000L);
                options = localScheduler.AT(startDate, -1, scheduleInfo.period.longValue());
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding timed event " + config.get(JOB_TOPIC) + "(" + scheduleInfo.jobId + ")" + " with date " + scheduleInfo.date);
                }
                options = localScheduler.AT(scheduleInfo.date);
            }
            localScheduler.schedule((Object)this, options.canRunConcurrently(false).name(scheduleInfo.jobId).config(config));
            this.startedSchedulerJobs.add(scheduleInfo.jobId);
            return true;
        }
        this.logger.error("No scheduler available to start timed event " + event);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (this.active) {
            if ("org/osgi/framework/BundleEvent/STARTED".equals(event.getTopic()) || "org/osgi/framework/BundleEvent/UPDATED".equals(event.getTopic())) {
                boolean doIt = false;
                Set<String> set = this.unloadedEvents;
                synchronized (set) {
                    if (this.unloadedEvents.size() > 0) {
                        doIt = true;
                    }
                }
                if (doIt) {
                    Runnable t = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Set set = TimedEventSender.this.unloadedEvents;
                            synchronized (set) {
                                ResourceResolver resolver = null;
                                HashSet<String> newUnloadedEvents = new HashSet<String>();
                                newUnloadedEvents.addAll(TimedEventSender.this.unloadedEvents);
                                try {
                                    resolver = TimedEventSender.this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                                    for (String path : TimedEventSender.this.unloadedEvents) {
                                        newUnloadedEvents.remove(path);
                                        Resource eventResource = resolver.getResource(path);
                                        ReadResult result = TimedEventSender.this.readEvent(eventResource);
                                        if (result == null) continue;
                                        if (result.hasReadErrors) {
                                            newUnloadedEvents.add(path);
                                            continue;
                                        }
                                        try {
                                            TimedEventSender.this.queue.put(result.event);
                                        }
                                        catch (InterruptedException e) {
                                            TimedEventSender.this.ignoreException(e);
                                            Thread.currentThread().interrupt();
                                            break;
                                        }
                                    }
                                }
                                catch (LoginException re) {
                                    TimedEventSender.this.ignoreException((Exception)((Object)re));
                                }
                                finally {
                                    if (resolver != null) {
                                        resolver.close();
                                    }
                                    TimedEventSender.this.unloadedEvents.clear();
                                    TimedEventSender.this.unloadedEvents.addAll(newUnloadedEvents);
                                }
                            }
                        }
                    };
                    Environment.THREAD_POOL.execute(t);
                }
            } else {
                String path = (String)event.getProperty("path");
                String resourceType = (String)event.getProperty("resourceType");
                if (path != null && path.startsWith(this.config.getResourcePathWithSlash()) && (resourceType == null || "slingevent:TimedEvent".equals(resourceType))) {
                    this.logger.debug("Received resource event for {} : {}", (Object)path, (Object)resourceType);
                    try {
                        this.queue.put(event);
                    }
                    catch (InterruptedException ignore) {
                        this.ignoreException(ignore);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEvent(ScheduleInfo info) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder sb = new StringBuilder(this.config.getResourcePathWithSlash());
            sb.append(info.topic.replace('/', '.'));
            sb.append('/');
            sb.append(info.jobId);
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                resolver.delete(eventResource);
                resolver.commit();
            }
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        catch (PersistenceException pe) {
            this.ignoreException((Exception)((Object)pe));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    public void execute(JobContext context) {
        String topic = (String)context.getConfiguration().get(JOB_TOPIC);
        Dictionary properties = (Dictionary)context.getConfiguration().get(JOB_CONFIG);
        EventAdmin ea = this.eventAdmin;
        if (ea != null) {
            try {
                ea.postEvent(new Event(topic, properties));
            }
            catch (IllegalArgumentException iae) {
                this.logger.error("Scheduled event has illegal topic: " + topic, (Throwable)iae);
            }
        } else {
            this.logger.warn("Unable to send timed event as no event admin service is available.");
        }
        ScheduleInfo info = (ScheduleInfo)context.getConfiguration().get(JOB_SCHEDULE_INFO);
        if (info.date != null) {
            this.removeEvent(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEvents(long startTime) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Calendar startDate = Calendar.getInstance();
            startDate.setTimeInMillis(startTime);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:TimedEvent");
            buf.append(")[@");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" < xs:dateTime('");
            buf.append(ISO8601.format(startDate));
            buf.append("')] order by @");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" ascending");
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                ReadResult readResult;
                Resource eventResource = (Resource)result.next();
                if (!eventResource.getPath().startsWith(this.config.getResourcePathWithSlash()) || (readResult = this.readEvent(eventResource)) == null) continue;
                if (readResult.hasReadErrors) {
                    Set<String> set = this.unloadedEvents;
                    synchronized (set) {
                        this.unloadedEvents.add(eventResource.getPath());
                        continue;
                    }
                }
                try {
                    this.queue.put(readResult.event);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private ReadResult readEvent(Resource eventResource) {
        if (eventResource != null) {
            try {
                ValueMap vm = ResourceHelper.getValueMap(eventResource);
                Map<String, Object> properties = ResourceHelper.cloneValueMap(vm);
                String topic = (String)properties.get("event.topics");
                if (topic == null) {
                    topic = (String)properties.remove("slingevent:topic");
                }
                ReadResult result = new ReadResult();
                if (topic == null) {
                    this.logger.warn("Resource at {} does not look like a timed event: {}", (Object)eventResource.getPath(), properties);
                    result.hasReadErrors = true;
                    return result;
                }
                List readErrorList = (List)properties.remove(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
                boolean bl = result.hasReadErrors = readErrorList != null;
                if (readErrorList != null) {
                    for (Exception e : readErrorList) {
                        this.logger.warn("Unable to read timed event job from " + eventResource.getPath(), (Throwable)e);
                    }
                }
                properties.remove("event.topics");
                properties.put("slingevent:eventId", topic.replace('/', '.') + '/' + eventResource.getName());
                try {
                    result.event = new Event(topic, properties);
                    return result;
                }
                catch (IllegalArgumentException iae) {
                    this.logger.error("Unable to read event: " + iae.getMessage(), (Throwable)iae);
                }
            }
            catch (InstantiationException ie) {
                this.ignoreException(ie);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event getScheduledEvent(String topic, String eventId, String jobId) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            String scheduleId = ScheduleInfo.getJobId(topic, eventId, jobId);
            StringBuilder sb = new StringBuilder(this.config.getResourcePathWithSlash());
            sb.append(topic.replace('/', '.'));
            sb.append('/');
            sb.append(scheduleId);
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            ReadResult result = this.readEvent(eventResource);
            if (result != null) {
                Event event = result.event;
                return event;
            }
        }
        catch (LoginException re) {
            this.logger.error("Unable to create a resource resolver.", (Throwable)re);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Event> getScheduledEvents(String topic, Map<String, Object> ... filterProps) {
        ArrayList<Event> result = new ArrayList<Event>();
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:TimedEvent");
            buf.append(")[@");
            buf.append(ISO9075.encode("event.topics"));
            buf.append(" = '");
            buf.append(topic);
            buf.append("'");
            if (filterProps != null && filterProps.length > 0) {
                buf.append(" and (");
                int index = 0;
                for (Map<String, Object> template : filterProps) {
                    if (index > 0) {
                        buf.append(" or ");
                    }
                    buf.append('(');
                    Iterator<Map.Entry<String, Object>> i = template.entrySet().iterator();
                    boolean first = true;
                    while (i.hasNext()) {
                        Map.Entry<String, Object> current = i.next();
                        String propName = ISO9075.encode(current.getKey());
                        if (first) {
                            first = false;
                            buf.append('@');
                        } else {
                            buf.append(" and @");
                        }
                        buf.append(propName);
                        buf.append(" = '");
                        buf.append(current.getValue());
                        buf.append("'");
                    }
                    buf.append(')');
                    ++index;
                }
                buf.append(')');
            }
            buf.append("]");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing query {}", (Object)buf);
            }
            Iterator iter = resolver.findResources(buf.toString(), "xpath");
            while (iter.hasNext()) {
                ReadResult readResult;
                Resource eventResource = (Resource)iter.next();
                if (!eventResource.getPath().startsWith(this.config.getResourcePathWithSlash()) || (readResult = this.readEvent(eventResource)) == null || readResult.event == null) continue;
                result.add(readResult.event);
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimedEvent(String jobId) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder sb = new StringBuilder(this.config.getResourcePathWithSlash());
            sb.append(jobId);
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                resolver.delete(eventResource);
                resolver.commit();
            }
        }
        catch (LoginException re) {
            this.logger.error("Unable to create a resource resolver.", (Throwable)re);
        }
        catch (PersistenceException pe) {
            this.ignoreException((Exception)((Object)pe));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            this.active = false;
            this.stopScheduling();
        } else if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.TOPOLOGY_INIT) {
            boolean previouslyActive = this.active;
            this.active = event.getNewView().getLocalInstance().isLeader();
            if (this.active && !previouslyActive) {
                this.startScheduling();
            }
            if (!this.active && previouslyActive) {
                this.stopScheduling();
            }
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConfig(TimedEventConfiguration timedEventConfiguration) {
        this.config = timedEventConfiguration;
    }

    protected void unbindConfig(TimedEventConfiguration timedEventConfiguration) {
        if (this.config == timedEventConfiguration) {
            this.config = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    private static final class ReadResult {
        public Event event;
        public boolean hasReadErrors;

        private ReadResult() {
        }
    }
}

