/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.dea;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.support.Environment;

@Component(name="org.apache.sling.event.impl.DistributingEventHandler")
@Service(value={DistributedEventAdminConfiguration.class})
public class DistributedEventAdminConfiguration {
    private static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/distribution";
    @Property(value={"/var/eventing/distribution"})
    private static final String CONFIG_PROPERTY_REPOSITORY_PATH = "repository.path";
    private static final int DEFAULT_CLEANUP_PERIOD = 15;
    @Property(intValue={15})
    private static final String CONFIG_PROPERTY_CLEANUP_PERIOD = "cleanup.period";
    private int cleanupPeriod = 15;
    private String rootPath;
    private String rootPathWithSlash;
    private String ownRootPath;
    private String ownRootPathSlash;
    @Reference
    private EnvironmentComponent environment;

    @Activate
    protected void activate(Map<String, Object> props) {
        this.cleanupPeriod = PropertiesUtil.toInteger(props.get(CONFIG_PROPERTY_CLEANUP_PERIOD), 15);
        this.rootPath = PropertiesUtil.toString(props.get(CONFIG_PROPERTY_REPOSITORY_PATH), DEFAULT_REPOSITORY_PATH);
        this.rootPathWithSlash = this.rootPath.concat("/");
        this.ownRootPath = this.rootPathWithSlash.concat(Environment.APPLICATION_ID);
        this.ownRootPathSlash = this.ownRootPath.concat("/");
    }

    public String getRootPathWithSlash() {
        return this.rootPathWithSlash;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getOwnRootPath() {
        return this.ownRootPath;
    }

    public String getOwnRootPathWithSlash() {
        return this.ownRootPathSlash;
    }

    public int getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }
}

