/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.dea;

import aQute.bnd.annotation.component.Deactivate;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.event.impl.dea.DistributedEventAdminConfiguration;
import org.apache.sling.event.impl.support.BatchResourceRemover;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventHandler.class, Runnable.class, TopologyEventListener.class})
@Properties(value={@Property(name="event.topics", value={"*"}), @Property(name="event.filter", value={"(event.distribute=*)"}), @Property(name="scheduler.period", longValue={1800L}), @Property(name="scheduler.concurrent", boolValue={false})})
public class DistributedEventReceiver
implements EventHandler,
Runnable,
TopologyEventListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private DistributedEventAdminConfiguration config;
    private volatile boolean running;
    private final BlockingQueue<Event> writeQueue = new LinkedBlockingQueue<Event>();
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver writerResolver;
    private Set<String> instances;
    private final AtomicLong eventCounter = new AtomicLong(0L);

    @Activate
    protected void activate() {
        this.running = true;
        Thread writerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributedEventReceiver.this.writerResolver = DistributedEventReceiver.this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                    ResourceHelper.getOrCreateBasePath(DistributedEventReceiver.this.writerResolver, DistributedEventReceiver.this.config.getOwnRootPath());
                }
                catch (Exception e) {
                    DistributedEventReceiver.this.logger.error("Error during resource resolver creation.", (Throwable)e);
                    DistributedEventReceiver.this.running = false;
                }
                try {
                    DistributedEventReceiver.this.processWriteQueue();
                }
                catch (Throwable t) {
                    DistributedEventReceiver.this.logger.error("Writer thread stopped with exception: " + t.getMessage(), t);
                    DistributedEventReceiver.this.running = false;
                }
                if (DistributedEventReceiver.this.writerResolver != null) {
                    DistributedEventReceiver.this.writerResolver.close();
                    DistributedEventReceiver.this.writerResolver = null;
                }
            }
        });
        writerThread.start();
    }

    @Deactivate
    protected void deactivate() {
        this.running = false;
        try {
            this.writeQueue.put(new Event("org/apache/sling/event/impl/jobs/STOPPED", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
    }

    private void processWriteQueue() {
        while (this.running) {
            Event event = null;
            try {
                event = this.writeQueue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (event == null || !this.running) continue;
            try {
                this.writeEvent(event);
            }
            catch (Exception e) {
                this.logger.error("Exception during writing the event to the resource tree.", (Throwable)e);
            }
        }
    }

    private void writeEvent(Event event) throws PersistenceException {
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder(this.config.getOwnRootPathWithSlash());
        sb.append(now.get(1));
        sb.append('/');
        sb.append(now.get(2) + 1);
        sb.append('/');
        sb.append(now.get(5));
        sb.append('/');
        sb.append(now.get(11));
        sb.append('/');
        sb.append(now.get(12));
        sb.append('/');
        sb.append("event-");
        sb.append(String.valueOf(this.eventCounter.getAndIncrement()));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] propNames = event.getPropertyNames();
        if (propNames != null && propNames.length > 0) {
            for (String propName : propNames) {
                if (ResourceHelper.ignoreProperty(propName) && !"slingevent:eventId".equals(propName)) continue;
                properties.put(propName, event.getProperty(propName));
            }
        }
        properties.put("event.topics", event.getTopic());
        properties.put("event.application", Environment.APPLICATION_ID);
        properties.put("sling:resourceType", "slingevent:Event");
        ResourceHelper.getOrCreateResource(this.writerResolver, sb.toString(), properties);
    }

    public void handleEvent(Event event) {
        try {
            this.writeQueue.put(event);
        }
        catch (InterruptedException ex) {
            this.ignoreException(ex);
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.cleanUpObsoleteInstances();
        this.cleanUpObsoleteEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpObsoleteInstances() {
        Set<String> slingIds = this.instances;
        if (slingIds != null) {
            this.instances = null;
            this.logger.debug("Checking for old instance trees for distributed events.");
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource baseResource = resolver.getResource(this.config.getRootPathWithSlash());
                if (baseResource != null) {
                    BatchResourceRemover brr = new BatchResourceRemover();
                    Iterator iter = baseResource.listChildren();
                    while (iter.hasNext()) {
                        Resource rootResource = (Resource)iter.next();
                        if (slingIds.contains(rootResource.getName())) continue;
                        brr.delete(rootResource);
                    }
                    resolver.commit();
                }
            }
            catch (PersistenceException pe) {
                this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
            }
            catch (LoginException ignore) {
                this.ignoreException((Exception)((Object)ignore));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpObsoleteEvents() {
        if (this.config.getCleanupPeriod() > 0) {
            this.logger.debug("Cleaning up distributed events, removing all entries older than {} minutes.", (Object)this.config.getCleanupPeriod());
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                BatchResourceRemover brr = new BatchResourceRemover();
                Resource baseResource = resolver.getResource(this.config.getOwnRootPath());
                if (baseResource != null) {
                    Calendar oldDate = Calendar.getInstance();
                    oldDate.add(12, -1 * this.config.getCleanupPeriod());
                    int oldYear = oldDate.get(1);
                    Iterator yearIter = baseResource.listChildren();
                    while (yearIter.hasNext()) {
                        Resource yearResource = (Resource)yearIter.next();
                        int year = Integer.valueOf(yearResource.getName());
                        if (year < oldYear) {
                            brr.delete(yearResource);
                            continue;
                        }
                        if (year != oldYear) continue;
                        int oldMonth = oldDate.get(2) + 1;
                        Iterator monthIter = yearResource.listChildren();
                        while (monthIter.hasNext()) {
                            Resource monthResource = (Resource)monthIter.next();
                            int month = Integer.valueOf(monthResource.getName());
                            if (month < oldMonth) {
                                brr.delete(monthResource);
                                continue;
                            }
                            if (month != oldMonth) continue;
                            int oldDay = oldDate.get(5);
                            Iterator dayIter = monthResource.listChildren();
                            while (dayIter.hasNext()) {
                                Resource dayResource = (Resource)dayIter.next();
                                int day = Integer.valueOf(dayResource.getName());
                                if (day < oldDay) {
                                    brr.delete(dayResource);
                                    continue;
                                }
                                if (day != oldDay) continue;
                                int oldHour = oldDate.get(11);
                                Iterator hourIter = dayResource.listChildren();
                                while (hourIter.hasNext()) {
                                    Resource hourResource = (Resource)hourIter.next();
                                    int hour = Integer.valueOf(hourResource.getName());
                                    if (hour < oldHour) {
                                        brr.delete(hourResource);
                                        continue;
                                    }
                                    if (hour != oldHour) continue;
                                    int oldMinute = oldDate.get(12);
                                    Iterator minuteIter = hourResource.listChildren();
                                    while (minuteIter.hasNext()) {
                                        Resource minuteResource = (Resource)minuteIter.next();
                                        int minute = Integer.valueOf(minuteResource.getName());
                                        if (minute >= oldMinute) continue;
                                        brr.delete(minuteResource);
                                    }
                                }
                            }
                        }
                    }
                }
                resolver.commit();
            }
            catch (PersistenceException pe) {
                this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
            }
            catch (LoginException ignore) {
                this.ignoreException((Exception)((Object)ignore));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            this.instances = null;
        } else if ((event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.TOPOLOGY_INIT) && event.getNewView().getLocalInstance().isLeader()) {
            HashSet<String> set = new HashSet<String>();
            for (InstanceDescription desc : event.getNewView().getInstances()) {
                set.add(desc.getSlingId());
            }
            this.instances = set;
        }
    }

    protected void bindConfig(DistributedEventAdminConfiguration distributedEventAdminConfiguration) {
        this.config = distributedEventAdminConfiguration;
    }

    protected void unbindConfig(DistributedEventAdminConfiguration distributedEventAdminConfiguration) {
        if (this.config == distributedEventAdminConfiguration) {
            this.config = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

