/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.ScheduledJobInfo;

public class JobBuilderImpl
implements JobBuilder {
    private final String topic;
    private final JobManagerImpl jobManager;
    private Map<String, Object> properties;

    public JobBuilderImpl(JobManagerImpl manager, String topic) {
        this.jobManager = manager;
        this.topic = topic;
    }

    @Override
    public JobBuilder properties(Map<String, Object> props) {
        this.properties = props;
        return this;
    }

    @Override
    public Job add() {
        return this.add(null);
    }

    @Override
    public Job add(List<String> errors) {
        return this.jobManager.addJob(this.topic, null, this.properties, errors);
    }

    @Override
    public JobBuilder.ScheduleBuilder schedule() {
        return new ScheduleBuilderImpl(UUID.randomUUID().toString());
    }

    public JobBuilder.ScheduleBuilder schedule(String name) {
        return new ScheduleBuilderImpl(name);
    }

    public final class ScheduleBuilderImpl
    implements JobBuilder.ScheduleBuilder {
        private final String scheduleName;
        private boolean suspend = false;
        private final List<ScheduleInfoImpl> schedules = new ArrayList<ScheduleInfoImpl>();

        public ScheduleBuilderImpl(String name) {
            this.scheduleName = name;
        }

        @Override
        public JobBuilder.ScheduleBuilder weekly(int day, int hour, int minute) {
            this.schedules.add(ScheduleInfoImpl.WEEKLY(day, hour, minute));
            return this;
        }

        @Override
        public JobBuilder.ScheduleBuilder daily(int hour, int minute) {
            this.schedules.add(ScheduleInfoImpl.DAILY(hour, minute));
            return this;
        }

        @Override
        public JobBuilder.ScheduleBuilder hourly(int minute) {
            this.schedules.add(ScheduleInfoImpl.HOURLY(minute));
            return this;
        }

        @Override
        public JobBuilder.ScheduleBuilder at(Date date) {
            this.schedules.add(ScheduleInfoImpl.AT(date));
            return this;
        }

        @Override
        public JobBuilder.ScheduleBuilder monthly(int day, int hour, int minute) {
            this.schedules.add(ScheduleInfoImpl.MONTHLY(day, hour, minute));
            return this;
        }

        @Override
        public JobBuilder.ScheduleBuilder yearly(int month, int day, int hour, int minute) {
            this.schedules.add(ScheduleInfoImpl.YEARLY(month, day, hour, minute));
            return this;
        }

        @Override
        public JobBuilder.ScheduleBuilder cron(String expression) {
            this.schedules.add(ScheduleInfoImpl.CRON(expression));
            return this;
        }

        @Override
        public ScheduledJobInfo add() {
            return this.add(null);
        }

        @Override
        public ScheduledJobInfo add(List<String> errors) {
            return JobBuilderImpl.this.jobManager.addScheduledJob(JobBuilderImpl.this.topic, null, JobBuilderImpl.this.properties, this.scheduleName, this.suspend, this.schedules, errors);
        }

        @Override
        public JobBuilder.ScheduleBuilder suspend() {
            this.suspend = true;
            return this;
        }
    }
}

