/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceResolverFactory resourceResolverFactory;
    private final JobManagerConfiguration configuration;
    private volatile long queueConfigChangeCount = -1L;
    private volatile long topologyChangeCount = -1L;
    private boolean checkedForPreviousVersion = false;

    public MaintenanceTask(JobManagerConfiguration config, ResourceResolverFactory factory) {
        this.resourceResolverFactory = factory;
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignJobs(TopologyCapabilities caps, QueueConfigurationManager queueManager) {
        if (caps != null && caps.isLeader()) {
            this.logger.debug("Checking for stopped instances...");
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource jobsRoot = resolver.getResource(this.configuration.getAssginedJobsPath());
                this.logger.debug("Got jobs root {}", (Object)jobsRoot);
                if (jobsRoot != null) {
                    Iterator instanceIter = jobsRoot.listChildren();
                    while (caps.isActive() && instanceIter.hasNext()) {
                        Resource instanceResource = (Resource)instanceIter.next();
                        String instanceId = instanceResource.getName();
                        if (caps.isActive(instanceId)) continue;
                        this.logger.debug("Found stopped instance {}", (Object)instanceId);
                        this.assignJobs(caps, queueManager, instanceResource, true);
                    }
                }
            }
            catch (LoginException le) {
                this.ignoreException((Exception)((Object)le));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignUnassignedJobs(TopologyCapabilities caps, QueueConfigurationManager queueManager) {
        if (caps != null && caps.isLeader()) {
            this.logger.debug("Checking unassigned jobs...");
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource unassignedRoot = resolver.getResource(this.configuration.getUnassignedJobsPath());
                this.logger.debug("Got unassigned root {}", (Object)unassignedRoot);
                if (unassignedRoot != null) {
                    this.assignJobs(caps, queueManager, unassignedRoot, false);
                }
            }
            catch (LoginException le) {
                this.ignoreException((Exception)((Object)le));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
    }

    private void assignJobs(TopologyCapabilities caps, QueueConfigurationManager queueManager, Resource jobsRoot, boolean unassign) {
        ResourceResolver resolver = jobsRoot.getResourceResolver();
        Iterator topicIter = jobsRoot.listChildren();
        while (caps.isActive() && topicIter.hasNext()) {
            Resource topicResource = (Resource)topicIter.next();
            String topicName = topicResource.getName().replace('.', '/');
            this.logger.debug("Found topic {}", (Object)topicName);
            String checkTopic = topicName.equals("slingevent:eventadmin") ? "/" : topicName;
            List<InstanceDescription> potentialTargets = caps.getPotentialTargets(checkTopic, null);
            if (potentialTargets != null && potentialTargets.size() > 0) {
                QueueConfigurationManager.QueueInfo info = queueManager.getQueueInfo(topicName);
                this.logger.debug("Found queue {} for {}", (Object)info.queueConfiguration, (Object)topicName);
                if (info.queueConfiguration.getType() == QueueConfiguration.Type.DROP) {
                    Iterator i = topicResource.listChildren();
                    while (caps.isActive() && i.hasNext()) {
                        Resource rsrc = (Resource)i.next();
                        try {
                            resolver.delete(rsrc);
                            resolver.commit();
                        }
                        catch (PersistenceException pe) {
                            this.ignoreException((Exception)((Object)pe));
                            resolver.refresh();
                        }
                    }
                } else if (info.queueConfiguration.getType() != QueueConfiguration.Type.IGNORE) {
                    for (Resource yearResource : topicResource.getChildren()) {
                        for (Resource monthResource : yearResource.getChildren()) {
                            for (Resource dayResource : monthResource.getChildren()) {
                                for (Resource hourResource : dayResource.getChildren()) {
                                    for (Resource minuteResource : hourResource.getChildren()) {
                                        for (Resource rsrc : minuteResource.getChildren()) {
                                            if (!caps.isActive()) {
                                                return;
                                            }
                                            try {
                                                ValueMap vm = ResourceHelper.getValueMap(rsrc);
                                                String targetId = caps.detectTarget(topicName, (Map<String, Object>)vm, info);
                                                if (targetId == null) continue;
                                                String newPath = this.configuration.getAssginedJobsPath() + '/' + targetId + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                                HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                                                props.put("event.job.queuename", info.queueName);
                                                props.put("event.job.application", targetId);
                                                props.remove("event.job.started.time");
                                                try {
                                                    ResourceHelper.getOrCreateResource(resolver, newPath, props);
                                                    resolver.delete(rsrc);
                                                    resolver.commit();
                                                }
                                                catch (PersistenceException pe) {
                                                    this.ignoreException((Exception)((Object)pe));
                                                    resolver.refresh();
                                                }
                                            }
                                            catch (InstantiationException ie) {
                                                this.ignoreException(ie);
                                                resolver.refresh();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!caps.isActive() || !unassign) continue;
            for (Resource yearResource : topicResource.getChildren()) {
                for (Resource monthResource : yearResource.getChildren()) {
                    for (Resource dayResource : monthResource.getChildren()) {
                        for (Resource hourResource : dayResource.getChildren()) {
                            for (Resource minuteResource : hourResource.getChildren()) {
                                for (Resource rsrc : minuteResource.getChildren()) {
                                    if (!caps.isActive()) {
                                        return;
                                    }
                                    try {
                                        ValueMap vm = ResourceHelper.getValueMap(rsrc);
                                        String newPath = this.configuration.getUnassignedJobsPath() + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                        HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                                        props.remove("event.job.queuename");
                                        props.remove("event.job.application");
                                        props.remove("event.job.started.time");
                                        try {
                                            ResourceHelper.getOrCreateResource(resolver, newPath, props);
                                            resolver.delete(rsrc);
                                            resolver.commit();
                                        }
                                        catch (PersistenceException pe) {
                                            this.ignoreException((Exception)((Object)pe));
                                            resolver.refresh();
                                        }
                                    }
                                    catch (InstantiationException ie) {
                                        this.ignoreException(ie);
                                        resolver.refresh();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean topologyHasChanged(TopologyCapabilities topologyCapabilities) {
        boolean topologyChanged = false;
        if (topologyCapabilities != null && this.topologyChangeCount != topologyCapabilities.getChangeCount()) {
            this.topologyChangeCount = topologyCapabilities.getChangeCount();
            topologyChanged = true;
        }
        return topologyChanged;
    }

    private boolean queueConfigurationHasChanged(TopologyCapabilities topologyCapabilities, QueueConfigurationManager queueManager) {
        int queueChangeCount;
        boolean configChanged = false;
        if (topologyCapabilities != null && this.queueConfigChangeCount < (long)(queueChangeCount = queueManager.getChangeCount())) {
            configChanged = true;
            this.queueConfigChangeCount = queueChangeCount;
        }
        return configChanged;
    }

    public void run(TopologyCapabilities topologyCapabilities, QueueConfigurationManager queueManager, long cleanUpCounter) {
        boolean topologyChanged = this.topologyHasChanged(topologyCapabilities);
        boolean configChanged = this.queueConfigurationHasChanged(topologyCapabilities, queueManager);
        if (topologyChanged) {
            this.reassignJobs(topologyCapabilities, queueManager);
        }
        if (topologyChanged || configChanged) {
            this.assignUnassignedJobs(topologyCapabilities, queueManager);
        }
        if (topologyChanged && !this.checkedForPreviousVersion && topologyCapabilities != null && topologyCapabilities.isLeader()) {
            this.processJobsFromPreviousVersions(topologyCapabilities, queueManager);
        }
        if (topologyCapabilities != null) {
            String cleanUpAssignedPath = topologyCapabilities.isLeader() ? this.configuration.getUnassignedJobsPath() : null;
            if (cleanUpCounter % 60L == 0L) {
                this.fullEmptyFolderCleanup(topologyCapabilities, this.configuration.getLocalJobsPath());
                if (cleanUpAssignedPath != null) {
                    this.fullEmptyFolderCleanup(topologyCapabilities, cleanUpAssignedPath);
                }
            } else if (cleanUpCounter % 5L == 0L) {
                this.simpleEmptyFolderCleanup(topologyCapabilities, this.configuration.getLocalJobsPath());
                if (cleanUpAssignedPath != null) {
                    this.simpleEmptyFolderCleanup(topologyCapabilities, cleanUpAssignedPath);
                }
            }
        }
        if (cleanUpCounter % 3L == 0L) {
            this.lockCleanup(topologyCapabilities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCleanup(TopologyCapabilities caps) {
        if (caps != null && caps.isLeader()) {
            this.logger.debug("Cleaning up job resource tree: removing obsolete locks");
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Calendar startDate = Calendar.getInstance();
                startDate.add(12, -3);
                StringBuilder buf = new StringBuilder(64);
                buf.append("//element(*)[@");
                buf.append(ISO9075.encode("sling:resourceType"));
                buf.append(" = '");
                buf.append("slingevent:Lock");
                buf.append("' and @");
                buf.append(ISO9075.encode("lock.created"));
                buf.append(" < xs:dateTime('");
                buf.append(ISO8601.format(startDate));
                buf.append("')]");
                Iterator result = resolver.findResources(buf.toString(), "xpath");
                while (caps.isActive() && result.hasNext()) {
                    Resource lockResource = (Resource)result.next();
                    if (!this.configuration.isLock(lockResource.getPath())) continue;
                    try {
                        resolver.delete(lockResource);
                        resolver.commit();
                    }
                    catch (PersistenceException pe) {
                        this.ignoreException((Exception)((Object)pe));
                        resolver.refresh();
                    }
                }
            }
            catch (QuerySyntaxException qse) {
                this.ignoreException((Exception)((Object)qse));
            }
            catch (LoginException le) {
                this.ignoreException((Exception)((Object)le));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleEmptyFolderCleanup(TopologyCapabilities caps, String basePath) {
        this.logger.debug("Cleaning up job resource tree: looking for empty folders");
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Calendar cleanUpDate = Calendar.getInstance();
            cleanUpDate.add(10, -1);
            Resource baseResource = resolver.getResource(basePath);
            if (baseResource != null) {
                Iterator topicIter = baseResource.listChildren();
                while (caps.isActive() && topicIter.hasNext()) {
                    Resource topicResource = (Resource)topicIter.next();
                    for (int i = 0; i < 5; ++i) {
                        String hourPath;
                        Resource hourResource;
                        if (!caps.isActive()) continue;
                        StringBuilder sb = new StringBuilder(topicResource.getPath());
                        sb.append('/');
                        sb.append(cleanUpDate.get(1));
                        sb.append('/');
                        sb.append(cleanUpDate.get(2) + 1);
                        sb.append('/');
                        sb.append(cleanUpDate.get(5));
                        sb.append('/');
                        sb.append(cleanUpDate.get(11));
                        String path = sb.toString();
                        Resource dateResource = resolver.getResource(path);
                        if (dateResource != null && !dateResource.listChildren().hasNext()) {
                            resolver.delete(dateResource);
                            resolver.commit();
                        }
                        if (path.endsWith("59") && (hourResource = resolver.getResource(hourPath = path.substring(0, path.length() - 3))) != null && !hourResource.listChildren().hasNext()) {
                            resolver.delete(hourResource);
                            resolver.commit();
                        }
                        cleanUpDate.add(12, -1);
                    }
                }
            }
        }
        catch (PersistenceException pe) {
            this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
        }
        catch (LoginException ignore) {
            this.ignoreException((Exception)((Object)ignore));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullEmptyFolderCleanup(TopologyCapabilities caps, String basePath) {
        this.logger.debug("Cleaning up job resource tree: removing ALL empty folders");
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource baseResource = resolver.getResource(basePath);
            if (baseResource != null) {
                Calendar now = Calendar.getInstance();
                Iterator topicIter = baseResource.listChildren();
                while (caps.isActive() && topicIter.hasNext()) {
                    Resource topicResource = (Resource)topicIter.next();
                    Iterator yearIter = topicResource.listChildren();
                    while (caps.isActive() && yearIter.hasNext()) {
                        Resource yearResource = (Resource)yearIter.next();
                        int year = Integer.valueOf(yearResource.getName());
                        boolean oldYear = year < now.get(1);
                        Iterator monthIter = yearResource.listChildren();
                        while (caps.isActive() && monthIter.hasNext()) {
                            Resource monthResource = (Resource)monthIter.next();
                            int month = Integer.valueOf(monthResource.getName());
                            boolean oldMonth = oldYear || month < now.get(2) + 1;
                            Iterator dayIter = monthResource.listChildren();
                            while (caps.isActive() && dayIter.hasNext()) {
                                Resource dayResource = (Resource)dayIter.next();
                                int day = Integer.valueOf(dayResource.getName());
                                boolean oldDay = oldMonth || day < now.get(5);
                                Iterator hourIter = dayResource.listChildren();
                                while (caps.isActive() && hourIter.hasNext()) {
                                    boolean oldHour;
                                    Resource hourResource = (Resource)hourIter.next();
                                    int hour = Integer.valueOf(hourResource.getName());
                                    boolean bl = oldHour = oldDay && (oldMonth || now.get(11) > 0) || hour < now.get(11) - 1;
                                    if (oldHour) {
                                        Iterator minuteIter = hourResource.listChildren();
                                        while (caps.isActive() && minuteIter.hasNext()) {
                                            Resource minuteResource = (Resource)minuteIter.next();
                                            if (minuteResource.listChildren().hasNext()) continue;
                                            resolver.delete(minuteResource);
                                            resolver.commit();
                                        }
                                    }
                                    if (!caps.isActive() || !oldHour || hourResource.listChildren().hasNext()) continue;
                                    resolver.delete(hourResource);
                                    resolver.commit();
                                }
                                if (!caps.isActive() || !oldDay || dayResource.listChildren().hasNext()) continue;
                                resolver.delete(dayResource);
                                resolver.commit();
                            }
                            if (!caps.isActive() || !oldMonth || monthResource.listChildren().hasNext()) continue;
                            resolver.delete(monthResource);
                            resolver.commit();
                        }
                        if (!caps.isActive() || !oldYear || yearResource.listChildren().hasNext()) continue;
                        resolver.delete(yearResource);
                        resolver.commit();
                    }
                }
            }
        }
        catch (PersistenceException pe) {
            this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
        }
        catch (LoginException ignore) {
            this.ignoreException((Exception)((Object)ignore));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassignJob(JobImpl job, String targetId) {
        block12: {
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource jobResource = resolver.getResource(job.getResourcePath());
                if (jobResource == null) break block12;
                try {
                    ValueMap vm = ResourceHelper.getValueMap(jobResource);
                    String newPath = this.configuration.getUniquePath(targetId, job.getTopic(), job.getId(), job.getProperties());
                    HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                    props.remove("event.job.queuename");
                    if (targetId == null) {
                        props.remove("event.job.application");
                    } else {
                        props.put("event.job.application", targetId);
                    }
                    props.remove("event.job.started.time");
                    try {
                        ResourceHelper.getOrCreateResource(resolver, newPath, props);
                        resolver.delete(jobResource);
                        resolver.commit();
                    }
                    catch (PersistenceException pe) {
                        this.ignoreException((Exception)((Object)pe));
                    }
                }
                catch (InstantiationException ie) {
                    this.ignoreException(ie);
                }
            }
            catch (LoginException ignore) {
                this.ignoreException((Exception)((Object)ignore));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJobsFromPreviousVersions(TopologyCapabilities caps, QueueConfigurationManager queueManager) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            this.processJobsFromPreviousVersions(caps, queueManager, resolver.getResource(this.configuration.getPreviousVersionAnonPath()));
            this.processJobsFromPreviousVersions(caps, queueManager, resolver.getResource(this.configuration.getPreviousVersionIdentifiedPath()));
            this.checkedForPreviousVersion = true;
        }
        catch (PersistenceException pe) {
            this.logger.warn("Problems moving jobs from previous version.", (Throwable)pe);
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private void processJobsFromPreviousVersions(TopologyCapabilities caps, QueueConfigurationManager queueManager, Resource rsrc) throws PersistenceException {
        if (rsrc != null && caps.isActive()) {
            if (rsrc.isResourceType("slingevent:Job")) {
                this.moveJobFromPreviousVersion(caps, queueManager, rsrc);
            } else {
                for (Resource child : rsrc.getChildren()) {
                    this.processJobsFromPreviousVersions(caps, queueManager, child);
                }
                if (caps.isActive()) {
                    rsrc.getResourceResolver().delete(rsrc);
                    rsrc.getResourceResolver().commit();
                    rsrc.getResourceResolver().refresh();
                }
            }
        }
    }

    private void moveJobFromPreviousVersion(TopologyCapabilities caps, QueueConfigurationManager queueManager, Resource jobResource) throws PersistenceException {
        ResourceResolver resolver = jobResource.getResourceResolver();
        try {
            ValueMap vm = ResourceHelper.getValueMap(jobResource);
            HashMap<String, Object> binaryProperties = new HashMap<String, Object>();
            ObjectInputStream ois = (ObjectInputStream)vm.get("slingevent:properties", ObjectInputStream.class);
            if (ois != null) {
                try {
                    int length = ois.readInt();
                    for (int i = 0; i < length; ++i) {
                        String key = (String)ois.readObject();
                        Object value = ois.readObject();
                        binaryProperties.put(key, value);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PersistenceException("Class not found.", (Throwable)cnfe);
                }
                catch (InvalidClassException ice) {
                    throw new PersistenceException("Invalid class.", (Throwable)ice);
                }
                catch (IOException ioe) {
                    throw new PersistenceException("Unable to deserialize job properties.", (Throwable)ioe);
                }
                finally {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {
                        this.ignoreException(ioe);
                    }
                }
            }
            Map<String, Object> properties = ResourceHelper.cloneValueMap(vm);
            properties.put("slingevent:eventadmin", true);
            String topic = (String)properties.remove("slingevent:topic");
            properties.put("event.job.topic", topic);
            properties.remove("event.job.queuename");
            properties.remove("event.job.application");
            properties.putAll(binaryProperties);
            properties.remove("slingevent:properties");
            if (!properties.containsKey("event.job.retries")) {
                properties.put("event.job.retries", 10);
            }
            if (!properties.containsKey("event.job.retrycount")) {
                properties.put("event.job.retrycount", 0);
            }
            List<InstanceDescription> potentialTargets = caps.getPotentialTargets("/", null);
            String targetId = null;
            if (potentialTargets != null && potentialTargets.size() > 0) {
                QueueConfigurationManager.QueueInfo info = queueManager.getQueueInfo(topic);
                this.logger.debug("Found queue {} for {}", (Object)info.queueConfiguration, (Object)topic);
                if (info.queueConfiguration.getType() == QueueConfiguration.Type.DROP) {
                    resolver.delete(jobResource);
                    resolver.commit();
                    return;
                }
                if (info.queueConfiguration.getType() != QueueConfiguration.Type.IGNORE && (targetId = caps.detectTarget(topic, (Map<String, Object>)vm, info)) != null) {
                    properties.put("event.job.queuename", info.queueName);
                    properties.put("event.job.application", targetId);
                    properties.put("event.job.retries", info.queueConfiguration.getMaxRetries());
                }
            }
            properties.put("slingevent:application", "old:" + Environment.APPLICATION_ID);
            properties.put("sling:resourceType", "slingevent:Job");
            String jobId = this.configuration.getUniqueId(topic);
            properties.put("slingevent:eventId", jobId);
            properties.remove("event.job.started.time");
            String newPath = this.configuration.getUniquePath(targetId, topic, jobId, (Map<String, Object>)vm);
            this.logger.debug("Moving 'old' job from {} to {}", (Object)jobResource.getPath(), (Object)newPath);
            ResourceHelper.getOrCreateResource(resolver, newPath, properties);
            resolver.delete(jobResource);
            resolver.commit();
        }
        catch (InstantiationException ie) {
            throw new PersistenceException("Exception while reading reasource: " + ie.getMessage(), ie.getCause());
        }
    }
}

