/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.timed;

import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.impl.jobs.timed.ScheduleInfo;
import org.apache.sling.event.impl.jobs.timed.TimedEventConfiguration;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventHandler.class})
@Property(name="event.topics", value={"org/apache/sling/event/timed"})
public class TimedEventReceiver
implements EventHandler {
    public static final String RESOURCE_PROPERTY_TE_EXPRESSION = "slingevent:expression";
    public static final String RESOURCE_PROPERTY_TE_DATE = "slingevent:date";
    public static final String RESOURCE_PROPERTY_TE_PERIOD = "slingevent:period";
    public static final String TIMED_EVENT_RESOURCE_TYPE = "slingevent:TimedEvent";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private TimedEventConfiguration config;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private final BlockingQueue<Event> writeQueue = new LinkedBlockingQueue<Event>();
    private volatile boolean running;

    @Activate
    protected void activate() {
        this.running = true;
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ResourceResolver writerResolver = null;
                try {
                    writerResolver = TimedEventReceiver.this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                    ResourceHelper.getOrCreateBasePath(writerResolver, TimedEventReceiver.this.config.getResourcePath());
                    writerResolver.commit();
                }
                catch (Exception e) {
                    TimedEventReceiver.this.logger.error("Error during resource resolver creation.", (Throwable)e);
                    TimedEventReceiver.this.running = false;
                }
                finally {
                    if (writerResolver != null) {
                        writerResolver.close();
                        writerResolver = null;
                    }
                }
                try {
                    TimedEventReceiver.this.processWriteQueue();
                }
                catch (Throwable t) {
                    TimedEventReceiver.this.logger.error("Writer thread stopped with exception: " + t.getMessage(), t);
                    TimedEventReceiver.this.running = false;
                }
            }
        });
        writerThread.start();
    }

    @Deactivate
    protected void deactivate() {
        this.running = false;
        try {
            this.writeQueue.put(new Event("org/apache/sling/event/impl/jobs/STOPPED", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
    }

    private void processWriteQueue() {
        while (this.running) {
            Event event = null;
            try {
                event = this.writeQueue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (!this.running || event == null) continue;
            ScheduleInfo scheduleInfo = null;
            try {
                scheduleInfo = new ScheduleInfo(event);
                this.writeEvent(event, scheduleInfo);
            }
            catch (IllegalArgumentException iae) {
                this.logger.error(iae.getMessage(), (Throwable)iae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEvent(Event event, ScheduleInfo scheduleInfo) {
        block20: {
            ResourceResolver writerResolver = null;
            try {
                StringBuilder sb = new StringBuilder(this.config.getResourcePathWithSlash());
                sb.append(scheduleInfo.topic.replace('/', '.'));
                sb.append('/');
                sb.append(scheduleInfo.jobId);
                String path = sb.toString();
                writerResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource foundResource = writerResolver.getResource(path);
                if (scheduleInfo.isStopEvent()) {
                    this.logger.debug("Received stop event for {}", (Object)scheduleInfo.jobId);
                    if (foundResource != null) {
                        try {
                            writerResolver.delete(foundResource);
                            writerResolver.commit();
                        }
                        catch (PersistenceException pe) {
                            this.ignoreException((Exception)((Object)pe));
                        }
                    }
                    break block20;
                }
                this.logger.debug("Received start/update event for {}", (Object)scheduleInfo.jobId);
                if (foundResource != null) {
                    try {
                        writerResolver.delete(foundResource);
                        writerResolver.commit();
                    }
                    catch (PersistenceException pe) {
                        this.ignoreException((Exception)((Object)pe));
                        writerResolver.refresh();
                    }
                }
                try {
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    String[] propNames = event.getPropertyNames();
                    if (propNames != null && propNames.length > 0) {
                        for (String propName : propNames) {
                            if (ResourceHelper.ignoreProperty(propName)) continue;
                            properties.put(propName, event.getProperty(propName));
                        }
                    }
                    properties.put("event.topics", scheduleInfo.topic);
                    properties.put("slingevent:created", Calendar.getInstance());
                    if (scheduleInfo.date != null) {
                        Calendar c = Calendar.getInstance();
                        c.setTime(scheduleInfo.date);
                        properties.put(RESOURCE_PROPERTY_TE_DATE, c);
                    }
                    if (scheduleInfo.expression != null) {
                        properties.put(RESOURCE_PROPERTY_TE_EXPRESSION, scheduleInfo.expression);
                    }
                    if (scheduleInfo.period != null) {
                        properties.put(RESOURCE_PROPERTY_TE_PERIOD, scheduleInfo.period);
                    }
                    properties.put("sling:resourceType", TIMED_EVENT_RESOURCE_TYPE);
                    ResourceHelper.getOrCreateResource(writerResolver, path, properties);
                }
                catch (PersistenceException pe) {
                    this.ignoreException((Exception)((Object)pe));
                }
            }
            catch (LoginException le) {
                this.ignoreException((Exception)((Object)le));
            }
            finally {
                if (writerResolver != null) {
                    writerResolver.close();
                    writerResolver = null;
                }
            }
        }
    }

    public void handleEvent(Event event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received timed event {}", (Object)EventUtil.toString(event));
        }
        try {
            this.writeQueue.put(event);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    protected void bindConfig(TimedEventConfiguration timedEventConfiguration) {
        this.config = timedEventConfiguration;
    }

    protected void unbindConfig(TimedEventConfiguration timedEventConfiguration) {
        if (this.config == timedEventConfiguration) {
            this.config = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

