/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.dea;

import aQute.bnd.annotation.component.Deactivate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.dea.DistributedEventAdminConfiguration;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventHandler.class})
@Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/ADDED"})
public class DistributedEventSender
implements EventHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean running;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private DistributedEventAdminConfiguration config;
    @Reference
    private EventAdmin eventAdmin;

    @Activate
    protected void activate() {
        this.running = true;
        Thread backgroundThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributedEventSender.this.runInBackground();
                }
                catch (Throwable t) {
                    DistributedEventSender.this.logger.error("Background thread stopped with exception: " + t.getMessage(), t);
                    DistributedEventSender.this.running = false;
                }
            }
        });
        backgroundThread.start();
    }

    @Deactivate
    protected void deactivate() {
        this.running = false;
        try {
            this.queue.put("");
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    private Event readEvent(Resource eventResource) {
        try {
            ValueMap vm = ResourceHelper.getValueMap(eventResource);
            String topic = (String)vm.get("event.topics", String.class);
            Map<String, Object> properties = ResourceHelper.cloneValueMap(vm);
            List readErrorList = (List)properties.remove(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
            if (readErrorList == null) {
                properties.remove("event.topics");
                try {
                    String jobTopic;
                    if (topic.startsWith("org/apache/sling/event/notification/job/") && (jobTopic = (String)properties.get("event.job.topic")) != null) {
                        Event jobEvent = new Event(jobTopic, properties);
                        properties.put("event.notification.job", jobEvent);
                    }
                    Event event = new Event(topic, properties);
                    return event;
                }
                catch (IllegalArgumentException iae) {
                    this.logger.error("Unable to read event: " + iae.getMessage(), (Throwable)iae);
                }
            } else {
                for (Exception e : readErrorList) {
                    this.logger.warn("Unable to read distributed event from " + eventResource.getPath(), (Throwable)e);
                }
            }
        }
        catch (InstantiationException ie) {
            this.ignoreException(ie);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInBackground() {
        while (this.running) {
            String path = null;
            try {
                path = this.queue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
                Thread.currentThread().interrupt();
                this.running = false;
            }
            if (path == null || path.length() <= 0 || !this.running) continue;
            ResourceResolver resolver = null;
            try {
                Event e;
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource eventResource = resolver.getResource(path);
                if (!eventResource.isResourceType("slingevent:Event") || (e = this.readEvent(eventResource)) == null) continue;
                EventAdmin localEA = this.eventAdmin;
                if (localEA != null) {
                    localEA.postEvent(e);
                    continue;
                }
                this.logger.error("Unable to post event as no event admin is available.");
            }
            catch (LoginException ex) {
                this.logger.error("Exception during creation of resource resolver.", (Throwable)ex);
            }
            finally {
                if (resolver == null) continue;
                resolver.close();
            }
        }
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        if (path != null && path.startsWith(this.config.getRootPathWithSlash()) && !path.startsWith(this.config.getOwnRootPathWithSlash())) {
            try {
                this.queue.put(path);
            }
            catch (InterruptedException ex) {
                this.ignoreException(ex);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConfig(DistributedEventAdminConfiguration distributedEventAdminConfiguration) {
        this.config = distributedEventAdminConfiguration;
    }

    protected void unbindConfig(DistributedEventAdminConfiguration distributedEventAdminConfiguration) {
        if (this.config == distributedEventAdminConfiguration) {
            this.config = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

