/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.impl.support.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundLoader
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private final ResourceResolverFactory resourceResolverFactory;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private volatile boolean running = false;
    private final JobManagerImpl jobManager;
    private final Object loadLock = new Object();
    private final Object stopLock = new Object();
    private final Set<String> unloadedJobs = new HashSet<String>();
    private final BlockingQueue<Object> actionQueue = new LinkedBlockingQueue<Object>();
    private boolean firstRun = true;
    private static final String END_TOKEN = "*";

    public BackgroundLoader(JobManagerImpl jobManagerImpl, JobManagerConfiguration configuration2, ResourceResolverFactory resourceResolverFactory2) {
        this.resourceResolverFactory = resourceResolverFactory2;
        this.configuration = configuration2;
        this.jobManager = jobManagerImpl;
        this.active.set(true);
        Thread loaderThread = new Thread((Runnable)this, "Apache Sling Job Background Loader");
        loaderThread.setDaemon(true);
        loaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        this.active.set(false);
        Object object = this.loadLock;
        synchronized (object) {
            this.running = false;
            this.loadLock.notify();
        }
        this.stop();
        object = this.stopLock;
        synchronized (object) {
            this.stopLock.notify();
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.loadLock;
        synchronized (object) {
            this.running = true;
            this.actionQueue.clear();
            this.unloadedJobs.clear();
            this.loadLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.loadLock;
        synchronized (object) {
            this.running = false;
        }
        try {
            this.actionQueue.put(END_TOKEN);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    public void restart() {
        if (this.isRunning()) {
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.active.get()) {
            long startTime;
            Object object = this.loadLock;
            synchronized (object) {
                while (this.active.get() && !this.running) {
                    try {
                        this.loadLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.active.set(false);
                    }
                }
                startTime = System.currentTimeMillis();
            }
            if (this.isRunning()) {
                object = this.stopLock;
                synchronized (object) {
                    try {
                        this.stopLock.wait(1000L * this.configuration.getBackgroundLoadDelay());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.active.set(false);
                    }
                }
            }
            if (this.isRunning()) {
                this.loadJobsInTheBackground(startTime);
            }
            if (this.isRunning()) {
                this.firstRun = false;
            }
            while (this.isRunning()) {
                String path;
                Object nextPathOrJob = null;
                try {
                    nextPathOrJob = this.actionQueue.take();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                    this.active.set(false);
                }
                if (nextPathOrJob instanceof JobImpl) {
                    this.jobManager.process((JobImpl)nextPathOrJob);
                    continue;
                }
                if (!(nextPathOrJob instanceof String) || END_TOKEN.equals(path = (String)nextPathOrJob) || !this.isRunning()) continue;
                ResourceResolver resolver = null;
                try {
                    resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                    Resource resource = resolver.getResource(path);
                    if (resource == null) {
                        this.logger.warn("No job resource found for path {}. Potential job will not be processed.", (Object)path);
                        continue;
                    }
                    if (!"slingevent:Job".equals(resource.getResourceType())) continue;
                    this.logger.debug("Reading local job from {}", (Object)path);
                    JobImpl job = this.jobManager.readJob(resource);
                    if (job == null) continue;
                    if (job.hasReadErrors()) {
                        Set<String> set = this.unloadedJobs;
                        synchronized (set) {
                            this.unloadedJobs.add(path);
                            continue;
                        }
                    }
                    this.jobManager.process(job);
                }
                catch (LoginException le) {
                    this.ignoreException((Exception)((Object)le));
                }
                finally {
                    if (resolver == null) continue;
                    resolver.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobsInTheBackground(long startTime) {
        this.logger.debug("Starting background loading...");
        ResourceResolver resolver = null;
        long count = 0L;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Calendar startDate = Calendar.getInstance();
            startDate.setTimeInMillis(startTime);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append(ISO9075.encode("event.job.application"));
            buf.append(" = '");
            buf.append(Environment.APPLICATION_ID);
            buf.append("' and @");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" < xs:dateTime('");
            buf.append(ISO8601.format(startDate));
            buf.append("')");
            buf.append("] order by @");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" ascending");
            if (this.isRunning()) {
                Iterator result = resolver.findResources(buf.toString(), "xpath");
                while (this.isRunning() && result.hasNext()) {
                    Resource jobResource = (Resource)result.next();
                    if (!this.loadJobInTheBackground(jobResource)) continue;
                    ++count;
                }
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        this.logger.debug("Finished background loading of {} jobs.", (Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadJobInTheBackground(Resource jobResource) {
        JobImpl job;
        if (this.configuration.isLocalJob(jobResource.getPath()) && (job = this.jobManager.readJob(jobResource)) != null && (this.firstRun || job.getProcessingStarted() == null)) {
            if (job.getProcessingStarted() != null && this.isRunning()) {
                job.retry();
                try {
                    ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                    mvm.remove((Object)"event.job.started.time");
                    mvm.put((Object)"event.job.retrycount", (Object)job.getRetryCount());
                    jobResource.getResourceResolver().commit();
                }
                catch (PersistenceException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
            if (job.hasReadErrors()) {
                Set<String> set = this.unloadedJobs;
                synchronized (set) {
                    this.unloadedJobs.add(job.getResourcePath());
                }
            } else if (this.isRunning()) {
                this.jobManager.process(job);
            }
            return true;
        }
        return false;
    }

    private boolean isRunning() {
        return this.active.get() && this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToReloadUnloadedJobs() {
        final HashSet<String> copyUnloadedJobs = new HashSet<String>();
        Set<String> set = this.unloadedJobs;
        synchronized (set) {
            copyUnloadedJobs.addAll(this.unloadedJobs);
            this.unloadedJobs.clear();
        }
        if (copyUnloadedJobs.size() > 0) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Iterator iter = copyUnloadedJobs.iterator();
                    while (iter.hasNext()) {
                        Object object = BackgroundLoader.this.loadLock;
                        synchronized (object) {
                            if (BackgroundLoader.this.isRunning()) {
                                try {
                                    BackgroundLoader.this.actionQueue.put(iter.next());
                                }
                                catch (InterruptedException e) {
                                    BackgroundLoader.this.ignoreException(e);
                                    Thread.currentThread().interrupt();
                                    BackgroundLoader.this.running = false;
                                }
                            }
                        }
                    }
                }
            };
            Environment.THREAD_POOL.execute(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJob(String path) {
        Object object = this.loadLock;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    this.actionQueue.put(path);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobImpl job) {
        Object object = this.loadLock;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    this.actionQueue.put(job);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

