/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.event.impl.jobs.JobBuilderImpl;
import org.apache.sling.event.impl.jobs.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.impl.jobs.ScheduledJobInfoImpl;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerImpl
implements EventHandler,
TopologyEventListener,
Job {
    private static final String TOPIC_READ_JOB = "org/apache/sling/event/impl/jobs/READSCHEDULEDJOB";
    private static final String PROPERTY_READ_JOB = "properties";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean running;
    private volatile boolean active;
    private final ResourceResolverFactory resourceResolverFactory;
    private final JobManagerConfiguration config;
    private final Scheduler scheduler;
    private final JobManagerImpl jobManager;
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private final Set<String> unloadedEvents = new HashSet<String>();
    private final Map<String, ScheduledJobInfoImpl> scheduledJobs = new HashMap<String, ScheduledJobInfoImpl>();

    public JobSchedulerImpl(JobManagerConfiguration configuration, ResourceResolverFactory resourceResolverFactory, Scheduler scheduler, JobManagerImpl jobManager) {
        this.config = configuration;
        this.resourceResolverFactory = resourceResolverFactory;
        this.scheduler = scheduler;
        this.running = true;
        this.jobManager = jobManager;
        final long now = System.currentTimeMillis();
        Thread backgroundThread = new Thread(new Runnable(){

            @Override
            public void run() {
                JobSchedulerImpl.this.loadScheduledJobs(now);
                try {
                    JobSchedulerImpl.this.runInBackground();
                }
                catch (Throwable t) {
                    JobSchedulerImpl.this.logger.error("Background thread stopped with exception: " + t.getMessage(), t);
                    JobSchedulerImpl.this.running = false;
                }
            }
        });
        backgroundThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        this.running = false;
        this.stopScheduling();
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            this.scheduledJobs.clear();
        }
        this.queue.clear();
        try {
            this.queue.put(new Event("org/apache/sling/event/impl/jobs/STOPPED", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    private void stopScheduling() {
        if (this.active) {
            Collection<ScheduledJobInfo> jobs = this.getScheduledJobs();
            for (ScheduledJobInfo info : jobs) {
                this.stopScheduledJob((ScheduledJobInfoImpl)info);
            }
        }
    }

    private void startScheduling() {
        if (this.active) {
            Collection<ScheduledJobInfo> jobs = this.getScheduledJobs();
            for (ScheduledJobInfo info : jobs) {
                this.startScheduledJob((ScheduledJobInfoImpl)info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void runInBackground() {
        event = null;
        while (this.running) {
            if (event == null) {
                try {
                    event = this.queue.take();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                    this.running = false;
                }
            }
            if (event == null || !this.running) continue;
            nextEvent = null;
            if (event.getTopic().equals("org/apache/sling/event/impl/jobs/READSCHEDULEDJOB")) {
                properties = (Map)event.getProperty("properties");
                info = this.addOrUpdateScheduledJob(properties);
                if (this.active) {
                    this.startScheduledJob(info);
                }
            }
            if (event.getTopic().equals("org/apache/sling/api/resource/Resource/ADDED") || event.getTopic().equals("org/apache/sling/api/resource/Resource/CHANGED")) {
                path = (String)event.getProperty("path");
                resolver = null;
                try {
                    resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                    eventResource = resolver.getResource(path);
                    if (!"slingevent:TimedEvent".equals(eventResource.getResourceType()) || (result = this.readScheduledJob(eventResource)) == null) ** GOTO lbl55
                    if (result.hasReadErrors) {
                        var7_9 = this.unloadedEvents;
                        synchronized (var7_9) {
                            this.unloadedEvents.add(eventResource.getPath());
                        }
                    }
                    nextEvent = result.event;
                }
                catch (LoginException le) {
                    this.ignoreException((Exception)le);
                }
                finally {
                    if (resolver != null) {
                        resolver.close();
                    }
                }
            } else if (event.getTopic().equals("org/apache/sling/api/resource/Resource/REMOVED")) {
                path = (String)event.getProperty("path");
                scheduleName = ResourceUtil.getName((String)path);
                var6_8 = this.scheduledJobs;
                synchronized (var6_8) {
                    info = this.scheduledJobs.remove(scheduleName);
                }
                if (info != null && this.active) {
                    this.stopScheduledJob(info);
                }
            }
lbl55:
            // 9 sources

            event = nextEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledJobInfoImpl addOrUpdateScheduledJob(Map<String, Object> properties) {
        ScheduledJobInfoImpl info;
        properties.remove("sling:resourceType");
        properties.remove("slingevent:created");
        properties.remove("slingevent:application");
        String jobTopic = (String)properties.remove("event.job.topic");
        String schedulerName = (String)properties.remove("slingevent:scheduleName");
        List scheduleInfos = (List)properties.remove("slingevent:scheduleInfo");
        boolean isSuspended = properties.remove("slingevent:scheduleSuspended") != null;
        String key = ResourceHelper.filterName(schedulerName);
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            info = this.scheduledJobs.get(key);
            if (info == null) {
                info = new ScheduledJobInfoImpl(this, jobTopic, properties, schedulerName);
                this.scheduledJobs.put(key, info);
            }
            info.update(isSuspended, scheduleInfos);
        }
        return info;
    }

    private void startScheduledJob(ScheduledJobInfoImpl info) {
        if (!info.isSuspended()) {
            HashMap<String, ScheduledJobInfoImpl> config = new HashMap<String, ScheduledJobInfoImpl>();
            config.put(PROPERTY_READ_JOB, info);
            this.logger.debug("Adding scheduled job: {}", (Object)info.getName());
            int index = 0;
            for (ScheduleInfo si : info.getSchedules()) {
                String name = info.getSchedulerJobId() + "-" + String.valueOf(index);
                ScheduleOptions options = null;
                switch (si.getType()) {
                    case DAILY: 
                    case WEEKLY: 
                    case HOURLY: 
                    case MONTHLY: 
                    case YEARLY: 
                    case CRON: {
                        options = this.scheduler.EXPR(((ScheduleInfoImpl)si).getCronExpression());
                        break;
                    }
                    case DATE: {
                        options = this.scheduler.AT(((ScheduleInfoImpl)si).getNextScheduledExecution());
                    }
                }
                this.scheduler.schedule((Object)this, options.name(name).config(config).canRunConcurrently(false));
                ++index;
            }
        }
    }

    private void stopScheduledJob(ScheduledJobInfoImpl info) {
        this.logger.debug("Stopping scheduled job : {}", (Object)info.getName());
        for (int index = 0; index < info.getSchedules().size(); ++index) {
            String name = info.getSchedulerJobId() + "-" + String.valueOf(index);
            this.scheduler.unschedule(name);
        }
    }

    public void execute(JobContext context) {
        ScheduledJobInfoImpl info = (ScheduledJobInfoImpl)context.getConfiguration().get(PROPERTY_READ_JOB);
        this.jobManager.addJob(info.getJobTopic(), info.getJobProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(ScheduledJobInfoImpl info) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder sb = new StringBuilder(this.config.getScheduledJobsPathWithSlash());
            sb.append('/');
            sb.append(ResourceHelper.filterName(info.getName()));
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                resolver.delete(eventResource);
                resolver.commit();
            }
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        catch (PersistenceException pe) {
            this.ignoreException((Exception)((Object)pe));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (this.running) {
            if ("org/osgi/framework/BundleEvent/STARTED".equals(event.getTopic()) || "org/osgi/framework/BundleEvent/UPDATED".equals(event.getTopic())) {
                boolean doIt = false;
                Set<String> set = this.unloadedEvents;
                synchronized (set) {
                    if (this.unloadedEvents.size() > 0) {
                        doIt = true;
                    }
                }
                if (doIt) {
                    Runnable t = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Set set = JobSchedulerImpl.this.unloadedEvents;
                            synchronized (set) {
                                ResourceResolver resolver = null;
                                HashSet<String> newUnloadedEvents = new HashSet<String>();
                                newUnloadedEvents.addAll(JobSchedulerImpl.this.unloadedEvents);
                                try {
                                    resolver = JobSchedulerImpl.this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                                    for (String path : JobSchedulerImpl.this.unloadedEvents) {
                                        newUnloadedEvents.remove(path);
                                        Resource eventResource = resolver.getResource(path);
                                        ReadResult result = JobSchedulerImpl.this.readScheduledJob(eventResource);
                                        if (result == null) continue;
                                        if (result.hasReadErrors) {
                                            newUnloadedEvents.add(path);
                                            continue;
                                        }
                                        try {
                                            JobSchedulerImpl.this.queue.put(result.event);
                                        }
                                        catch (InterruptedException e) {
                                            JobSchedulerImpl.this.ignoreException(e);
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                }
                                catch (LoginException re) {
                                    JobSchedulerImpl.this.ignoreException((Exception)((Object)re));
                                }
                                finally {
                                    if (resolver != null) {
                                        resolver.close();
                                    }
                                    JobSchedulerImpl.this.unloadedEvents.clear();
                                    JobSchedulerImpl.this.unloadedEvents.addAll(newUnloadedEvents);
                                }
                            }
                        }
                    };
                    Environment.THREAD_POOL.execute(t);
                }
            } else {
                String path = (String)event.getProperty("path");
                String resourceType = (String)event.getProperty("resourceType");
                if (path != null && path.startsWith(this.config.getScheduledJobsPathWithSlash()) && (resourceType == null || "slingevent:TimedEvent".equals(resourceType))) {
                    this.logger.debug("Received resource event for {} : {}", (Object)path, (Object)resourceType);
                    try {
                        this.queue.put(event);
                    }
                    catch (InterruptedException ignore) {
                        this.ignoreException(ignore);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScheduledJobs(long startTime) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Calendar startDate = Calendar.getInstance();
            startDate.setTimeInMillis(startTime);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:TimedEvent");
            buf.append(")[@");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" < xs:dateTime('");
            buf.append(ISO8601.format(startDate));
            buf.append("')] order by @");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" ascending");
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                ReadResult readResult;
                Resource eventResource = (Resource)result.next();
                if (!eventResource.getPath().startsWith(this.config.getScheduledJobsPathWithSlash()) || (readResult = this.readScheduledJob(eventResource)) == null) continue;
                if (readResult.hasReadErrors) {
                    Set<String> set = this.unloadedEvents;
                    synchronized (set) {
                        this.unloadedEvents.add(eventResource.getPath());
                        continue;
                    }
                }
                try {
                    this.queue.put(readResult.event);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private ReadResult readScheduledJob(Resource eventResource) {
        if (eventResource != null) {
            try {
                ValueMap vm = ResourceHelper.getValueMap(eventResource);
                Map<String, Object> properties = ResourceHelper.cloneValueMap(vm);
                ReadResult result = new ReadResult();
                List readErrorList = (List)properties.remove(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
                boolean bl = result.hasReadErrors = readErrorList != null;
                if (readErrorList != null) {
                    for (Exception e : readErrorList) {
                        this.logger.warn("Unable to read scheduled job from " + eventResource.getPath(), (Throwable)e);
                    }
                }
                Map<String, Map<String, Object>> eventProps = Collections.singletonMap(PROPERTY_READ_JOB, properties);
                result.event = new Event(TOPIC_READ_JOB, eventProps);
                return result;
            }
            catch (InstantiationException ie) {
                this.ignoreException(ie);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledJobInfoImpl writeJob(String jobTopic, String jobName, Map<String, Object> jobProperties, String scheduleName, boolean suspend, List<ScheduleInfoImpl> scheduleInfos) throws PersistenceException {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (jobProperties != null) {
                for (Map.Entry<String, Object> entry : jobProperties.entrySet()) {
                    String propName = entry.getKey();
                    if (ResourceHelper.ignoreProperty(propName)) continue;
                    properties.put(propName, entry.getValue());
                }
            }
            properties.put("event.job.topic", jobTopic);
            if (jobName != null) {
                properties.put("event.job.id", jobName);
            }
            properties.put("slingevent:created", Calendar.getInstance());
            properties.put("slingevent:application", Environment.APPLICATION_ID);
            properties.put("slingevent:scheduleName", scheduleName);
            String[] infoArray = new String[scheduleInfos.size()];
            int index = 0;
            for (ScheduleInfoImpl info : scheduleInfos) {
                infoArray[index] = info.getSerializedString();
                ++index;
            }
            properties.put("slingevent:scheduleInfo", infoArray);
            if (suspend) {
                properties.put("slingevent:scheduleSuspended", Boolean.TRUE);
            }
            properties.put("sling:resourceType", "slingevent:TimedEvent");
            String path = this.config.getScheduledJobsPathWithSlash() + ResourceHelper.filterName(scheduleName);
            Resource existingInfo = resolver.getResource(path);
            if (existingInfo != null) {
                resolver.delete(existingInfo);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Updating scheduled job {} at {}", properties, (Object)path);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Storing new scheduled job {} at {}", properties, (Object)path);
            }
            ResourceHelper.getOrCreateResource(resolver, path, properties);
            properties.put("slingevent:scheduleInfo", scheduleInfos);
            ScheduledJobInfoImpl scheduledJobInfoImpl = this.addOrUpdateScheduledJob(properties);
            return scheduledJobInfoImpl;
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return null;
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            this.active = false;
            this.stopScheduling();
        } else if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.TOPOLOGY_INIT) {
            boolean previouslyActive = this.active;
            this.active = event.getNewView().getLocalInstance().isLeader();
            if (this.active && !previouslyActive) {
                this.startScheduling();
            }
            if (!this.active && previouslyActive) {
                this.stopScheduling();
            }
        }
    }

    public JobBuilder.ScheduleBuilder createJobBuilder(ScheduledJobInfoImpl info) {
        JobBuilderImpl builder = (JobBuilderImpl)this.jobManager.createJob(info.getJobTopic()).properties(info.getJobProperties());
        JobBuilder.ScheduleBuilder sb = builder.schedule(info.getName());
        return info.isSuspended() ? sb.suspend() : sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ScheduledJobInfo> getScheduledJobs() {
        ArrayList<ScheduledJobInfo> jobs = new ArrayList<ScheduledJobInfo>();
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            for (ScheduledJobInfoImpl job : this.scheduledJobs.values()) {
                jobs.add(job);
            }
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(ScheduledJobInfoImpl info, boolean flag) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder sb = new StringBuilder(this.config.getScheduledJobsPathWithSlash());
            sb.append('/');
            sb.append(ResourceHelper.filterName(info.getName()));
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                ModifiableValueMap mvm = (ModifiableValueMap)eventResource.adaptTo(ModifiableValueMap.class);
                if (flag) {
                    mvm.put((Object)"slingevent:scheduleSuspended", (Object)Boolean.TRUE);
                } else {
                    mvm.remove((Object)"slingevent:scheduleSuspended");
                }
                resolver.commit();
            }
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        catch (PersistenceException pe) {
            this.ignoreException((Exception)((Object)pe));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private static final class ReadResult {
        public Event event;
        public boolean hasReadErrors;

        private ReadResult() {
        }
    }
}

