/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.Date;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.osgi.service.event.EventAdmin;

public abstract class AbstractParallelJobQueue
extends AbstractJobQueue {
    protected volatile int jobCount;
    private final Scheduler scheduler;
    private final Object syncLock = new Object();

    public AbstractParallelJobQueue(String name, InternalQueueConfiguration config, JobConsumerManager jobConsumerManager, ThreadPoolManager threadPoolManager, EventAdmin eventAdmin, Scheduler scheduler) {
        super(name, config, jobConsumerManager, threadPoolManager, eventAdmin);
        this.scheduler = scheduler;
    }

    @Override
    public String getStateInfo() {
        return super.getStateInfo() + ", jobCount=" + this.jobCount;
    }

    @Override
    protected JobHandler start(JobHandler processInfo) {
        this.acquireSlot();
        if (this.isOutdated()) {
            this.freeSlot();
            return null;
        }
        if (!this.executeJob(processInfo)) {
            this.freeSlot();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireSlot() {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.jobCount >= this.configuration.getMaxParallel()) {
                this.isWaiting = true;
                this.logger.debug("Job queue {} is processing {} jobs - waiting for a free slot.", (Object)this.queueName, (Object)this.jobCount);
                while (this.isWaiting) {
                    try {
                        this.syncLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                        Thread.currentThread().interrupt();
                    }
                }
                this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
            }
            ++this.jobCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSlot() {
        Object object = this.syncLock;
        synchronized (object) {
            --this.jobCount;
            if (this.isWaiting) {
                this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
                this.isWaiting = false;
                this.syncLock.notify();
            }
        }
    }

    @Override
    protected boolean canBeClosed() {
        boolean result = super.canBeClosed();
        if (result) {
            result = this.jobCount == 0;
        }
        return result;
    }

    @Override
    protected void notifyFinished(JobHandler rescheduleInfo) {
        this.freeSlot();
    }

    @Override
    protected JobHandler reschedule(final JobHandler info) {
        long delay = this.getRetryDelay(info);
        if (delay > 0L) {
            Date fireDate = new Date();
            fireDate.setTime(System.currentTimeMillis() + delay);
            String jobName = "Waiting:" + this.queueName + ":" + info.hashCode();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    AbstractParallelJobQueue.this.put(info);
                }
            };
            this.scheduler.schedule((Object)t, this.scheduler.AT(fireDate).name(jobName));
        } else {
            this.put(info);
        }
        return null;
    }
}

