/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={JobExecutor.class})
@Property(name="job.topics", value={"org/apache/sling/event/impl/jobs/tasks/HistoryCleanUpTask"})
public class HistoryCleanUpTask
implements JobExecutor {
    private static final String PROPERTY_AGE = "age";
    private static final String PROPERTY_TOPIC = "topic";
    private static final String PROPERTY_STATE = "state";
    private static final int DEFAULT_AGE = 2880;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private JobManager jobManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecutionResult process(Job job, JobExecutionContext context) {
        ArrayList<String> stateList;
        int age = job.getProperty(PROPERTY_AGE, 2880);
        if (age < 1) {
            age = 2880;
        }
        Calendar removeDate = Calendar.getInstance();
        removeDate.add(12, -age);
        Object[] topics = (String[])job.getProperty(PROPERTY_TOPIC, String[].class);
        Object[] states = (String[])job.getProperty(PROPERTY_STATE, String[].class);
        String logTopics = topics == null ? "ALL" : Arrays.toString(topics);
        String logStates = states == null ? "ALL" : Arrays.toString(states);
        context.log("Cleaning up job history. Removing all jobs older than {0}, with topics {1} and states {2}", removeDate, logTopics, logStates);
        if (states != null) {
            stateList = new ArrayList<String>();
            for (Object s : states) {
                stateList.add((String)s);
            }
        } else {
            stateList = null;
        }
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            if (stateList == null || stateList.contains(Job.JobState.SUCCEEDED.name())) {
                this.cleanup(removeDate, resolver, context, ((JobManagerImpl)this.jobManager).getConfiguration().getStoredSuccessfulJobsPath(), (String[])topics, null);
            }
            if (stateList == null || stateList.contains(Job.JobState.DROPPED.name()) || stateList.contains(Job.JobState.ERROR.name()) || stateList.contains(Job.JobState.GIVEN_UP.name()) || stateList.contains(Job.JobState.STOPPED.name())) {
                this.cleanup(removeDate, resolver, context, ((JobManagerImpl)this.jobManager).getConfiguration().getStoredCancelledJobsPath(), (String[])topics, stateList);
            }
        }
        catch (PersistenceException pe) {
            this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
        }
        catch (LoginException ignore) {
            this.ignoreException((Exception)((Object)ignore));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return context.result().succeeded();
    }

    private void cleanup(Calendar removeDate, ResourceResolver resolver, JobExecutionContext context, String basePath, String[] topics, List<String> stateList) throws PersistenceException {
        Resource baseResource = resolver.getResource(basePath);
        if (baseResource != null) {
            Iterator topicIter = baseResource.listChildren();
            while (!context.isStopped() && topicIter.hasNext()) {
                Resource topicResource = (Resource)topicIter.next();
                boolean found = topics == null;
                for (int index = 0; !found && index < topics.length; ++index) {
                    if (!topicResource.getName().equals(topics[index])) continue;
                    found = true;
                }
                if (!found) continue;
                Iterator yearIter = topicResource.listChildren();
                while (!context.isStopped() && yearIter.hasNext()) {
                    Resource yearResource = (Resource)yearIter.next();
                    int year = Integer.valueOf(yearResource.getName());
                    boolean oldYear = year < removeDate.get(1);
                    Iterator monthIter = yearResource.listChildren();
                    while (!context.isStopped() && monthIter.hasNext()) {
                        Resource monthResource = (Resource)monthIter.next();
                        int month = Integer.valueOf(monthResource.getName());
                        boolean oldMonth = oldYear || month < removeDate.get(2) + 1;
                        Iterator dayIter = monthResource.listChildren();
                        while (!context.isStopped() && dayIter.hasNext()) {
                            Resource dayResource = (Resource)dayIter.next();
                            int day = Integer.valueOf(dayResource.getName());
                            boolean oldDay = oldMonth || day < removeDate.get(5);
                            Iterator hourIter = dayResource.listChildren();
                            while (!context.isStopped() && hourIter.hasNext()) {
                                Resource hourResource = (Resource)hourIter.next();
                                int hour = Integer.valueOf(hourResource.getName());
                                boolean oldHour = oldDay || hour < removeDate.get(11);
                                Iterator minuteIter = hourResource.listChildren();
                                while (!context.isStopped() && minuteIter.hasNext()) {
                                    boolean oldMinute;
                                    Resource minuteResource = (Resource)minuteIter.next();
                                    int minute = Integer.valueOf(minuteResource.getName());
                                    boolean bl = oldMinute = oldHour || minute <= removeDate.get(12);
                                    if (oldMinute) {
                                        Iterator jobIter = minuteResource.listChildren();
                                        while (!context.isStopped() && jobIter.hasNext()) {
                                            ValueMap vm;
                                            String state;
                                            boolean remove;
                                            Resource jobResource = (Resource)jobIter.next();
                                            boolean bl2 = remove = stateList == null;
                                            if (!remove && (state = (String)(vm = ResourceUtil.getValueMap((Resource)jobResource)).get("slingevent:finishedState", String.class)) != null && stateList.contains(state)) {
                                                remove = true;
                                            }
                                            if (!remove) continue;
                                            resolver.delete(jobResource);
                                            resolver.commit();
                                        }
                                    }
                                    if (context.isStopped() || !oldMinute || minuteResource.listChildren().hasNext()) continue;
                                    resolver.delete(minuteResource);
                                    resolver.commit();
                                }
                                if (context.isStopped() || !oldHour || hourResource.listChildren().hasNext()) continue;
                                resolver.delete(hourResource);
                                resolver.commit();
                            }
                            if (context.isStopped() || !oldDay || dayResource.listChildren().hasNext()) continue;
                            resolver.delete(dayResource);
                            resolver.commit();
                        }
                        if (context.isStopped() || !oldMonth || monthResource.listChildren().hasNext()) continue;
                        resolver.delete(monthResource);
                        resolver.commit();
                    }
                    if (context.isStopped() || !oldYear || yearResource.listChildren().hasNext()) continue;
                    resolver.delete(yearResource);
                    resolver.commit();
                }
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }
}

