/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.event.impl.jobs.JobBuilderImpl;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobSchedulerImpl;
import org.apache.sling.event.impl.jobs.ScheduledJobInfoImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.ConfigurationChangeListener;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.notifications.NotificationUtility;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.apache.sling.event.impl.jobs.queues.QueueManager;
import org.apache.sling.event.impl.jobs.stats.StatisticsManager;
import org.apache.sling.event.impl.jobs.tasks.CleanUpTask;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.JobsIterator;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.apache.sling.event.jobs.jmx.QueuesMBean;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={JobManager.class, EventHandler.class, Runnable.class})
@Properties(value={@Property(name="scheduler.period", longValue={60L}), @Property(name="scheduler.concurrent", boolValue={false}), @Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED", "org/osgi/framework/BundleEvent/STARTED", "org/osgi/framework/BundleEvent/UPDATED"})})
public class JobManagerImpl
implements JobManager,
EventHandler,
Runnable,
ConfigurationChangeListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private Scheduler scheduler;
    @Reference
    private JobConsumerManager jobConsumerManager;
    @Reference
    private QueuesMBean queuesMBean;
    @Reference
    private ThreadPoolManager threadPoolManager;
    @Reference
    private JobManagerConfiguration configuration;
    @Reference
    private StatisticsManager statisticsManager;
    @Reference
    private QueueManager qManager;
    private volatile TopologyCapabilities topologyCapabilities;
    private CleanUpTask maintenanceTask;
    private volatile long schedulerRuns;
    private JobSchedulerImpl jobScheduler;

    @Activate
    protected void activate(Map<String, Object> props) throws LoginException {
        this.jobScheduler = new JobSchedulerImpl(this.configuration, this.scheduler, this);
        this.maintenanceTask = new CleanUpTask(this.configuration);
        this.configuration.addListener(this);
        this.logger.info("Apache Sling Job Manager started on instance {}", (Object)Environment.APPLICATION_ID);
    }

    @Deactivate
    protected void deactivate() {
        this.logger.info("Apache Sling Job Manager stopping on instance {}", (Object)Environment.APPLICATION_ID);
        this.configuration.removeListener(this);
        this.jobScheduler.deactivate();
        this.maintenanceTask = null;
        this.logger.info("Apache Sling Job Manager stopped on instance {}", (Object)Environment.APPLICATION_ID);
    }

    private void maintain() {
        ++this.schedulerRuns;
        this.logger.debug("Job manager maintenance: Starting #{}", (Object)this.schedulerRuns);
        CleanUpTask task = this.maintenanceTask;
        if (task != null) {
            task.run(this.topologyCapabilities, this.schedulerRuns - 1L);
        }
        this.logger.debug("Job manager maintenance: Finished #{}", (Object)this.schedulerRuns);
    }

    @Override
    public void run() {
        this.maintain();
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void restart() {
        this.logger.warn("Deprecated JobManager.restart() is called.");
    }

    @Override
    public boolean isJobProcessingEnabled() {
        return true;
    }

    public void handleEvent(Event event) {
        this.jobScheduler.handleEvent(event);
    }

    @Override
    public void configurationChanged(boolean active) {
        this.topologyCapabilities = !active ? null : this.configuration.getTopologyCapabilities();
    }

    @Override
    public synchronized Statistics getStatistics() {
        return this.statisticsManager.getGlobalStatistics();
    }

    @Override
    public Iterable<TopicStatistics> getTopicStatistics() {
        return this.statisticsManager.getTopicStatistics().values();
    }

    @Override
    public Queue getQueue(String name) {
        return this.qManager.getQueue(ResourceHelper.filterQueueName(name));
    }

    @Override
    public Iterable<Queue> getQueues() {
        return this.qManager.getQueues();
    }

    @Override
    public JobsIterator queryJobs(JobManager.QueryType type, String topic, Map<String, Object> ... templates) {
        return this.queryJobs(type, topic, -1L, templates);
    }

    @Override
    public JobsIterator queryJobs(JobManager.QueryType type, String topic, long limit, Map<String, Object> ... templates) {
        final Collection<Job> list = this.findJobs(type, topic, limit, templates);
        final Iterator<Job> iter = list.iterator();
        return new JobsIterator(){
            private int index;

            @Override
            public Iterator<Event> iterator() {
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Event next() {
                ++this.index;
                Job job = (Job)iter.next();
                return Utility.toEvent(job);
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public void skip(long skipNum) {
                for (long m = skipNum; m > 0L && this.hasNext(); --m) {
                    this.next();
                }
            }

            @Override
            public long getSize() {
                return list.size();
            }

            @Override
            public long getPosition() {
                return this.index;
            }
        };
    }

    @Override
    public Event findJob(String topic, Map<String, Object> template) {
        Job job = this.getJob(topic, template);
        if (job != null) {
            return Utility.toEvent(job);
        }
        return null;
    }

    @Override
    public boolean removeJob(String jobId) {
        return this.internalRemoveJobById(jobId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalRemoveJobById(String jobId, boolean forceRemove) {
        this.logger.debug("Trying to remove job {}", (Object)jobId);
        boolean result = true;
        JobImpl job = (JobImpl)this.getJobById(jobId);
        if (job != null) {
            JobImpl retryJob;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found removal job: {}", (Object)Utility.toString(job));
            }
            if ((retryJob = (JobImpl)this.configuration.getJobFromRetryList(jobId)) != null) {
                job = retryJob;
            }
            if (!forceRemove && job.getProcessingStarted() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Unable to remove job - job is started: {}", (Object)Utility.toString(job));
                }
                result = false;
            } else {
                boolean isHistoryJob = this.configuration.isStoragePath(job.getResourcePath());
                if (isHistoryJob) {
                    ResourceResolver resolver = this.configuration.createResourceResolver();
                    try {
                        Resource jobResource = resolver.getResource(job.getResourcePath());
                        if (jobResource != null) {
                            resolver.delete(jobResource);
                            resolver.commit();
                            this.logger.debug("Removed job with id: {}", (Object)jobId);
                        } else {
                            this.logger.debug("Unable to remove job with id - resource already removed: {}", (Object)jobId);
                        }
                        NotificationUtility.sendNotification(this.eventAdmin, "org/apache/sling/event/notification/job/REMOVED", job, null);
                    }
                    catch (PersistenceException pe) {
                        this.ignoreException((Exception)((Object)pe));
                        result = false;
                    }
                    finally {
                        resolver.close();
                    }
                } else {
                    JobHandler jh = new JobHandler(job, this.configuration);
                    jh.finished(Job.JobState.DROPPED, true, -1L);
                }
            }
        } else {
            this.logger.debug("Job for removal does not exist (anymore): {}", (Object)jobId);
        }
        return result;
    }

    @Override
    public void forceRemoveJob(String jobId) {
        this.internalRemoveJobById(jobId, true);
    }

    @Override
    public Job addJob(String topic, Map<String, Object> properties) {
        return this.addJob(topic, null, properties);
    }

    @Override
    public Job addJob(String topic, String name, Map<String, Object> properties) {
        return this.addJob(topic, name, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJobByName(String name) {
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append(ISO9075.encode("event.job.id"));
            buf.append(" = '");
            buf.append(name);
            buf.append("']");
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                JobImpl job;
                Resource jobResource = (Resource)result.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = Utility.readJob(this.logger, jobResource)) == null) continue;
                JobImpl jobImpl = job;
                return jobImpl;
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        finally {
            resolver.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJobById(String id) {
        this.logger.debug("Getting job by id: {}", (Object)id);
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append("slingevent:eventId");
            buf.append(" = '");
            buf.append(id);
            buf.append("']");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exceuting query: {}", (Object)buf.toString());
            }
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                JobImpl job;
                Resource jobResource = (Resource)result.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = Utility.readJob(this.logger, jobResource)) == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found job with id {} = {}", (Object)id, (Object)Utility.toString(job));
                }
                JobImpl jobImpl = job;
                return jobImpl;
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        finally {
            resolver.close();
        }
        this.logger.debug("Job not found with id: {}", (Object)id);
        return null;
    }

    @Override
    public Job getJob(String topic, Map<String, Object> template) {
        Collection<Job> iter = template == null ? this.findJobs(JobManager.QueryType.ALL, topic, 1L, null) : this.findJobs(JobManager.QueryType.ALL, topic, 1L, template);
        Iterator i = iter.iterator();
        if (i.hasNext()) {
            return (Job)i.next();
        }
        return null;
    }

    @Override
    public boolean removeJobById(String jobId) {
        return this.internalRemoveJobById(jobId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Job> findJobs(JobManager.QueryType type, String topic, long limit, Map<String, Object> ... templates) {
        boolean isHistoryQuery = type == JobManager.QueryType.HISTORY || type == JobManager.QueryType.SUCCEEDED || type == JobManager.QueryType.CANCELLED || type == JobManager.QueryType.DROPPED || type == JobManager.QueryType.ERROR || type == JobManager.QueryType.GIVEN_UP || type == JobManager.QueryType.STOPPED;
        ArrayList<Job> result = new ArrayList<Job>();
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append(ISO9075.encode("event.job.topic"));
            buf.append(" = '");
            buf.append(topic);
            buf.append("'");
            if (isHistoryQuery) {
                buf.append(" and @");
                buf.append(ISO9075.encode("slingevent:finishedState"));
                if (type == JobManager.QueryType.SUCCEEDED || type == JobManager.QueryType.DROPPED || type == JobManager.QueryType.ERROR || type == JobManager.QueryType.GIVEN_UP || type == JobManager.QueryType.STOPPED) {
                    buf.append(" = '");
                    buf.append(type.name());
                    buf.append("'");
                } else if (type == JobManager.QueryType.CANCELLED) {
                    buf.append(" and (@");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.DROPPED.name());
                    buf.append("' or @");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.ERROR.name());
                    buf.append("' or @");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.GIVEN_UP.name());
                    buf.append("' or @");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.STOPPED.name());
                    buf.append("')");
                }
            } else {
                buf.append(" and not(@");
                buf.append(ISO9075.encode("slingevent:finishedState"));
                buf.append(")");
                if (type == JobManager.QueryType.ACTIVE) {
                    buf.append(" and @");
                    buf.append(ISO9075.encode("event.job.started.time"));
                } else if (type == JobManager.QueryType.QUEUED) {
                    buf.append(" and not(@");
                    buf.append(ISO9075.encode("event.job.started.time"));
                    buf.append(")");
                }
            }
            if (templates != null && templates.length > 0) {
                int index = 0;
                for (Map<String, Object> template : templates) {
                    if (template.size() == 0) continue;
                    if (index == 0) {
                        buf.append(" and (");
                    } else {
                        buf.append(" or ");
                    }
                    buf.append('(');
                    Iterator<Map.Entry<String, Object>> i = template.entrySet().iterator();
                    boolean first = true;
                    while (i.hasNext()) {
                        char secondChar;
                        Operation op;
                        String propName;
                        char firstChar;
                        Map.Entry<String, Object> current = i.next();
                        String key = ISO9075.encode(current.getKey());
                        char c = firstChar = key.length() > 0 ? key.charAt(0) : (char)'\u0000';
                        if (firstChar == '=') {
                            propName = key.substring(1);
                            op = Operation.EQUALS;
                        } else if (firstChar == '<') {
                            char c2 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                            if (secondChar == '=') {
                                op = Operation.LESS_OR_EQUALS;
                                propName = key.substring(2);
                            } else {
                                op = Operation.LESS;
                                propName = key.substring(1);
                            }
                        } else if (firstChar == '>') {
                            char c3 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                            if (secondChar == '=') {
                                op = Operation.GREATER_OR_EQUALS;
                                propName = key.substring(2);
                            } else {
                                op = Operation.GREATER;
                                propName = key.substring(1);
                            }
                        } else {
                            propName = key;
                            op = Operation.EQUALS;
                        }
                        if (first) {
                            first = false;
                            buf.append('@');
                        } else {
                            buf.append(" and @");
                        }
                        buf.append(propName);
                        buf.append(' ');
                        switch (op) {
                            case EQUALS: {
                                buf.append('=');
                                break;
                            }
                            case LESS: {
                                buf.append('<');
                                break;
                            }
                            case LESS_OR_EQUALS: {
                                buf.append("<=");
                                break;
                            }
                            case GREATER: {
                                buf.append('>');
                                break;
                            }
                            case GREATER_OR_EQUALS: {
                                buf.append(">=");
                            }
                        }
                        buf.append(" '");
                        buf.append(current.getValue());
                        buf.append("'");
                    }
                    buf.append(')');
                    ++index;
                }
                if (index > 0) {
                    buf.append(')');
                }
            }
            buf.append("] order by @");
            if (isHistoryQuery) {
                buf.append("slingevent:finishedDate");
                buf.append(" descending");
            } else {
                buf.append("slingevent:created");
                buf.append(" ascending");
            }
            Iterator iter = resolver.findResources(buf.toString(), "xpath");
            long count = 0L;
            while (iter.hasNext() && (limit < 1L || count < limit)) {
                JobImpl job;
                Resource jobResource = (Resource)iter.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = Utility.readJob(this.logger, jobResource)) == null) continue;
                ++count;
                result.add(job);
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        finally {
            resolver.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lock(String jobTopic, String id) {
        boolean hasLock;
        block12: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Trying to get lock for {}", (Object)id);
            }
            hasLock = false;
            ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                String lockName = ResourceHelper.filterName(id);
                StringBuilder sb = new StringBuilder(this.configuration.getLocksPath());
                sb.append('/');
                sb.append(jobTopic.replace('/', '.'));
                sb.append('/');
                sb.append(lockName);
                String path = sb.toString();
                Resource lockResource = resolver.getResource(path);
                if (lockResource != null) break block12;
                resolver.refresh();
                try {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("lock.created", Calendar.getInstance());
                    props.put("lock.created.app", Environment.APPLICATION_ID);
                    props.put("sling:resourceType", "slingevent:Lock");
                    lockResource = ResourceHelper.getOrCreateResource(resolver, path, props);
                    if (!lockResource.getName().equals(lockName)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Created SNS lock resource on instance {} - discarding", (Object)Environment.APPLICATION_ID);
                        }
                        resolver.delete(lockResource);
                        resolver.commit();
                    } else {
                        ValueMap vm = (ValueMap)lockResource.adaptTo(ValueMap.class);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Got lock resource on instance {} with {}", (Object)Environment.APPLICATION_ID, vm.get((Object)"lock.created.app"));
                        }
                        if (vm.get((Object)"lock.created.app").equals(Environment.APPLICATION_ID)) {
                            hasLock = true;
                        }
                    }
                }
                catch (PersistenceException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
            finally {
                resolver.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Lock for {} = {}", (Object)id, (Object)hasLock);
        }
        return hasLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job addJobInteral(String jobTopic, String jobName, Map<String, Object> jobProperties, List<String> errors) {
        QueueConfigurationManager.QueueInfo info = this.configuration.getQueueConfigurationManager().getQueueInfo(jobTopic);
        if (jobName != null && !this.lock(jobTopic, jobName)) {
            this.logger.debug("Discarding duplicate job {}", (Object)Utility.toString(jobTopic, jobName, jobProperties));
            return null;
        }
        TopologyCapabilities caps = this.topologyCapabilities;
        String string = info.targetId = caps == null ? null : caps.detectTarget(jobTopic, jobProperties, info);
        if (this.logger.isDebugEnabled()) {
            if (info.targetId != null) {
                this.logger.debug("Persisting job {} into queue {}, target={}", new Object[]{Utility.toString(jobTopic, jobName, jobProperties), info.queueName, info.targetId});
            } else {
                this.logger.debug("Persisting job {} into queue {}", (Object)Utility.toString(jobTopic, jobName, jobProperties), (Object)info.queueName);
            }
        }
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            JobImpl job;
            JobImpl jobImpl = job = this.writeJob(resolver, jobTopic, jobName, jobProperties, info);
            return jobImpl;
        }
        catch (PersistenceException re) {
            this.logger.error("Exception during persisting new job '" + Utility.toString(jobTopic, jobName, jobProperties) + "'", (Throwable)re);
        }
        finally {
            resolver.close();
        }
        if (errors != null) {
            errors.add("Unable to persist new job.");
        }
        return null;
    }

    private JobImpl writeJob(ResourceResolver resolver, String jobTopic, String jobName, Map<String, Object> jobProperties, QueueConfigurationManager.QueueInfo info) throws PersistenceException {
        String jobId = this.configuration.getUniqueId(jobTopic);
        String path = this.configuration.getUniquePath(info.targetId, jobTopic, jobId, jobProperties);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (jobProperties != null) {
            for (Map.Entry<String, Object> entry : jobProperties.entrySet()) {
                String propName = entry.getKey();
                if (ResourceHelper.ignoreProperty(propName)) continue;
                properties.put(propName, entry.getValue());
            }
        }
        properties.put("slingevent:eventId", jobId);
        properties.put("event.job.topic", jobTopic);
        if (jobName != null) {
            properties.put("event.job.id", jobName);
        }
        properties.put("event.job.queuename", info.queueConfiguration.getName());
        properties.put("event.job.retrycount", 0);
        properties.put("event.job.retries", info.queueConfiguration.getMaxRetries());
        properties.put("slingevent:created", Calendar.getInstance());
        properties.put("slingevent:application", Environment.APPLICATION_ID);
        if (info.targetId != null) {
            properties.put("event.job.application", info.targetId);
        } else {
            properties.remove("event.job.application");
        }
        properties.put("sling:resourceType", "slingevent:Job");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Storing new job {} at {}", (Object)Utility.toString(jobTopic, jobName, properties), (Object)path);
        }
        ResourceHelper.getOrCreateResource(resolver, path, properties);
        properties.put("slingevent:path", path);
        return new JobImpl(jobTopic, jobName, jobId, properties);
    }

    public TopologyCapabilities getTopologyCapabilities() {
        return this.topologyCapabilities;
    }

    @Override
    public void stopJobById(String jobId) {
        this.stopJobById(jobId, true);
    }

    private void stopJobById(String jobId, boolean forward) {
        JobImpl job = (JobImpl)this.getJobById(jobId);
        if (job != null && !this.configuration.isStoragePath(job.getResourcePath())) {
            QueueConfigurationManager.QueueInfo queueInfo = this.configuration.getQueueConfigurationManager().getQueueInfo(job.getTopic());
            AbstractJobQueue queue = (AbstractJobQueue)this.qManager.getQueue(queueInfo.queueName);
            boolean stopped = false;
            if (queue != null) {
                stopped = queue.stopJob(job);
            }
            if (forward && !stopped) {
                JobHandler jh = new JobHandler(job, this.configuration);
                jh.finished(Job.JobState.STOPPED, true, -1L);
            }
        }
    }

    @Override
    public JobBuilder createJob(String topic) {
        return new JobBuilderImpl(this, topic);
    }

    @Override
    public Collection<ScheduledJobInfo> getScheduledJobs() {
        return this.jobScheduler.getScheduledJobs(null, -1L, null);
    }

    @Override
    public Collection<ScheduledJobInfo> getScheduledJobs(String topic, long limit, Map<String, Object> ... templates) {
        return this.jobScheduler.getScheduledJobs(topic, limit, templates);
    }

    public ScheduledJobInfo addScheduledJob(String topic, String jobName, Map<String, Object> properties, String scheduleName, boolean isSuspended, List<ScheduleInfoImpl> scheduleInfos, List<String> errors) {
        String errorMessage;
        ArrayList<String> msgs = new ArrayList<String>();
        if (scheduleName == null || scheduleName.length() == 0) {
            msgs.add("Schedule name not specified");
        }
        if ((errorMessage = Utility.checkJob(topic, properties)) != null) {
            msgs.add(errorMessage);
        }
        if (scheduleInfos.size() == 0) {
            msgs.add("No schedule defined for " + scheduleName);
        }
        for (ScheduleInfoImpl info : scheduleInfos) {
            info.check(msgs);
        }
        if (msgs.size() == 0) {
            try {
                ScheduledJobInfoImpl info = this.jobScheduler.writeJob(topic, jobName, properties, scheduleName, isSuspended, scheduleInfos);
                if (info != null) {
                    return info;
                }
                msgs.add("Unable to persist scheduled job.");
            }
            catch (PersistenceException pe) {
                msgs.add("Unable to persist scheduled job: " + scheduleName);
                this.logger.warn("Unable to persist scheduled job", (Throwable)pe);
            }
        } else {
            for (String msg : msgs) {
                this.logger.warn(msg);
            }
        }
        if (errors != null) {
            errors.addAll(msgs);
        }
        return null;
    }

    public Job addJob(String topic, String name, Map<String, Object> properties, List<String> errors) {
        Job result;
        String errorMessage = Utility.checkJob(topic, properties);
        if (errorMessage != null) {
            this.logger.warn("{}", (Object)errorMessage);
            if (errors != null) {
                errors.add(errorMessage);
            }
            return null;
        }
        if (name != null) {
            this.logger.info("Job is using deprecated name feature: {}", (Object)Utility.toString(topic, name, properties));
        }
        if ((result = this.addJobInteral(topic, name, properties, errors)) == null && name != null) {
            result = this.getJobByName(name);
        }
        return result;
    }

    @Override
    public Job retryJobById(String jobId) {
        JobImpl job = (JobImpl)this.getJobById(jobId);
        if (job != null && this.configuration.isStoragePath(job.getResourcePath())) {
            this.internalRemoveJobById(jobId, true);
            return this.addJob(job.getTopic(), job.getName(), job.getProperties());
        }
        return null;
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindJobConsumerManager(JobConsumerManager jobConsumerManager) {
        this.jobConsumerManager = jobConsumerManager;
    }

    protected void unbindJobConsumerManager(JobConsumerManager jobConsumerManager) {
        if (this.jobConsumerManager == jobConsumerManager) {
            this.jobConsumerManager = null;
        }
    }

    protected void bindQueuesMBean(QueuesMBean queuesMBean) {
        this.queuesMBean = queuesMBean;
    }

    protected void unbindQueuesMBean(QueuesMBean queuesMBean) {
        if (this.queuesMBean == queuesMBean) {
            this.queuesMBean = null;
        }
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }

    protected void bindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        this.configuration = jobManagerConfiguration;
    }

    protected void unbindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        if (this.configuration == jobManagerConfiguration) {
            this.configuration = null;
        }
    }

    protected void bindStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    protected void unbindStatisticsManager(StatisticsManager statisticsManager) {
        if (this.statisticsManager == statisticsManager) {
            this.statisticsManager = null;
        }
    }

    protected void bindQManager(QueueManager queueManager) {
        this.qManager = queueManager;
    }

    protected void unbindQManager(QueueManager queueManager) {
        if (this.qManager == queueManager) {
            this.qManager = null;
        }
    }

    private static enum Operation {
        LESS,
        LESS_OR_EQUALS,
        EQUALS,
        GREATER_OR_EQUALS,
        GREATER;

    }
}

