/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.impl.jobs.config.ConfigurationChangeListener;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.MainQueueConfiguration;
import org.apache.sling.event.impl.support.ResourceHelper;

@Component
@Service(value={QueueConfigurationManager.class})
@Reference(referenceInterface=InternalQueueConfiguration.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindConfig", unbind="unbindConfig", updated="updateConfig")
public class QueueConfigurationManager {
    private static final InternalQueueConfiguration[] EMPTY_CONFIGS = new InternalQueueConfiguration[0];
    private volatile InternalQueueConfiguration[] orderedConfigs = EMPTY_CONFIGS;
    private final List<InternalQueueConfiguration> configurations = new ArrayList<InternalQueueConfiguration>();
    @Reference
    private MainQueueConfiguration mainQueueConfiguration;
    private volatile ConfigurationChangeListener changeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindConfig(InternalQueueConfiguration config) {
        List<InternalQueueConfiguration> list = this.configurations;
        synchronized (list) {
            this.configurations.add(config);
            this.createConfigurationCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindConfig(InternalQueueConfiguration config) {
        List<InternalQueueConfiguration> list = this.configurations;
        synchronized (list) {
            this.configurations.remove(config);
            this.createConfigurationCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfig(InternalQueueConfiguration config) {
        List<InternalQueueConfiguration> list = this.configurations;
        synchronized (list) {
            this.createConfigurationCache();
        }
    }

    private void createConfigurationCache() {
        if (this.configurations.isEmpty()) {
            this.orderedConfigs = EMPTY_CONFIGS;
        } else {
            Collections.sort(this.configurations);
            this.orderedConfigs = this.configurations.toArray(new InternalQueueConfiguration[this.configurations.size()]);
        }
        this.updateListener();
    }

    public InternalQueueConfiguration[] getConfigurations() {
        return this.orderedConfigs;
    }

    public InternalQueueConfiguration getMainQueueConfiguration() {
        return this.mainQueueConfiguration.getMainConfiguration();
    }

    public QueueInfo getQueueInfo(String topic) {
        InternalQueueConfiguration[] configurations;
        for (InternalQueueConfiguration config : configurations = this.getConfigurations()) {
            String qn;
            if (!config.isValid() || (qn = config.match(topic)) == null) continue;
            QueueInfo result = new QueueInfo();
            result.queueConfiguration = config;
            result.queueName = ResourceHelper.filterName(qn);
            return result;
        }
        QueueInfo result = new QueueInfo();
        result.queueConfiguration = this.mainQueueConfiguration.getMainConfiguration();
        result.queueName = result.queueConfiguration.getName();
        return result;
    }

    public void addListener(ConfigurationChangeListener listener) {
        this.changeListener = listener;
    }

    public void removeListener() {
        this.changeListener = null;
    }

    private void updateListener() {
        ConfigurationChangeListener l = this.changeListener;
        if (l != null) {
            l.configurationChanged(true);
        }
    }

    protected void bindMainQueueConfiguration(MainQueueConfiguration mainQueueConfiguration) {
        this.mainQueueConfiguration = mainQueueConfiguration;
    }

    protected void unbindMainQueueConfiguration(MainQueueConfiguration mainQueueConfiguration) {
        if (this.mainQueueConfiguration == mainQueueConfiguration) {
            this.mainQueueConfiguration = null;
        }
    }

    public static final class QueueInfo {
        public InternalQueueConfiguration queueConfiguration;
        public String queueName;
        public String targetId;

        public String toString() {
            return this.queueName;
        }

        public int hashCode() {
            return this.queueName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof QueueInfo) {
                return ((QueueInfo)obj).queueName.equals(this.queueName);
            }
            return false;
        }
    }
}

