/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.notifications;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class NewJobSender
implements EventHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private JobManagerConfiguration configuration;
    @Reference
    private EventAdmin eventAdmin;
    private volatile ServiceRegistration eventHandlerRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Apache Sling Job Topic Manager Event Handler");
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)properties).put("event.topics", "org/apache/sling/api/resource/Resource/ADDED");
        ((Dictionary)properties).put("event.filter", "(path=" + this.configuration.getLocalJobsPath() + "/*)");
        this.eventHandlerRegistration = bundleContext.registerService(EventHandler.class.getName(), (Object)this, properties);
    }

    @Deactivate
    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
    }

    public void handleEvent(Event event) {
        this.logger.debug("Received event {}", (Object)event);
        String path = (String)event.getProperty("path");
        String rt = (String)event.getProperty("resourceType");
        if ("slingevent:Job".equals(rt) && this.configuration.isLocalJob(path)) {
            int topicStart = this.configuration.getLocalJobsPath().length() + 1;
            int topicEnd = path.indexOf(47, topicStart);
            String topic = path.substring(topicStart, topicEnd).replace('.', '/');
            String jobId = path.substring(topicEnd + 1);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("slingevent:eventId", jobId);
            ((Dictionary)properties).put("event.job.topic", topic);
            String queueName = this.configuration.getQueueConfigurationManager().getQueueInfo((String)topic).queueName;
            ((Dictionary)properties).put("event.job.queuename", queueName);
            Event jobEvent = new Event("org/apache/sling/event/notification/job/ADDED", properties);
            this.eventAdmin.sendEvent(jobEvent);
        }
    }

    protected void bindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        this.configuration = jobManagerConfiguration;
    }

    protected void unbindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        if (this.configuration == jobManagerConfiguration) {
            this.configuration = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

