/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.Set;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.apache.sling.event.impl.jobs.queues.QueueServices;

public final class OrderedJobQueue
extends AbstractJobQueue {
    private final Object syncLock = new Object();
    private long sleepDelay = -1L;

    public OrderedJobQueue(String name, InternalQueueConfiguration config, QueueServices services, Set<String> topics) {
        super(name, config, services, topics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start(JobHandler handler) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.executeJob(handler)) {
                this.isWaiting = true;
                this.logger.debug("Job queue {} is waiting for finish.", (Object)this.queueName);
                while (this.isWaiting) {
                    try {
                        this.syncLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.sleepDelay > 0L) {
                    long waitingTime = this.sleepDelay;
                    long startTime = System.currentTimeMillis();
                    this.logger.debug("Job queue {} is sleeping {}ms for retry.", (Object)this.queueName, (Object)waitingTime);
                    while (this.sleepDelay > 0L) {
                        try {
                            this.syncLock.wait(waitingTime);
                            if (System.currentTimeMillis() < startTime + waitingTime) continue;
                            this.sleepDelay = -1L;
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
            }
        }
    }

    @Override
    protected void reschedule(JobHandler handler) {
        super.reschedule(handler);
        this.sleepDelay = this.getRetryDelay(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyFinished(boolean reschedule) {
        this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
        Object object = this.syncLock;
        synchronized (object) {
            this.isWaiting = false;
            if (!reschedule) {
                this.sleepDelay = -1L;
            }
            this.syncLock.notify();
        }
    }
}

