/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.event.impl.jobs.JobTopicTraverser;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckTopologyTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private static final Map<String, Object> BRIDGED_JOB = Collections.singletonMap("slingevent:eventadmin", Boolean.TRUE);

    public CheckTopologyTask(JobManagerConfiguration config) {
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignJobsFromStoppedInstances(TopologyCapabilities caps) {
        if (caps != null && caps.isLeader() && caps.isActive()) {
            this.logger.debug("Checking for stopped instances...");
            ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                Resource jobsRoot = resolver.getResource(this.configuration.getAssginedJobsPath());
                this.logger.debug("Got jobs root {}", (Object)jobsRoot);
                if (jobsRoot != null) {
                    Iterator instanceIter = jobsRoot.listChildren();
                    while (caps.isActive() && instanceIter.hasNext()) {
                        Resource instanceResource = (Resource)instanceIter.next();
                        String instanceId = instanceResource.getName();
                        if (caps.isActive(instanceId)) continue;
                        this.logger.debug("Found stopped instance {}", (Object)instanceId);
                        this.assignJobs(caps, instanceResource, true);
                    }
                }
            }
            finally {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignStableJobs(final TopologyCapabilities caps) {
        if (caps != null && caps.isActive()) {
            this.logger.debug("Checking for stale jobs...");
            final ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                Resource jobsRoot = resolver.getResource(this.configuration.getLocalJobsPath());
                if (jobsRoot != null) {
                    List<InstanceDescription> bridgedTargets = caps.getPotentialTargets("/", null);
                    boolean flag = false;
                    for (InstanceDescription desc : bridgedTargets) {
                        if (!desc.isLocal()) continue;
                        flag = true;
                        break;
                    }
                    final boolean supportsBridged = flag;
                    Iterator topicIter = jobsRoot.listChildren();
                    while (caps.isActive() && topicIter.hasNext()) {
                        final Resource topicResource = (Resource)topicIter.next();
                        final String topicName = topicResource.getName().replace('.', '/');
                        this.logger.debug("Checking topic {}...", (Object)topicName);
                        List<InstanceDescription> potentialTargets = caps.getPotentialTargets(topicName, null);
                        boolean reassign = true;
                        for (InstanceDescription desc : potentialTargets) {
                            if (!desc.isLocal()) continue;
                            reassign = false;
                            break;
                        }
                        if (!reassign) continue;
                        final QueueConfigurationManager.QueueInfo info = this.configuration.getQueueConfigurationManager().getQueueInfo(topicName);
                        JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.ResourceCallback(){

                            @Override
                            public boolean handle(Resource rsrc) {
                                try {
                                    ValueMap vm = ResourceHelper.getValueMap(rsrc);
                                    if (!supportsBridged || vm.get((Object)"slingevent:eventadmin") == null) {
                                        String newPath;
                                        String targetId = caps.detectTarget(topicName, (Map<String, Object>)vm, info);
                                        HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                                        props.remove("event.job.started.time");
                                        if (targetId != null) {
                                            newPath = CheckTopologyTask.this.configuration.getAssginedJobsPath() + '/' + targetId + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                            props.put("event.job.queuename", info.queueName);
                                            props.put("event.job.application", targetId);
                                        } else {
                                            newPath = CheckTopologyTask.this.configuration.getUnassignedJobsPath() + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                            props.remove("event.job.queuename");
                                            props.remove("event.job.application");
                                        }
                                        try {
                                            ResourceHelper.getOrCreateResource(resolver, newPath, props);
                                            resolver.delete(rsrc);
                                            resolver.commit();
                                        }
                                        catch (PersistenceException pe) {
                                            CheckTopologyTask.this.ignoreException((Exception)((Object)pe));
                                            resolver.refresh();
                                            resolver.revert();
                                        }
                                    }
                                }
                                catch (InstantiationException ie) {
                                    CheckTopologyTask.this.ignoreException(ie);
                                    resolver.refresh();
                                    resolver.revert();
                                }
                                return caps.isActive();
                            }
                        });
                    }
                }
            }
            finally {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignUnassignedJobs(TopologyCapabilities caps) {
        if (caps != null && caps.isLeader()) {
            this.logger.debug("Checking unassigned jobs...");
            ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                Resource unassignedRoot = resolver.getResource(this.configuration.getUnassignedJobsPath());
                this.logger.debug("Got unassigned root {}", (Object)unassignedRoot);
                if (unassignedRoot != null) {
                    this.assignJobs(caps, unassignedRoot, false);
                }
            }
            finally {
                resolver.close();
            }
        }
    }

    private void assignJobs(final TopologyCapabilities caps, Resource jobsRoot, boolean unassign) {
        final ResourceResolver resolver = jobsRoot.getResourceResolver();
        Iterator topicIter = jobsRoot.listChildren();
        while (caps.isActive() && topicIter.hasNext()) {
            final Resource topicResource = (Resource)topicIter.next();
            final String topicName = topicResource.getName().replace('.', '/');
            this.logger.debug("Found topic {}", (Object)topicName);
            List<InstanceDescription> potentialTargets = caps.getPotentialTargets(topicName, BRIDGED_JOB);
            if (potentialTargets != null && potentialTargets.size() > 0) {
                final QueueConfigurationManager.QueueInfo info = this.configuration.getQueueConfigurationManager().getQueueInfo(topicName);
                this.logger.debug("Found queue {} for {}", (Object)info.queueConfiguration, (Object)topicName);
                JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.ResourceCallback(){

                    @Override
                    public boolean handle(Resource rsrc) {
                        try {
                            ValueMap vm = ResourceHelper.getValueMap(rsrc);
                            String targetId = caps.detectTarget(topicName, (Map<String, Object>)vm, info);
                            if (targetId != null) {
                                String newPath = CheckTopologyTask.this.configuration.getAssginedJobsPath() + '/' + targetId + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                                props.put("event.job.queuename", info.queueName);
                                props.put("event.job.application", targetId);
                                props.remove("event.job.started.time");
                                try {
                                    ResourceHelper.getOrCreateResource(resolver, newPath, props);
                                    resolver.delete(rsrc);
                                    resolver.commit();
                                }
                                catch (PersistenceException pe) {
                                    CheckTopologyTask.this.ignoreException((Exception)((Object)pe));
                                    resolver.refresh();
                                    resolver.revert();
                                }
                            }
                        }
                        catch (InstantiationException ie) {
                            CheckTopologyTask.this.ignoreException(ie);
                            resolver.refresh();
                            resolver.revert();
                        }
                        return caps.isActive();
                    }
                });
            }
            if (!caps.isActive() || !unassign) continue;
            JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.ResourceCallback(){

                @Override
                public boolean handle(Resource rsrc) {
                    try {
                        ValueMap vm = ResourceHelper.getValueMap(rsrc);
                        String newPath = CheckTopologyTask.this.configuration.getUnassignedJobsPath() + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                        HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                        props.remove("event.job.queuename");
                        props.remove("event.job.application");
                        props.remove("event.job.started.time");
                        try {
                            ResourceHelper.getOrCreateResource(resolver, newPath, props);
                            resolver.delete(rsrc);
                            resolver.commit();
                        }
                        catch (PersistenceException pe) {
                            CheckTopologyTask.this.ignoreException((Exception)((Object)pe));
                            resolver.refresh();
                            resolver.revert();
                        }
                    }
                    catch (InstantiationException ie) {
                        CheckTopologyTask.this.ignoreException(ie);
                        resolver.refresh();
                        resolver.revert();
                    }
                    return caps.isActive();
                }
            });
        }
    }

    public void run(TopologyCapabilities topologyCapabilities, boolean topologyChanged, boolean configChanged) {
        if (topologyChanged) {
            this.reassignJobsFromStoppedInstances(topologyCapabilities);
        }
        if (topologyChanged || configChanged) {
            this.reassignStableJobs(topologyCapabilities);
        }
        if (topologyChanged || configChanged) {
            this.assignUnassignedJobs(topologyCapabilities);
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }
}

