/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.jobs.deprecated.JobStatusNotifier;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;

public abstract class ResourceHelper {
    public static final String RESOURCE_TYPE_FOLDER = "sling:Folder";
    public static final String RESOURCE_TYPE_JOB = "slingevent:Job";
    public static final String RESOURCE_TYPE_EVENT = "slingevent:Event";
    public static final String RESOURCE_TYPE_SCHEDULED_JOB = "slingevent:TimedEvent";
    public static final String BUNDLE_EVENT_UPDATED = "org/osgi/framework/BundleEvent/UPDATED";
    public static final String BUNDLE_EVENT_STARTED = "org/osgi/framework/BundleEvent/STARTED";
    public static final String PROPERTY_SCHEDULE_NAME = "slingevent:scheduleName";
    public static final String PROPERTY_SCHEDULE_INFO = "slingevent:scheduleInfo";
    public static final String PROPERTY_SCHEDULE_INFO_TYPE = "slingevent:scheduleInfoType";
    public static final String PROPERTY_SCHEDULE_SUSPENDED = "slingevent:scheduleSuspended";
    public static final String PROPERTY_JOB_ID = "slingevent:eventId";
    public static final String PROPERTY_JOB_TOPIC = "event.job.topic";
    private static final String[] IGNORE_PROPERTIES = new String[]{"event.distribute", "event.application", "event.topics", "slingevent:eventId", "event.job.parallel", "event.job.run.local", "event.job.queueordered", "event.notification.job", "event.job.priority", JobStatusNotifier.CONTEXT_PROPERTY_NAME, ":slingevent:delayOverride", ":sling:jobs:asynchandler", "slingevent:progressLog", "slingevent:progressETA", "slingevent:progressStep", "slingevent:progressSteps", "slingevent:finishedDate", "slingevent:finishedState", "slingevent:resultMessage", "slingevent:scheduleInfo", "slingevent:scheduleName", "slingevent:scheduleInfoType", "slingevent:scheduleSuspended"};
    private static final BitSet ALLOWED_CHARS;
    private static final char REPLACEMENT_CHAR = '_';
    public static final String PROPERTY_MARKER_READ_ERROR_LIST;

    public static boolean ignoreProperty(String name) {
        for (String prop : IGNORE_PROPERTIES) {
            if (!prop.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String filterQueueName(String queueName) {
        if (queueName.equals("<main queue>")) {
            return queueName;
        }
        return ResourceHelper.filterName(queueName);
    }

    public static String filterName(String resourceName) {
        StringBuilder sb = new StringBuilder(resourceName.length());
        int lastAdded = 0;
        for (int i = 0; i < resourceName.length(); ++i) {
            char c = resourceName.charAt(i);
            int toAdd = c;
            if (!ALLOWED_CHARS.get(c)) {
                if (lastAdded == 95) continue;
                toAdd = 95;
            } else if (i == 0 && Character.isDigit(c)) {
                sb.append('_');
            }
            sb.append((char)toAdd);
            lastAdded = toAdd;
        }
        if (sb.length() == 0) {
            sb.append('_');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> cloneValueMap(ValueMap vm) throws InstantiationException {
        ArrayList<Exception> hasReadError = null;
        try {
            HashMap<String, Object> result = new HashMap<String, Object>((Map<String, Object>)vm);
            for (Map.Entry entry : result.entrySet()) {
                if (((String)entry.getKey()).equals(PROPERTY_SCHEDULE_INFO)) {
                    Object[] infoArray = (String[])vm.get((String)entry.getKey(), String[].class);
                    if (infoArray == null || infoArray.length == 0) {
                        if (hasReadError == null) {
                            hasReadError = new ArrayList<Exception>();
                        }
                        hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "' : " + entry.getValue()));
                    } else {
                        ArrayList<ScheduleInfoImpl> infos = new ArrayList<ScheduleInfoImpl>();
                        for (String string : infoArray) {
                            ScheduleInfoImpl info = ScheduleInfoImpl.deserialize(string);
                            if (info == null) continue;
                            infos.add(info);
                        }
                        if (infos.size() < infoArray.length) {
                            if (hasReadError == null) {
                                hasReadError = new ArrayList();
                            }
                            hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "' : " + Arrays.toString(infoArray)));
                        } else {
                            entry.setValue(infos);
                        }
                    }
                }
                if (!(entry.getValue() instanceof InputStream)) continue;
                Object value = vm.get((String)entry.getKey(), Serializable.class);
                if (value != null) {
                    entry.setValue(value);
                    continue;
                }
                if (hasReadError == null) {
                    hasReadError = new ArrayList();
                }
                int count = hasReadError.size();
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream((InputStream)entry.getValue());
                    ois.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "'", cnfe));
                }
                catch (IOException ioe) {
                    hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "'", ioe));
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                if (hasReadError.size() != count) continue;
                hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "'"));
            }
            if (hasReadError != null) {
                result.put(PROPERTY_MARKER_READ_ERROR_LIST, hasReadError);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            throw (InstantiationException)new InstantiationException(iae.getMessage()).initCause(iae);
        }
    }

    public static ValueMap getValueMap(Resource resource) throws InstantiationException {
        ValueMap vm = ResourceUtil.getValueMap((Resource)resource);
        try {
            vm.size();
        }
        catch (IllegalArgumentException iae) {
            throw (InstantiationException)new InstantiationException(iae.getMessage()).initCause(iae);
        }
        return vm;
    }

    public static void getOrCreateBasePath(ResourceResolver resolver, String path) throws PersistenceException {
        PersistenceException mostRecentPE = null;
        for (int i = 0; i < 5; ++i) {
            try {
                ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, (String)RESOURCE_TYPE_FOLDER, (String)RESOURCE_TYPE_FOLDER, (boolean)true);
                return;
            }
            catch (PersistenceException pe) {
                resolver.revert();
                mostRecentPE = pe;
                continue;
            }
        }
        throw new PersistenceException("Unable to create resource with path " + path, (Throwable)mostRecentPE);
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path, Map<String, Object> props) throws PersistenceException {
        PersistenceException mostRecentPE = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, props, (String)RESOURCE_TYPE_FOLDER, (boolean)true);
            }
            catch (PersistenceException pe) {
                resolver.revert();
                mostRecentPE = pe;
                continue;
            }
        }
        throw new PersistenceException("Unable to create resource with path " + path, (Throwable)mostRecentPE);
    }

    static {
        String allowed = "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789_,.-+#!?$%&()=";
        BitSet allowedSet = new BitSet();
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789_,.-+#!?$%&()=".length(); ++i) {
            allowedSet.set("ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789_,.-+#!?$%&()=".charAt(i));
        }
        ALLOWED_CHARS = allowedSet;
        PROPERTY_MARKER_READ_ERROR_LIST = ResourceHelper.class.getName() + "/ReadErrorList";
    }
}

