/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.ConfigurationConstants;
import org.apache.sling.event.impl.support.TopicMatcher;
import org.apache.sling.event.impl.support.TopicMatcherHelper;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, name="org.apache.sling.event.jobs.QueueConfiguration", label="Apache Sling Job Queue Configuration", description="The configuration of a job processing queue.", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={InternalQueueConfiguration.class})
@Properties(value={@Property(name="queue.name", label="Name", description="The name of the queue. If matching is used the token {0} can be used to substitute the real value."), @Property(name="queue.topics", unbounded=PropertyUnbounded.ARRAY, label="Topics", description="This value is required and lists the topics processed by this queue. The value is a list of strings. If a string ends with a dot, all topics in exactly this package match. If the string ends with a star, all topics in this package and all subpackages match. If the string neither ends with a dot nor with a star, this is assumed to define an exact topic."), @Property(name="queue.type", value={"UNORDERED"}, options={@PropertyOption(name="UNORDERED", value="Parallel"), @PropertyOption(name="ORDERED", value="Ordered"), @PropertyOption(name="TOPIC_ROUND_ROBIN", value="Topic Round Robin")}, label="Type", description="The queue type."), @Property(name="queue.maxparallel", intValue={15}, label="Maximum Parallel Jobs", description="The maximum number of parallel jobs started for this queue. A value of -1 is substituted with the number of available processors."), @Property(name="queue.retries", intValue={10}, label="Maximum Retries", description="The maximum number of times a failed job slated for retries is actually retried. If a job has been retried this number of times and still fails, it is not rescheduled and assumed to have failed. The default value is 10."), @Property(name="queue.retrydelay", longValue={2000L}, label="Retry Delay", description="The number of milliseconds to sleep between two consecutive retries of a job which failed and was set to be retried. The default value is 2 seconds. This value is only relevant if there is a single failed job in the queue. If there are multiple failed jobs, each job is retried in turn without an intervening delay."), @Property(name="queue.priority", value={"NORM"}, options={@PropertyOption(name="NORM", value="Norm"), @PropertyOption(name="MIN", value="Min"), @PropertyOption(name="MAX", value="Max")}, label="Priority", description="The priority for the threads used by this queue. Default is norm."), @Property(name="queue.keepJobs", boolValue={false}, label="Keep History", description="If this option is enabled, successful finished jobs are kept to provide a complete history."), @Property(name="queue.preferRunOnCreationInstance", boolValue={false}, label="Prefer Creation Instance", description="If this option is enabled, the jobs are tried to be run on the instance where the job was created."), @Property(name="queue.threadPoolSize", intValue={0}, label="Thread Pool Size", description="Optional configuration value for a thread pool to be used by this queue. If this is value has a positive number of threads configuration, this queue uses an own thread pool with the configured number of threads."), @Property(name="service.ranking", intValue={0}, propertyPrivate=false, label="Ranking", description="Integer value defining the ranking of this queue configuration. If more than one queue matches a job topic, the one with the highest ranking is used.")})
public class InternalQueueConfiguration
implements QueueConfiguration,
Comparable<InternalQueueConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private QueueConfiguration.Type type;
    private int retries;
    private long retryDelay;
    private QueueConfiguration.ThreadPriority priority;
    private int maxParallelProcesses;
    private int serviceRanking;
    private TopicMatcher[] matchers;
    private String[] topics;
    private boolean keepJobs;
    private boolean valid = false;
    private int ownThreadPoolSize;
    private boolean preferCreationInstance;
    private String pid;

    public static InternalQueueConfiguration fromConfiguration(Map<String, Object> params) {
        InternalQueueConfiguration c = new InternalQueueConfiguration();
        c.activate(params);
        return c;
    }

    @Activate
    protected void activate(Map<String, Object> params) {
        this.name = PropertiesUtil.toString(params.get("queue.name"), null);
        this.priority = QueueConfiguration.ThreadPriority.valueOf(PropertiesUtil.toString(params.get("queue.priority"), "NORM"));
        this.type = QueueConfiguration.Type.valueOf(PropertiesUtil.toString(params.get("queue.type"), "UNORDERED"));
        this.retries = PropertiesUtil.toInteger(params.get("queue.retries"), 10);
        this.retryDelay = PropertiesUtil.toLong(params.get("queue.retrydelay"), 2000L);
        int maxParallel = PropertiesUtil.toInteger(params.get("queue.maxparallel"), 15);
        this.maxParallelProcesses = maxParallel == -1 ? ConfigurationConstants.NUMBER_OF_PROCESSORS : maxParallel;
        String[] topicsParam = PropertiesUtil.toStringArray(params.get("queue.topics"));
        this.matchers = TopicMatcherHelper.buildMatchers(topicsParam);
        this.topics = this.matchers == null ? null : topicsParam;
        this.keepJobs = PropertiesUtil.toBoolean(params.get("queue.keepJobs"), false);
        this.serviceRanking = PropertiesUtil.toInteger(params.get("service.ranking"), 0);
        this.ownThreadPoolSize = PropertiesUtil.toInteger(params.get("queue.threadPoolSize"), 0);
        this.preferCreationInstance = PropertiesUtil.toBoolean(params.get("queue.preferRunOnCreationInstance"), false);
        this.pid = (String)params.get("service.pid");
        this.valid = this.checkIsValid();
    }

    private boolean checkIsValid() {
        boolean hasMatchers = false;
        if (this.matchers != null) {
            for (TopicMatcher m : this.matchers) {
                if (m == null) continue;
                hasMatchers = true;
                break;
            }
        }
        if (!hasMatchers) {
            return false;
        }
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        if (this.retries < -1) {
            return false;
        }
        if ((this.type == QueueConfiguration.Type.UNORDERED || this.type == QueueConfiguration.Type.TOPIC_ROUND_ROBIN) && this.maxParallelProcesses < 1) {
            return false;
        }
        if (this.type == QueueConfiguration.Type.IGNORE || this.type == QueueConfiguration.Type.DROP) {
            Utility.logDeprecated(this.logger, "Queue is using deprecated queue type. Ignoring queue " + this.name + " with type " + (Object)((Object)this.type));
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String match(String topic) {
        if (this.matchers != null) {
            for (TopicMatcher m : this.matchers) {
                String rep;
                if (m == null || (rep = m.match(topic)) == null) continue;
                return this.name.replace("{0}", rep);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getRetryDelayInMs() {
        return this.retryDelay;
    }

    @Override
    public int getMaxRetries() {
        return this.retries;
    }

    @Override
    public QueueConfiguration.Type getType() {
        return this.type;
    }

    @Override
    public JobUtil.JobPriority getPriority() {
        return JobUtil.JobPriority.valueOf(this.priority.name());
    }

    @Override
    public int getMaxParallel() {
        return this.maxParallelProcesses;
    }

    @Override
    @Deprecated
    public boolean isLocalQueue() {
        return false;
    }

    @Override
    public String[] getTopics() {
        return this.topics;
    }

    @Override
    public int getRanking() {
        return this.serviceRanking;
    }

    public String getPid() {
        return this.pid;
    }

    @Override
    @Deprecated
    public String[] getApplicationIds() {
        return null;
    }

    @Override
    public boolean isKeepJobs() {
        return this.keepJobs;
    }

    @Override
    public int getOwnThreadPoolSize() {
        return this.ownThreadPoolSize;
    }

    @Override
    public boolean isPreferRunOnCreationInstance() {
        return this.preferCreationInstance;
    }

    public String toString() {
        return "Queue-Configuration(" + this.hashCode() + ") : {" + "name=" + this.name + ", type=" + (Object)((Object)this.type) + ", topics=" + (this.matchers == null ? "[]" : Arrays.toString(this.matchers)) + ", maxParallelProcesses=" + this.maxParallelProcesses + ", retries=" + this.retries + ", retryDelayInMs=" + this.retryDelay + ", keepJobs=" + this.keepJobs + ", preferRunOnCreationInstance=" + this.preferCreationInstance + ", ownThreadPoolSize=" + this.ownThreadPoolSize + ", serviceRanking=" + this.serviceRanking + ", pid=" + this.pid + ", isValid=" + this.isValid() + "}";
    }

    @Override
    public int compareTo(InternalQueueConfiguration other) {
        if (this.serviceRanking < other.serviceRanking) {
            return 1;
        }
        if (this.serviceRanking > other.serviceRanking) {
            return -1;
        }
        return 0;
    }

    @Override
    public QueueConfiguration.ThreadPriority getThreadPriority() {
        return this.priority;
    }
}

