/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.config.ConfigurationChangeListener;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.tasks.CheckTopologyTask;
import org.apache.sling.event.impl.jobs.tasks.FindUnfinishedJobsTask;
import org.apache.sling.event.impl.jobs.tasks.UpgradeTask;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="Apache Sling Job Manager", description="This is the central service of the job handling.", name="org.apache.sling.event.impl.jobs.jcr.PersistenceHandler")
@Service(value={JobManagerConfiguration.class, TopologyEventListener.class})
@Properties(value={@Property(name="job.consumermanager.disableDistribution", boolValue={false}, label="Disable Distribution", description="If the distribution is disabled, all jobs will be processed on the leader only! Please use this switch with care."), @Property(name="repository.path", value={"/var/eventing/jobs"}, propertyPrivate=true), @Property(name="job.scheduled.jobs.path", value={"/var/eventing/scheduled-jobs"}, propertyPrivate=true), @Property(name="load.delay", longValue={10L}, propertyPrivate=true)})
public class JobManagerConfiguration
implements TopologyEventListener,
ConfigurationChangeListener {
    private final Logger logger = LoggerFactory.getLogger((String)"org.apache.sling.event.impl.jobs");
    public static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/jobs";
    public static final long DEFAULT_BACKGROUND_LOAD_DELAY = 10L;
    public static final boolean DEFAULT_DISABLE_DISTRIBUTION = false;
    public static final String DEFAULT_SCHEDULED_JOBS_PATH = "/var/eventing/scheduled-jobs";
    public static final String PROPERTY_REPOSITORY_PATH = "repository.path";
    public static final String PROPERTY_BACKGROUND_LOAD_DELAY = "load.delay";
    public static final String PROPERTY_DISABLE_DISTRIBUTION = "job.consumermanager.disableDistribution";
    public static final String PROPERTY_SCHEDULED_JOBS_PATH = "job.scheduled.jobs.path";
    public static final boolean DEFAULT_BACKGROUND_LOAD_SEARCH = true;
    private String jobsBasePathWithSlash;
    private String assignedJobsPath;
    private String unassignedJobsPath;
    private String localJobsPath;
    private String localJobsPathWithSlash;
    private String locksPath;
    private String previousVersionAnonPath;
    private String previousVersionIdentifiedPath;
    private String locksPathWithSlash;
    private long backgroundLoadDelay;
    private boolean disabledDistribution;
    private String storedCancelledJobsPath;
    private String storedSuccessfulJobsPath;
    private String scheduledJobsPath;
    private String scheduledJobsPathWithSlash;
    private final List<ConfigurationChangeListener> listeners = new ArrayList<ConfigurationChangeListener>();
    @Reference
    private EnvironmentComponent environment;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private QueueConfigurationManager queueConfigManager;
    @Reference
    private Scheduler scheduler;
    private volatile TopologyCapabilities topologyCapabilities;
    private final AtomicLong jobCounter = new AtomicLong(0L);
    private final Map<String, Job> retryList = new HashMap<String, Job>();

    @Activate
    protected void activate(Map<String, Object> props) {
        this.update(props);
        this.jobsBasePathWithSlash = PropertiesUtil.toString(props.get(PROPERTY_REPOSITORY_PATH), DEFAULT_REPOSITORY_PATH) + '/';
        this.assignedJobsPath = this.jobsBasePathWithSlash + "assigned";
        this.unassignedJobsPath = this.jobsBasePathWithSlash + "unassigned";
        this.locksPath = this.jobsBasePathWithSlash + "locks";
        this.locksPathWithSlash = this.locksPath.concat("/");
        this.localJobsPath = this.assignedJobsPath.concat("/").concat(Environment.APPLICATION_ID);
        this.localJobsPathWithSlash = this.localJobsPath.concat("/");
        this.previousVersionAnonPath = this.jobsBasePathWithSlash + "anon";
        this.previousVersionIdentifiedPath = this.jobsBasePathWithSlash + "identified";
        this.storedCancelledJobsPath = this.jobsBasePathWithSlash + "cancelled";
        this.storedSuccessfulJobsPath = this.jobsBasePathWithSlash + "finished";
        this.scheduledJobsPath = PropertiesUtil.toString(props.get(PROPERTY_SCHEDULED_JOBS_PATH), DEFAULT_SCHEDULED_JOBS_PATH);
        this.scheduledJobsPathWithSlash = this.scheduledJobsPath + "/";
        ResourceResolver resolver = this.createResourceResolver();
        try {
            ResourceHelper.getOrCreateBasePath(resolver, this.getLocalJobsPath());
            ResourceHelper.getOrCreateBasePath(resolver, this.getUnassignedJobsPath());
            ResourceHelper.getOrCreateBasePath(resolver, this.getLocksPath());
        }
        catch (PersistenceException pe) {
            this.logger.error("Unable to create default paths: " + pe.getMessage(), (Throwable)pe);
            throw new RuntimeException(pe);
        }
        finally {
            resolver.close();
        }
        this.queueConfigManager.addListener(this);
    }

    @Modified
    protected void update(Map<String, Object> props) {
        this.disabledDistribution = PropertiesUtil.toBoolean(props.get(PROPERTY_DISABLE_DISTRIBUTION), false);
        this.backgroundLoadDelay = PropertiesUtil.toLong(props.get(PROPERTY_BACKGROUND_LOAD_DELAY), 10L);
    }

    @Deactivate
    protected void deactivate() {
        this.queueConfigManager.removeListener();
    }

    public ResourceResolver createResourceResolver() {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException le) {
            this.logger.error("Unable to create new resource resolver: " + le.getMessage(), (Throwable)le);
            throw new RuntimeException(le);
        }
        return resolver;
    }

    public TopologyCapabilities getTopologyCapabilities() {
        return this.topologyCapabilities;
    }

    public QueueConfigurationManager getQueueConfigurationManager() {
        return this.queueConfigManager;
    }

    public Logger getMainLogger() {
        return this.logger;
    }

    public String getAssginedJobsPath() {
        return this.assignedJobsPath;
    }

    public String getUnassignedJobsPath() {
        return this.unassignedJobsPath;
    }

    public String getLocalJobsPath() {
        return this.localJobsPath;
    }

    public String getLocksPath() {
        return this.locksPath;
    }

    public String getUniquePath(String targetId, String topic, String jobId, Map<String, Object> jobProperties) {
        String topicName = topic.replace('/', '.');
        StringBuilder sb = new StringBuilder();
        if (targetId != null) {
            sb.append(this.assignedJobsPath);
            sb.append('/');
            sb.append(targetId);
        } else {
            sb.append(this.unassignedJobsPath);
        }
        sb.append('/');
        sb.append(topicName);
        sb.append('/');
        sb.append(jobId);
        return sb.toString();
    }

    public String getUniqueId(String jobTopic) {
        String convTopic = jobTopic.replace('/', '.');
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(now.get(1));
        sb.append('/');
        sb.append(now.get(2) + 1);
        sb.append('/');
        sb.append(now.get(5));
        sb.append('/');
        sb.append(now.get(11));
        sb.append('/');
        sb.append(now.get(12));
        sb.append('/');
        sb.append(convTopic);
        sb.append('_');
        sb.append(Environment.APPLICATION_ID);
        sb.append('_');
        sb.append(this.jobCounter.getAndIncrement());
        return sb.toString();
    }

    public boolean isLocalJob(String jobPath) {
        return jobPath != null && jobPath.startsWith(this.localJobsPathWithSlash);
    }

    public boolean isJob(String jobPath) {
        return jobPath.startsWith(this.jobsBasePathWithSlash);
    }

    public boolean isLock(String lockPath) {
        return lockPath.startsWith(this.locksPathWithSlash);
    }

    public String getPreviousVersionAnonPath() {
        return this.previousVersionAnonPath;
    }

    public String getPreviousVersionIdentifiedPath() {
        return this.previousVersionIdentifiedPath;
    }

    public boolean disableDistribution() {
        return this.disabledDistribution;
    }

    public String getStoredCancelledJobsPath() {
        return this.storedCancelledJobsPath;
    }

    public String getStoredSuccessfulJobsPath() {
        return this.storedSuccessfulJobsPath;
    }

    public String getStoragePath(String topic, String jobId, boolean isSuccess) {
        String topicName = topic.replace('/', '.');
        StringBuilder sb = new StringBuilder();
        if (isSuccess) {
            sb.append(this.storedSuccessfulJobsPath);
        } else {
            sb.append(this.storedCancelledJobsPath);
        }
        sb.append('/');
        sb.append(topicName);
        sb.append('/');
        sb.append(jobId);
        return sb.toString();
    }

    public boolean isStoragePath(String path) {
        return path.startsWith(this.storedCancelledJobsPath) || path.startsWith(this.storedSuccessfulJobsPath);
    }

    public String getScheduledJobsPath(boolean slash) {
        return slash ? this.scheduledJobsPathWithSlash : this.scheduledJobsPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationChanged(boolean active) {
        TopologyCapabilities caps = this.topologyCapabilities;
        if (caps != null) {
            List<ConfigurationChangeListener> list = this.listeners;
            synchronized (list) {
                this.stopProcessing(false);
                this.startProcessing(TopologyEvent.Type.PROPERTIES_CHANGED, caps, true);
            }
        }
    }

    private void stopProcessing(boolean deactivate) {
        boolean notify;
        this.logger.debug("Stopping job processing...");
        boolean bl = notify = this.topologyCapabilities != null;
        if (deactivate && this.topologyCapabilities != null) {
            this.topologyCapabilities.deactivate();
        }
        this.topologyCapabilities = null;
        if (notify) {
            this.notifiyListeners();
        }
        this.logger.debug("Job processing stopped");
    }

    private void startProcessing(TopologyEvent.Type eventType, final TopologyCapabilities newCaps, boolean isConfigChange) {
        this.logger.debug("Starting job processing...");
        this.topologyCapabilities = newCaps;
        if (eventType == TopologyEvent.Type.TOPOLOGY_INIT) {
            UpgradeTask task = new UpgradeTask(this);
            task.run();
            FindUnfinishedJobsTask rt = new FindUnfinishedJobsTask(this);
            rt.run();
        }
        final CheckTopologyTask mt = new CheckTopologyTask(this);
        mt.fullRun(!isConfigChange, isConfigChange);
        this.scheduler.schedule((Object)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (newCaps.isLeader() && newCaps.isActive()) {
                    mt.assignUnassignedJobs();
                }
                List list = JobManagerConfiguration.this.listeners;
                synchronized (list) {
                    if (JobManagerConfiguration.this.topologyCapabilities != null && newCaps.isActive()) {
                        JobManagerConfiguration.this.notifiyListeners();
                    }
                }
            }
        }, this.scheduler.AT((java.util.Date)new Date(System.currentTimeMillis() + this.backgroundLoadDelay * 1000L)));
        this.logger.debug("Job processing started");
    }

    private void notifiyListeners() {
        for (ConfigurationChangeListener l : this.listeners) {
            l.configurationChanged(this.topologyCapabilities != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTopologyEvent(TopologyEvent event) {
        this.logger.debug("Received topology event {}", (Object)event);
        if (event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
            Map<String, String> newAllInstances = TopologyCapabilities.getAllInstancesMap(event.getNewView());
            if (this.topologyCapabilities != null && this.topologyCapabilities.isSame(newAllInstances)) {
                this.logger.debug("No changes in capabilities - ignoring event");
                return;
            }
        }
        List<ConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
                this.stopProcessing(true);
            } else if (event.getType() == TopologyEvent.Type.TOPOLOGY_INIT || event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
                this.stopProcessing(true);
                this.startProcessing(event.getType(), new TopologyCapabilities(event.getNewView(), this), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationChangeListener service) {
        List<ConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(service);
            service.configurationChanged(this.topologyCapabilities != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigurationChangeListener service) {
        List<ConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobToRetryList(Job job) {
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            this.retryList.put(job.getId(), job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> clearJobRetryList() {
        ArrayList<Job> result = new ArrayList<Job>();
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            result.addAll(this.retryList.values());
            this.retryList.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJobFromRetryList(Job job) {
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            return this.retryList.remove(job.getId()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getJobFromRetryList(String jobId) {
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            return this.retryList.get(jobId);
        }
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindQueueConfigManager(QueueConfigurationManager queueConfigurationManager) {
        this.queueConfigManager = queueConfigurationManager;
    }

    protected void unbindQueueConfigManager(QueueConfigurationManager queueConfigurationManager) {
        if (this.queueConfigManager == queueConfigurationManager) {
            this.queueConfigManager = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }
}

