/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.apache.sling.event.impl.jobs.queues.QueueServices;

public final class ParallelJobQueue
extends AbstractJobQueue {
    private final Semaphore available;

    public ParallelJobQueue(String name, InternalQueueConfiguration config, QueueServices services, Set<String> topics) {
        super(name, config, services, topics);
        this.available = new Semaphore(config.getMaxParallel(), true);
    }

    @Override
    public String getStateInfo() {
        return super.getStateInfo() + ", jobCount=" + String.valueOf(this.configuration.getMaxParallel() - this.available.availablePermits());
    }

    @Override
    protected void start(JobHandler handler) {
        boolean hasSlot = false;
        while (!hasSlot) {
            try {
                this.available.acquire();
                hasSlot = true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.isOutdated() || !this.running || !this.executeJob(handler)) {
            this.available.release();
        }
    }

    @Override
    protected boolean canBeClosed() {
        boolean result = super.canBeClosed();
        if (result) {
            result = this.available.availablePermits() == this.configuration.getMaxParallel();
        }
        return result;
    }

    @Override
    protected void notifyFinished(boolean reschedule) {
        this.available.release();
    }

    @Override
    protected void reschedule(final JobHandler handler) {
        long delay = this.getRetryDelay(handler);
        if (delay > 0L) {
            handler.addToRetryList();
            Date fireDate = new Date();
            fireDate.setTime(System.currentTimeMillis() + delay);
            String jobName = "Waiting:" + this.queueName + ":" + handler.hashCode();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (handler.removeFromRetryList()) {
                        ParallelJobQueue.super.reschedule(handler);
                    }
                }
            };
            this.services.scheduler.schedule((Object)t, this.services.scheduler.AT(fireDate).name(jobName));
        } else {
            super.reschedule(handler);
        }
    }
}

