/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobTopicTraverser;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueJobCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int maxPreloadLimit = 10;
    private final JobManagerConfiguration configuration;
    private final Set<String> topics;
    private final Set<String> topicsWithNewJobs = new HashSet<String>();
    private final List<JobImpl> cache = new ArrayList<JobImpl>();
    private final QueueConfiguration.Type queueType;

    public QueueJobCache(JobManagerConfiguration configuration, QueueConfiguration.Type queueType, Set<String> topics) {
        this.configuration = configuration;
        this.queueType = queueType;
        this.topics = new ConcurrentSkipListSet<String>(topics);
        this.topicsWithNewJobs.addAll(topics);
    }

    public Set<String> getTopics() {
        return this.topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean result = true;
        Collection<Object> collection = this.cache;
        synchronized (collection) {
            result = this.cache.isEmpty();
        }
        if (result) {
            collection = this.topicsWithNewJobs;
            synchronized (collection) {
                result = this.topicsWithNewJobs.isEmpty();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobImpl getNextJob(boolean doFull) {
        JobImpl result = null;
        List<JobImpl> list = this.cache;
        synchronized (list) {
            if (this.cache.isEmpty()) {
                HashSet<String> checkingTopics = new HashSet<String>();
                Set<String> set = this.topicsWithNewJobs;
                synchronized (set) {
                    checkingTopics.addAll(this.topicsWithNewJobs);
                    this.topicsWithNewJobs.clear();
                }
                if (doFull) {
                    checkingTopics.addAll(this.topics);
                }
                if (!checkingTopics.isEmpty()) {
                    this.loadJobs(checkingTopics);
                }
            }
            if (!this.cache.isEmpty()) {
                result = this.cache.remove(0);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobs(Set<String> checkingTopics) {
        this.logger.debug("Starting jobs loading from {}...", checkingTopics);
        HashMap<String, List<JobImpl>> topicCache = new HashMap<String, List<JobImpl>>();
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            Resource baseResource = resolver.getResource(this.configuration.getLocalJobsPath());
            if (baseResource != null) {
                for (String topic : checkingTopics) {
                    Resource topicResource = baseResource.getChild(topic.replace('/', '.'));
                    if (topicResource == null) continue;
                    topicCache.put(topic, this.loadJobs(topic, topicResource));
                }
            }
        }
        finally {
            resolver.close();
        }
        this.orderTopics(topicCache);
        this.logger.debug("Finished jobs loading {}", (Object)this.cache.size());
    }

    private void orderTopics(Map<String, List<JobImpl>> topicCache) {
        if (this.queueType == QueueConfiguration.Type.ORDERED || this.queueType == QueueConfiguration.Type.UNORDERED) {
            for (List<JobImpl> list : topicCache.values()) {
                this.cache.addAll(list);
            }
            Collections.sort(this.cache);
        } else {
            boolean done = true;
            do {
                done = true;
                for (Map.Entry<String, List<JobImpl>> entry : topicCache.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    this.cache.add(entry.getValue().remove(0));
                    if (entry.getValue().isEmpty()) continue;
                    done = false;
                }
            } while (!done);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JobImpl> loadJobs(String topic, Resource topicResource) {
        this.logger.debug("Loading jobs from topic {}", (Object)topic);
        final ArrayList<JobImpl> list = new ArrayList<JobImpl>();
        final AtomicBoolean scanTopic = new AtomicBoolean(false);
        JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.JobCallback(){

            @Override
            public boolean handle(JobImpl job) {
                if (job.getProcessingStarted() == null && !job.hasReadErrors()) {
                    list.add(job);
                    if (list.size() == 10) {
                        scanTopic.set(true);
                    }
                } else {
                    if (job.hasReadErrors()) {
                        scanTopic.set(true);
                    }
                    QueueJobCache.this.logger.debug("Ignoring job because {} or {}", (Object)job.getProcessingStarted(), (Object)job.hasReadErrors());
                }
                return list.size() < 10;
            }
        });
        if (scanTopic.get()) {
            Set<String> set = this.topicsWithNewJobs;
            synchronized (set) {
                this.topicsWithNewJobs.add(topic);
            }
        }
        this.logger.debug("Caching {} jobs for topic {}", (Object)list.size(), (Object)topic);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewTopics(Set<String> topics) {
        this.logger.debug("Update cache to handle new event for topics {}", topics);
        Set<String> set = this.topicsWithNewJobs;
        synchronized (set) {
            this.topicsWithNewJobs.addAll(topics);
        }
        this.topics.addAll(topics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(JobHandler handler) {
        List<JobImpl> list = this.cache;
        synchronized (list) {
            if (handler.reschedule()) {
                if (this.queueType == QueueConfiguration.Type.ORDERED) {
                    this.cache.add(0, handler.getJob());
                } else {
                    this.cache.add(handler.getJob());
                }
            }
        }
    }
}

