/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.event.impl.EventingThreadPool;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.settings.SlingSettingsService;

@Component(immediate=true)
@Service(value={EnvironmentComponent.class})
public class EnvironmentComponent {
    @Reference(referenceInterface=EventingThreadPool.class)
    private ThreadPool threadPool;
    @Reference
    private SlingSettingsService settingsService;

    @Activate
    protected void activate() {
        Environment.APPLICATION_ID = this.settingsService.getSlingId();
        Environment.THREAD_POOL = this.threadPool;
    }

    @Deactivate
    protected void deactivate() {
        if (Environment.THREAD_POOL == this.threadPool) {
            Environment.THREAD_POOL = null;
        }
    }

    protected void bindThreadPool(EventingThreadPool etp) {
        this.threadPool = etp;
    }

    protected void unbindThreadPool(EventingThreadPool etp) {
        if (this.threadPool == etp) {
            this.threadPool = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

