/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.Set;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.apache.sling.event.impl.jobs.queues.QueueServices;

public final class OrderedJobQueue
extends AbstractJobQueue {
    private final Object syncLock = new Object();
    private volatile long sleepingUntil;

    public OrderedJobQueue(String name, InternalQueueConfiguration config, QueueServices services, Set<String> topics) {
        super(name, config, services, topics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start(JobHandler handler) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.executeJob(handler)) {
                long waitingTime;
                this.isWaiting = true;
                this.logger.debug("Job queue {} is waiting for finish.", (Object)this.queueName);
                while (this.isWaiting) {
                    try {
                        this.syncLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.sleepingUntil != -1L && (waitingTime = this.sleepingUntil - System.currentTimeMillis()) > 0L) {
                    this.logger.debug("Job queue {} is sleeping {}ms for retry.", (Object)this.queueName, (Object)waitingTime);
                    while (this.sleepingUntil != -1L) {
                        try {
                            this.syncLock.wait(waitingTime);
                            if (System.currentTimeMillis() < this.sleepingUntil) continue;
                            this.sleepingUntil = -1L;
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
            }
        }
    }

    @Override
    protected void reschedule(JobHandler handler) {
        super.reschedule(handler);
        long retryDelay = this.getRetryDelay(handler);
        this.sleepingUntil = retryDelay > 0L ? System.currentTimeMillis() + retryDelay : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyFinished(boolean reschedule) {
        this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
        Object object = this.syncLock;
        synchronized (object) {
            this.isWaiting = false;
            if (!reschedule) {
                this.sleepingUntil = -1L;
            }
            this.syncLock.notify();
        }
    }

    @Override
    public String getStateInfo() {
        return super.getStateInfo() + ", isSleepingUntil=" + this.sleepingUntil;
    }

    @Override
    public Object getState(String key) {
        if ("isSleepingUntil".equals(key)) {
            return this.sleepingUntil;
        }
        return super.getState(key);
    }
}

