/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import org.apache.sling.event.jobs.Statistics;

public class StatisticsImpl
implements Statistics {
    private volatile long startTime;
    private volatile long activeJobs;
    private volatile long queuedJobs;
    private volatile long lastActivated = -1L;
    private volatile long lastFinished = -1L;
    private volatile long averageWaitingTime;
    private volatile long averageProcessingTime;
    private volatile long waitingTime;
    private volatile long processingTime;
    private volatile long waitingCount;
    private volatile long processingCount;
    private volatile long finishedJobs;
    private volatile long failedJobs;
    private volatile long cancelledJobs;

    public StatisticsImpl() {
        this(System.currentTimeMillis());
    }

    public StatisticsImpl(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized long getNumberOfProcessedJobs() {
        return this.getNumberOfCancelledJobs() + this.getNumberOfFailedJobs() + this.getNumberOfFinishedJobs();
    }

    @Override
    public synchronized long getNumberOfActiveJobs() {
        return this.activeJobs;
    }

    @Override
    public synchronized long getNumberOfQueuedJobs() {
        return this.queuedJobs;
    }

    @Override
    public synchronized long getNumberOfJobs() {
        return this.activeJobs + this.queuedJobs;
    }

    @Override
    public synchronized long getAverageWaitingTime() {
        return this.averageWaitingTime;
    }

    @Override
    public synchronized long getAverageProcessingTime() {
        return this.averageProcessingTime;
    }

    @Override
    public synchronized long getNumberOfFinishedJobs() {
        return this.finishedJobs;
    }

    @Override
    public synchronized long getNumberOfCancelledJobs() {
        return this.cancelledJobs;
    }

    @Override
    public synchronized long getNumberOfFailedJobs() {
        return this.failedJobs;
    }

    @Override
    public synchronized long getLastActivatedJobTime() {
        return this.lastActivated;
    }

    @Override
    public synchronized long getLastFinishedJobTime() {
        return this.lastFinished;
    }

    public synchronized void finishedJob(long jobTime) {
        this.lastFinished = System.currentTimeMillis();
        this.processingTime += jobTime;
        ++this.processingCount;
        this.averageProcessingTime = this.processingTime / this.processingCount;
        ++this.finishedJobs;
        --this.activeJobs;
    }

    public synchronized void failedJob() {
        ++this.failedJobs;
        --this.activeJobs;
        ++this.queuedJobs;
    }

    public synchronized void cancelledJob() {
        ++this.cancelledJobs;
        --this.activeJobs;
    }

    public synchronized void incQueued() {
        ++this.queuedJobs;
    }

    public synchronized void decQueued() {
        --this.queuedJobs;
    }

    public synchronized void clearQueued() {
        this.queuedJobs = 0L;
    }

    public synchronized void addActive(long queueTime) {
        --this.queuedJobs;
        ++this.activeJobs;
        ++this.waitingCount;
        this.waitingTime += queueTime;
        this.averageWaitingTime = this.waitingTime / this.waitingCount;
        this.lastActivated = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(StatisticsImpl other) {
        StatisticsImpl statisticsImpl = other;
        synchronized (statisticsImpl) {
            if (other.lastActivated > this.lastActivated) {
                this.lastActivated = other.lastActivated;
            }
            if (other.lastFinished > this.lastFinished) {
                this.lastFinished = other.lastFinished;
            }
            this.queuedJobs += other.queuedJobs;
            this.waitingTime += other.waitingTime;
            this.waitingCount += other.waitingCount;
            if (this.waitingCount > 0L) {
                this.averageWaitingTime = this.waitingTime / this.waitingCount;
            }
            this.processingTime += other.processingTime;
            this.processingCount += other.processingCount;
            if (this.processingCount > 0L) {
                this.averageProcessingTime = this.processingTime / this.processingCount;
            }
            this.finishedJobs += other.finishedJobs;
            this.failedJobs += other.failedJobs;
            this.cancelledJobs += other.cancelledJobs;
            this.activeJobs += other.activeJobs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(StatisticsImpl other) {
        long localActiveJobs;
        long localCancelledJobs;
        long localFailedJobs;
        long localFinishedJobs;
        long localProcessingCount;
        long localWaitingCount;
        long localProcessingTime;
        long localWaitingTime;
        long localAverageProcessingTime;
        long localAverageWaitingTime;
        long localLastFinished;
        long localLastActivated;
        long localQueuedJobs;
        StatisticsImpl statisticsImpl = other;
        synchronized (statisticsImpl) {
            localQueuedJobs = other.queuedJobs;
            localLastActivated = other.lastActivated;
            localLastFinished = other.lastFinished;
            localAverageWaitingTime = other.averageWaitingTime;
            localAverageProcessingTime = other.averageProcessingTime;
            localWaitingTime = other.waitingTime;
            localProcessingTime = other.processingTime;
            localWaitingCount = other.waitingCount;
            localProcessingCount = other.processingCount;
            localFinishedJobs = other.finishedJobs;
            localFailedJobs = other.failedJobs;
            localCancelledJobs = other.cancelledJobs;
            localActiveJobs = other.activeJobs;
        }
        statisticsImpl = this;
        synchronized (statisticsImpl) {
            this.queuedJobs = localQueuedJobs;
            this.lastActivated = localLastActivated;
            this.lastFinished = localLastFinished;
            this.averageWaitingTime = localAverageWaitingTime;
            this.averageProcessingTime = localAverageProcessingTime;
            this.waitingTime = localWaitingTime;
            this.processingTime = localProcessingTime;
            this.waitingCount = localWaitingCount;
            this.processingCount = localProcessingCount;
            this.finishedJobs = localFinishedJobs;
            this.failedJobs = localFailedJobs;
            this.cancelledJobs = localCancelledJobs;
            this.activeJobs = localActiveJobs;
        }
    }

    @Override
    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.lastActivated = -1L;
        this.lastFinished = -1L;
        this.averageWaitingTime = 0L;
        this.averageProcessingTime = 0L;
        this.waitingTime = 0L;
        this.processingTime = 0L;
        this.waitingCount = 0L;
        this.processingCount = 0L;
        this.finishedJobs = 0L;
        this.failedJobs = 0L;
        this.cancelledJobs = 0L;
    }
}

