/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.event.jobs.Queue;

public class JobImpl
implements Job,
Comparable<JobImpl> {
    public static final String PROPERTY_RESOURCE_PATH = "slingevent:path";
    public static final String PROPERTY_BRIDGED_EVENT = "slingevent:eventadmin";
    public static final String PROPERTY_DELAY_OVERRIDE = ":slingevent:delayOverride";
    public static final String PROPERTY_JOB_QUEUED = "event.job.queued.time";
    public static final String PROPERTY_FINISHED_STATE = "slingevent:finishedState";
    private final ValueMap properties;
    private final String topic;
    private final String path;
    private final String name;
    private final String jobId;
    private final boolean isBridgedEvent;
    private final List<Exception> readErrorList;
    private final long counter;

    public JobImpl(String topic, String name, String jobId, Map<String, Object> properties) {
        this.topic = topic;
        this.name = name;
        this.jobId = jobId;
        this.path = (String)properties.remove(PROPERTY_RESOURCE_PATH);
        this.isBridgedEvent = properties.get(PROPERTY_BRIDGED_EVENT) != null;
        this.readErrorList = (List)properties.remove(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
        this.properties = new ValueMapDecorator(properties);
        this.properties.put((Object)"slingevent:eventId", (Object)jobId);
        int lastPos = jobId.lastIndexOf(95);
        this.counter = Long.valueOf(jobId.substring(lastPos + 1));
    }

    public String getResourcePath() {
        return this.path;
    }

    public boolean isBridgedEvent() {
        return this.isBridgedEvent;
    }

    public boolean hasReadErrors() {
        return this.readErrorList != null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void retry() {
        int retries = (Integer)((Object)this.getProperty("event.job.retrycount", (Object)Integer.class));
        this.properties.put((Object)"event.job.retrycount", (Object)(retries + 1));
        this.properties.remove((Object)"event.job.started.time");
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.jobId;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get((Object)name);
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        return (T)this.properties.get(name, type);
    }

    @Override
    public <T> T getProperty(String name, T defaultValue) {
        return (T)this.properties.get(name, defaultValue);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public JobUtil.JobPriority getJobPriority() {
        return JobUtil.JobPriority.NORM;
    }

    @Override
    public int getRetryCount() {
        return (Integer)((Object)this.getProperty("event.job.retrycount", (Object)Integer.class));
    }

    @Override
    public int getNumberOfRetries() {
        return (Integer)((Object)this.getProperty("event.job.retries", (Object)Integer.class));
    }

    @Override
    public String getQueueName() {
        return (String)((Object)this.getProperty("event.job.queuename", (Object)String.class));
    }

    @Override
    public String getTargetInstance() {
        return (String)((Object)this.getProperty("event.job.application", (Object)String.class));
    }

    @Override
    public Calendar getProcessingStarted() {
        return (Calendar)((Object)this.getProperty("event.job.started.time", (Object)Calendar.class));
    }

    @Override
    public Calendar getCreated() {
        return (Calendar)((Object)this.getProperty("slingevent:created", (Object)Calendar.class));
    }

    @Override
    public String getCreatedInstance() {
        return (String)((Object)this.getProperty("slingevent:application", (Object)String.class));
    }

    public void updateQueueInfo(Queue queue) {
        this.properties.put((Object)"event.job.queuename", (Object)queue.getName());
        this.properties.put((Object)"event.job.retries", (Object)queue.getConfiguration().getMaxRetries());
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove((Object)name);
        } else {
            this.properties.put((Object)name, value);
        }
    }

    public String[] prepare(Queue queue) {
        this.updateQueueInfo(queue);
        this.properties.remove((Object)PROPERTY_DELAY_OVERRIDE);
        this.properties.remove((Object)"slingevent:progressLog");
        this.properties.remove((Object)"slingevent:progressETA");
        this.properties.remove((Object)"slingevent:progressSteps");
        this.properties.remove((Object)"slingevent:progressStep");
        this.properties.remove((Object)"slingevent:resultMessage");
        this.properties.put((Object)"event.job.started.time", (Object)Calendar.getInstance());
        return new String[]{"event.job.queuename", "event.job.retries", "slingevent:progressLog", "slingevent:progressETA", "slingevent:progressSteps", "slingevent:progressStep", "slingevent:resultMessage", "event.job.started.time"};
    }

    public String[] startProgress(int steps, long eta) {
        if (steps > 0) {
            this.setProperty("slingevent:progressSteps", steps);
        }
        if (eta > 0L) {
            Date finishDate = new Date(System.currentTimeMillis() + eta * 1000L);
            Calendar finishCal = Calendar.getInstance();
            finishCal.setTime(finishDate);
            this.setProperty("slingevent:progressETA", finishCal);
        }
        return new String[]{"slingevent:progressETA", "slingevent:progressSteps"};
    }

    public String[] setProgress(int step) {
        int steps = this.getProperty("slingevent:progressSteps", -1);
        if (steps > 0 && step > 0) {
            int current = this.getProperty("slingevent:progressStep", 0);
            if ((current += step) > steps) {
                current = steps;
            }
            this.setProperty("slingevent:progressStep", current);
            Calendar now = Calendar.getInstance();
            long elapsed = now.getTimeInMillis() - this.getProcessingStarted().getTimeInMillis();
            long eta = elapsed * (long)steps / (long)step;
            now.setTimeInMillis(eta);
            this.setProperty("slingevent:progressETA", now);
            return new String[]{"slingevent:progressStep", "slingevent:progressETA"};
        }
        return null;
    }

    public String update(long eta) {
        if (eta > 0L) {
            Date finishDate = new Date(System.currentTimeMillis() + eta * 1000L);
            Calendar finishCal = Calendar.getInstance();
            finishCal.setTime(finishDate);
            this.setProperty("slingevent:progressETA", eta);
        } else {
            this.properties.remove((Object)"slingevent:progressETA");
        }
        return "slingevent:progressETA";
    }

    public String log(String message, Object ... args) {
        String logEntry = MessageFormat.format(message, args);
        String[] entries = (String[])this.getProperty("slingevent:progressLog", (Object)String[].class);
        if (entries == null) {
            this.setProperty("slingevent:progressLog", new String[]{logEntry});
        } else {
            String[] newEntries = new String[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[entries.length] = logEntry;
            this.setProperty("slingevent:progressLog", newEntries);
        }
        return "slingevent:progressLog";
    }

    @Override
    public Job.JobState getJobState() {
        String enumValue = (String)((Object)this.getProperty(PROPERTY_FINISHED_STATE, (Object)String.class));
        if (enumValue == null) {
            if (this.getProcessingStarted() != null) {
                return Job.JobState.ACTIVE;
            }
            return Job.JobState.QUEUED;
        }
        return Job.JobState.valueOf(enumValue);
    }

    @Override
    public Calendar getFinishedDate() {
        return (Calendar)((Object)this.getProperty("slingevent:finishedDate", (Object)Calendar.class));
    }

    @Override
    public String getResultMessage() {
        return (String)((Object)this.getProperty("slingevent:resultMessage", (Object)String.class));
    }

    @Override
    public String[] getProgressLog() {
        return (String[])this.getProperty("slingevent:progressLog", (Object)String[].class);
    }

    @Override
    public int getProgressStepCount() {
        return this.getProperty("slingevent:progressSteps", -1);
    }

    @Override
    public int getFinishedProgressStep() {
        return this.getProperty("slingevent:progressStep", 0);
    }

    @Override
    public Calendar getProgressETA() {
        return (Calendar)((Object)this.getProperty("slingevent:progressETA", (Object)Calendar.class));
    }

    @Override
    public int compareTo(JobImpl o) {
        int result = this.getCreated().compareTo(o.getCreated());
        if (result == 0) {
            result = this.counter < o.counter ? -1 : (this.counter > o.counter ? 1 : this.jobId.compareTo(o.jobId));
        }
        return result;
    }

    public int hashCode() {
        return this.jobId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JobImpl) {
            return this.jobId.equals(((JobImpl)obj).jobId);
        }
        return false;
    }

    public String toString() {
        return "JobImpl [properties=" + this.properties + ", topic=" + this.topic + ", path=" + this.path + ", name=" + this.name + ", jobId=" + this.jobId + ", isBridgedEvent=" + this.isBridgedEvent + "]";
    }
}

