/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.scheduling.JobSchedulerImpl;
import org.apache.sling.event.impl.support.BatchResourceRemover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private final JobSchedulerImpl jobScheduler;
    private volatile long schedulerRuns;

    public CleanUpTask(JobManagerConfiguration config, JobSchedulerImpl jobScheduler) {
        this.configuration = config;
        this.jobScheduler = jobScheduler;
    }

    public void run() {
        ++this.schedulerRuns;
        this.logger.debug("Job manager maintenance: Starting #{}", (Object)this.schedulerRuns);
        TopologyCapabilities topologyCapabilities = this.configuration.getTopologyCapabilities();
        if (topologyCapabilities != null) {
            String cleanUpUnassignedPath = topologyCapabilities.isLeader() ? this.configuration.getUnassignedJobsPath() : null;
            if (this.schedulerRuns % 3L == 1L) {
                this.jobScheduler.maintenance();
            }
            if (this.schedulerRuns % 60L == 0L) {
                this.fullEmptyFolderCleanup(topologyCapabilities, this.configuration.getLocalJobsPath());
                if (cleanUpUnassignedPath != null) {
                    this.fullEmptyFolderCleanup(topologyCapabilities, cleanUpUnassignedPath);
                }
            } else if (this.schedulerRuns % 5L == 0L) {
                this.simpleEmptyFolderCleanup(topologyCapabilities, this.configuration.getLocalJobsPath());
                if (cleanUpUnassignedPath != null) {
                    this.simpleEmptyFolderCleanup(topologyCapabilities, cleanUpUnassignedPath);
                }
            }
        }
        this.lockCleanup(topologyCapabilities);
        this.logger.debug("Job manager maintenance: Finished #{}", (Object)this.schedulerRuns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCleanup(TopologyCapabilities caps) {
        if (caps != null && caps.isLeader()) {
            this.logger.debug("Cleaning up job resource tree: removing obsolete locks");
            ArrayList<Resource> candidates = new ArrayList<Resource>();
            ResourceResolver resolver = this.configuration.createResourceResolver();
            if (resolver != null) {
                try {
                    Resource parentResource = resolver.getResource(this.configuration.getLocksPath());
                    if (parentResource != null) {
                        Calendar startDate = Calendar.getInstance();
                        startDate.add(12, -2);
                        this.lockCleanup(caps, candidates, parentResource, startDate);
                        BatchResourceRemover remover = new BatchResourceRemover();
                        boolean batchRemove = true;
                        for (Resource lockResource : candidates) {
                            if (!caps.isActive()) break;
                            try {
                                if (batchRemove) {
                                    remover.delete(lockResource);
                                    continue;
                                }
                                resolver.delete(lockResource);
                                resolver.commit();
                            }
                            catch (PersistenceException pe) {
                                batchRemove = false;
                                this.ignoreException((Exception)((Object)pe));
                                resolver.refresh();
                            }
                        }
                        try {
                            resolver.commit();
                        }
                        catch (PersistenceException pe) {
                            this.ignoreException((Exception)((Object)pe));
                            resolver.refresh();
                        }
                    }
                }
                finally {
                    resolver.close();
                }
            }
        }
    }

    private void lockCleanup(TopologyCapabilities caps, List<Resource> candidates, Resource parentResource, Calendar startDate) {
        for (Resource childResource : parentResource.getChildren()) {
            if (!caps.isActive()) break;
            ValueMap vm = ResourceUtil.getValueMap((Resource)childResource);
            Calendar created = (Calendar)vm.get("lock.created", Calendar.class);
            if (created != null) {
                if (!created.before(startDate)) continue;
                candidates.add(childResource);
                continue;
            }
            this.lockCleanup(caps, candidates, childResource, startDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleEmptyFolderCleanup(TopologyCapabilities caps, String basePath) {
        this.logger.debug("Cleaning up job resource tree: looking for empty folders");
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            Calendar cleanUpDate = Calendar.getInstance();
            cleanUpDate.add(12, -5);
            Resource baseResource = resolver.getResource(basePath);
            if (baseResource != null) {
                Iterator topicIter = baseResource.listChildren();
                while (caps.isActive() && topicIter.hasNext()) {
                    Resource topicResource = (Resource)topicIter.next();
                    for (int i = 0; i < 10; ++i) {
                        String hourPath;
                        Resource hourResource;
                        if (!caps.isActive()) continue;
                        StringBuilder sb = new StringBuilder(topicResource.getPath());
                        sb.append('/');
                        sb.append(cleanUpDate.get(1));
                        sb.append('/');
                        sb.append(cleanUpDate.get(2) + 1);
                        sb.append('/');
                        sb.append(cleanUpDate.get(5));
                        sb.append('/');
                        sb.append(cleanUpDate.get(11));
                        sb.append('/');
                        sb.append(cleanUpDate.get(12));
                        String path = sb.toString();
                        Resource dateResource = resolver.getResource(path);
                        if (dateResource != null && !dateResource.listChildren().hasNext()) {
                            resolver.delete(dateResource);
                            resolver.commit();
                        }
                        if (path.endsWith("59") && (hourResource = resolver.getResource(hourPath = path.substring(0, path.length() - 3))) != null && !hourResource.listChildren().hasNext()) {
                            resolver.delete(hourResource);
                            resolver.commit();
                        }
                        cleanUpDate.add(12, -1);
                    }
                }
            }
        }
        catch (PersistenceException pe) {
            this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
        }
        finally {
            resolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullEmptyFolderCleanup(TopologyCapabilities caps, String basePath) {
        this.logger.debug("Cleaning up job resource tree: removing ALL empty folders");
        ResourceResolver resolver = this.configuration.createResourceResolver();
        if (resolver == null) {
            return;
        }
        try {
            Resource baseResource = resolver.getResource(basePath);
            if (baseResource != null) {
                Calendar now = Calendar.getInstance();
                Iterator topicIter = baseResource.listChildren();
                while (caps.isActive() && topicIter.hasNext()) {
                    Resource topicResource = (Resource)topicIter.next();
                    Iterator yearIter = topicResource.listChildren();
                    while (caps.isActive() && yearIter.hasNext()) {
                        Resource yearResource = (Resource)yearIter.next();
                        int year = Integer.valueOf(yearResource.getName());
                        boolean oldYear = year < now.get(1);
                        Iterator monthIter = yearResource.listChildren();
                        while (caps.isActive() && monthIter.hasNext()) {
                            Resource monthResource = (Resource)monthIter.next();
                            int month = Integer.valueOf(monthResource.getName());
                            boolean oldMonth = oldYear || month < now.get(2) + 1;
                            Iterator dayIter = monthResource.listChildren();
                            while (caps.isActive() && dayIter.hasNext()) {
                                Resource dayResource = (Resource)dayIter.next();
                                int day = Integer.valueOf(dayResource.getName());
                                boolean oldDay = oldMonth || day < now.get(5);
                                Iterator hourIter = dayResource.listChildren();
                                while (caps.isActive() && hourIter.hasNext()) {
                                    boolean oldHour;
                                    Resource hourResource = (Resource)hourIter.next();
                                    int hour = Integer.valueOf(hourResource.getName());
                                    boolean bl = oldHour = oldDay && (oldMonth || now.get(11) > 0) || hour < now.get(11) - 1;
                                    if (oldHour) {
                                        Iterator minuteIter = hourResource.listChildren();
                                        while (caps.isActive() && minuteIter.hasNext()) {
                                            Resource minuteResource = (Resource)minuteIter.next();
                                            if (minuteResource.listChildren().hasNext()) continue;
                                            resolver.delete(minuteResource);
                                            resolver.commit();
                                        }
                                    }
                                    if (!caps.isActive() || !oldHour || hourResource.listChildren().hasNext()) continue;
                                    resolver.delete(hourResource);
                                    resolver.commit();
                                }
                                if (!caps.isActive() || !oldDay || dayResource.listChildren().hasNext()) continue;
                                resolver.delete(dayResource);
                                resolver.commit();
                            }
                            if (!caps.isActive() || !oldMonth || monthResource.listChildren().hasNext()) continue;
                            resolver.delete(monthResource);
                            resolver.commit();
                        }
                        if (!caps.isActive() || !oldYear || yearResource.listChildren().hasNext()) continue;
                        resolver.delete(yearResource);
                        resolver.commit();
                    }
                }
            }
        }
        catch (PersistenceException pe) {
            this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
        }
        finally {
            resolver.close();
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }
}

