/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.support;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.quartz.CronExpression;

public class ScheduleInfoImpl
implements ScheduleInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String VERSION = "1";
    private final ScheduleInfo.ScheduleType scheduleType;
    private final int dayOfWeek;
    private final int hourOfDay;
    private final int minuteOfHour;
    private final Date at;
    private final int monthOfYear;
    private final String expression;

    public static ScheduleInfoImpl HOURLY(int minutes) {
        return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.HOURLY, -1, -1, minutes, null, -1, null);
    }

    public static ScheduleInfoImpl CRON(String expr) {
        return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.CRON, -1, -1, -1, null, -1, expr);
    }

    public static ScheduleInfoImpl AT(Date at) {
        return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.DATE, -1, -1, -1, at, -1, null);
    }

    public static ScheduleInfoImpl YEARLY(int month, int day, int hour, int minute) {
        return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.YEARLY, day, hour, minute, null, month, null);
    }

    public static ScheduleInfoImpl MONTHLY(int day, int hour, int minute) {
        return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.MONTHLY, day, hour, minute, null, -1, null);
    }

    public static ScheduleInfoImpl WEEKLY(int day, int hour, int minute) {
        return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.WEEKLY, day, hour, minute, null, -1, null);
    }

    public static ScheduleInfoImpl DAILY(int hour, int minute) {
        return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.DAILY, -1, hour, minute, null, -1, null);
    }

    private ScheduleInfoImpl(ScheduleInfo.ScheduleType scheduleType, int dayOfWeek, int hourOfDay, int minuteOfHour, Date at, int monthOfYear, String expression) {
        this.scheduleType = scheduleType;
        this.dayOfWeek = dayOfWeek;
        this.hourOfDay = hourOfDay;
        this.minuteOfHour = minuteOfHour;
        this.at = at;
        this.monthOfYear = monthOfYear;
        this.expression = expression;
    }

    public static ScheduleInfoImpl deserialize(ScheduleInfo.ScheduleType scheduleType, String s) {
        String[] parts = s.split("|");
        if (scheduleType == ScheduleInfo.ScheduleType.YEARLY && parts.length == 4) {
            try {
                return new ScheduleInfoImpl(scheduleType, Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), null, Integer.parseInt(parts[3]), null);
            }
            catch (IllegalArgumentException iae) {
            }
        } else if (scheduleType == ScheduleInfo.ScheduleType.MONTHLY && parts.length == 3) {
            try {
                return new ScheduleInfoImpl(scheduleType, Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), null, -1, null);
            }
            catch (IllegalArgumentException iae) {
            }
        } else if (scheduleType == ScheduleInfo.ScheduleType.WEEKLY && parts.length == 3) {
            try {
                return new ScheduleInfoImpl(scheduleType, Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), null, -1, null);
            }
            catch (IllegalArgumentException iae) {
            }
        } else if (scheduleType == ScheduleInfo.ScheduleType.DAILY && parts.length == 2) {
            try {
                return new ScheduleInfoImpl(scheduleType, -1, Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), null, -1, null);
            }
            catch (IllegalArgumentException iae) {
            }
        } else if (scheduleType == ScheduleInfo.ScheduleType.HOURLY && parts.length == 1) {
            try {
                return new ScheduleInfoImpl(scheduleType, -1, -1, Integer.parseInt(parts[0]), null, -1, null);
            }
            catch (IllegalArgumentException iae) {
            }
        } else if (scheduleType == ScheduleInfo.ScheduleType.CRON && parts.length == 1) {
            try {
                return new ScheduleInfoImpl(scheduleType, -1, -1, -1, null, -1, parts[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ScheduleInfoImpl deserialize(String s) {
        String[] parts = s.split("\\|");
        if (parts.length == 8 && parts[0].equals(VERSION)) {
            try {
                return new ScheduleInfoImpl(ScheduleInfo.ScheduleType.valueOf(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), parts[5].equals("null") ? null : new Date(Long.parseLong(parts[5])), Integer.parseInt(parts[6]), parts[7].equals("null") ? null : parts[7]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getSerializedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION);
        sb.append("|");
        sb.append(this.scheduleType.name());
        sb.append("|");
        sb.append(String.valueOf(this.dayOfWeek));
        sb.append("|");
        sb.append(String.valueOf(this.hourOfDay));
        sb.append("|");
        sb.append(String.valueOf(this.minuteOfHour));
        sb.append("|");
        if (this.at == null) {
            sb.append("null");
        } else {
            sb.append(String.valueOf(this.at.getTime()));
        }
        sb.append("|");
        sb.append(String.valueOf(this.monthOfYear));
        sb.append("|");
        if (this.expression == null) {
            sb.append("null");
        } else {
            sb.append(String.valueOf(this.expression));
        }
        return sb.toString();
    }

    @Override
    public ScheduleInfo.ScheduleType getType() {
        return this.scheduleType;
    }

    @Override
    public Date getAt() {
        return this.at;
    }

    @Override
    public int getDayOfWeek() {
        return this.scheduleType == ScheduleInfo.ScheduleType.WEEKLY ? this.dayOfWeek : -1;
    }

    @Override
    public int getHourOfDay() {
        return this.hourOfDay;
    }

    @Override
    public int getMinuteOfHour() {
        return this.minuteOfHour;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public int getMonthOfYear() {
        return this.monthOfYear;
    }

    @Override
    public int getDayOfMonth() {
        return this.scheduleType == ScheduleInfo.ScheduleType.MONTHLY || this.scheduleType == ScheduleInfo.ScheduleType.YEARLY ? this.dayOfWeek : -1;
    }

    public void check(List<String> errors) {
        switch (this.scheduleType) {
            case DAILY: {
                if (this.hourOfDay >= 0 && this.hourOfDay <= 23 && this.minuteOfHour >= 0 && this.minuteOfHour <= 59) break;
                errors.add("Wrong time information : " + this.minuteOfHour + ":" + this.minuteOfHour);
                break;
            }
            case DATE: {
                if (this.at != null && this.at.getTime() > System.currentTimeMillis() + 2000L) break;
                errors.add("Date must be in the future : " + this.at);
                break;
            }
            case HOURLY: {
                if (this.minuteOfHour >= 0 && this.minuteOfHour <= 59) break;
                errors.add("Minute must be between 0 and 59 : " + this.minuteOfHour);
                break;
            }
            case WEEKLY: {
                if (this.hourOfDay < 0 || this.hourOfDay > 23 || this.minuteOfHour < 0 || this.minuteOfHour > 59) {
                    errors.add("Wrong time information : " + this.minuteOfHour + ":" + this.minuteOfHour);
                }
                if (this.dayOfWeek >= 1 && this.dayOfWeek <= 7) break;
                errors.add("Day must be between 1 and 7 : " + this.dayOfWeek);
                break;
            }
            case MONTHLY: {
                if (this.hourOfDay < 0 || this.hourOfDay > 23 || this.minuteOfHour < 0 || this.minuteOfHour > 59) {
                    errors.add("Wrong time information : " + this.minuteOfHour + ":" + this.minuteOfHour);
                }
                if (this.dayOfWeek >= 1 && this.dayOfWeek <= 28) break;
                errors.add("Day must be between 1 and 28 : " + this.dayOfWeek);
                break;
            }
            case YEARLY: {
                if (this.hourOfDay < 0 || this.hourOfDay > 23 || this.minuteOfHour < 0 || this.minuteOfHour > 59) {
                    errors.add("Wrong time information : " + this.minuteOfHour + ":" + this.minuteOfHour);
                }
                if (this.dayOfWeek < 1 || this.dayOfWeek > 28) {
                    errors.add("Day must be between 1 and 28 : " + this.dayOfWeek);
                }
                if (this.monthOfYear >= 1 && this.monthOfYear <= 12) break;
                errors.add("Month must be between 1 and 12 : " + this.dayOfWeek);
                break;
            }
            case CRON: {
                if (this.expression == null) {
                    errors.add("Expression must be specified.");
                }
                try {
                    new CronExpression(this.expression);
                    break;
                }
                catch (ParseException e) {
                    errors.add("Expression must be valid: " + this.expression);
                }
            }
        }
    }

    public Date getNextScheduledExecution() {
        Calendar now = Calendar.getInstance();
        switch (this.scheduleType) {
            case DATE: {
                return this.at;
            }
            case DAILY: {
                Calendar next = Calendar.getInstance();
                next.set(11, this.hourOfDay);
                next.set(12, this.minuteOfHour);
                if (next.before(now)) {
                    next.add(7, 1);
                }
                return next.getTime();
            }
            case WEEKLY: {
                Calendar nextW = Calendar.getInstance();
                nextW.set(11, this.hourOfDay);
                nextW.set(12, this.minuteOfHour);
                nextW.set(7, this.dayOfWeek);
                if (nextW.before(now)) {
                    nextW.add(3, 1);
                }
                return nextW.getTime();
            }
            case HOURLY: {
                Calendar nextH = Calendar.getInstance();
                nextH.set(12, this.minuteOfHour);
                if (nextH.before(now)) {
                    nextH.add(11, 1);
                }
                return nextH.getTime();
            }
            case MONTHLY: {
                Calendar nextM = Calendar.getInstance();
                nextM.set(11, this.hourOfDay);
                nextM.set(12, this.minuteOfHour);
                nextM.set(5, this.dayOfWeek);
                if (nextM.before(now)) {
                    nextM.add(2, 1);
                }
                return nextM.getTime();
            }
            case YEARLY: {
                Calendar nextY = Calendar.getInstance();
                nextY.set(11, this.hourOfDay);
                nextY.set(12, this.minuteOfHour);
                nextY.set(5, this.dayOfWeek);
                nextY.set(2, this.monthOfYear - 1);
                if (nextY.before(now)) {
                    nextY.add(1, 1);
                }
                return nextY.getTime();
            }
            case CRON: {
                try {
                    CronExpression exp = new CronExpression(this.expression);
                    return exp.getNextValidTimeAfter(new Date());
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String getCronExpression() {
        if (this.scheduleType == ScheduleInfo.ScheduleType.DAILY) {
            StringBuilder sb = new StringBuilder("0 ");
            sb.append(String.valueOf(this.minuteOfHour));
            sb.append(' ');
            sb.append(String.valueOf(this.hourOfDay));
            sb.append(" * * ?");
            return sb.toString();
        }
        if (this.scheduleType == ScheduleInfo.ScheduleType.WEEKLY) {
            StringBuilder sb = new StringBuilder("0 ");
            sb.append(String.valueOf(this.minuteOfHour));
            sb.append(' ');
            sb.append(String.valueOf(this.hourOfDay));
            sb.append(" ? * ");
            sb.append(String.valueOf(this.dayOfWeek));
            return sb.toString();
        }
        if (this.scheduleType == ScheduleInfo.ScheduleType.HOURLY) {
            StringBuilder sb = new StringBuilder("0 ");
            sb.append(String.valueOf(this.minuteOfHour));
            sb.append(" * * * ?");
            return sb.toString();
        }
        if (this.scheduleType == ScheduleInfo.ScheduleType.MONTHLY) {
            StringBuilder sb = new StringBuilder("0 ");
            sb.append(String.valueOf(this.minuteOfHour));
            sb.append(' ');
            sb.append(String.valueOf(this.hourOfDay));
            sb.append(' ');
            sb.append(String.valueOf(this.dayOfWeek));
            sb.append(" * ?");
            return sb.toString();
        }
        if (this.scheduleType == ScheduleInfo.ScheduleType.YEARLY) {
            StringBuilder sb = new StringBuilder("0 ");
            sb.append(String.valueOf(this.minuteOfHour));
            sb.append(' ');
            sb.append(String.valueOf(this.hourOfDay));
            sb.append(' ');
            sb.append(String.valueOf(this.dayOfWeek));
            sb.append(' ');
            sb.append(String.valueOf(this.monthOfYear - 1));
            sb.append(" ?");
            return sb.toString();
        }
        if (this.scheduleType == ScheduleInfo.ScheduleType.CRON) {
            return this.expression;
        }
        return null;
    }

    public String toString() {
        return "ScheduleInfo [scheduleType=" + (Object)((Object)this.scheduleType) + ", dayOfWeek=" + this.dayOfWeek + ", hourOfDay=" + this.hourOfDay + ", minuteOfHour=" + this.minuteOfHour + ", at=" + this.at + ", monthOfYear=" + this.monthOfYear + ", expression=" + this.expression + "]";
    }
}

