/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.consumer.JobExecutor;

public class JobHandler {
    private final JobImpl job;
    public volatile long started = -1L;
    private volatile boolean isStopped = false;
    private final JobManagerConfiguration configuration;
    private final JobExecutor consumer;

    public JobHandler(JobImpl job, JobExecutor consumer, JobManagerConfiguration configuration) {
        this.job = job;
        this.consumer = consumer;
        this.configuration = configuration;
    }

    public JobImpl getJob() {
        return this.job;
    }

    public JobExecutor getConsumer() {
        return this.consumer;
    }

    public boolean startProcessing(Queue queue) {
        this.isStopped = false;
        return this.persistJobProperties(this.job.prepare(queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reschedule() {
        block7: {
            ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                Resource jobResource = resolver.getResource(this.job.getResourcePath());
                if (jobResource == null) break block7;
                ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                mvm.put((Object)"event.job.retrycount", this.job.getProperty("event.job.retrycount", Integer.class));
                if (this.job.getProperty("slingevent:resultMessage") != null) {
                    mvm.put((Object)"slingevent:resultMessage", this.job.getProperty("slingevent:resultMessage"));
                }
                mvm.remove((Object)"event.job.started.time");
                mvm.put((Object)"event.job.queued.time", (Object)Calendar.getInstance());
                try {
                    resolver.commit();
                    boolean bl = true;
                    return bl;
                }
                catch (PersistenceException pe) {
                    this.configuration.getMainLogger().debug("Unable to update reschedule properties for job " + this.job.getId(), (Throwable)pe);
                }
            }
            finally {
                resolver.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(Job.JobState state, boolean keepJobInHistory, Long duration) {
        block11: {
            boolean isSuccess = state == Job.JobState.SUCCEEDED;
            ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                Resource jobResource = resolver.getResource(this.job.getResourcePath());
                if (jobResource == null) break block11;
                try {
                    String newPath = null;
                    if (keepJobInHistory) {
                        ValueMap vm = ResourceHelper.getValueMap(jobResource);
                        newPath = this.configuration.getStoragePath(this.job.getTopic(), this.job.getId(), isSuccess);
                        HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                        props.put("slingevent:finishedState", state.name());
                        if (isSuccess) {
                            Date finishDate = new Date();
                            finishDate.setTime(this.job.getProcessingStarted().getTime().getTime() + duration);
                            Calendar finishCal = Calendar.getInstance();
                            finishCal.setTime(finishDate);
                            props.put("slingevent:finishedDate", finishCal);
                        } else {
                            props.put("slingevent:finishedDate", Calendar.getInstance());
                        }
                        if (this.job.getProperty("slingevent:resultMessage") != null) {
                            props.put("slingevent:resultMessage", this.job.getProperty("slingevent:resultMessage"));
                        }
                        ResourceHelper.getOrCreateResource(resolver, newPath, props);
                    }
                    resolver.delete(jobResource);
                    resolver.commit();
                    if (!keepJobInHistory || !this.configuration.getMainLogger().isDebugEnabled()) break block11;
                    if (isSuccess) {
                        this.configuration.getMainLogger().debug("Kept successful job {} at {}", (Object)Utility.toString(this.job), (Object)newPath);
                        break block11;
                    }
                    this.configuration.getMainLogger().debug("Moved cancelled job {} to {}", (Object)Utility.toString(this.job), (Object)newPath);
                }
                catch (PersistenceException pe) {
                    this.configuration.getMainLogger().warn("Unable to finish job " + this.job.getId(), (Throwable)pe);
                }
                catch (InstantiationException ie) {
                    this.configuration.getMainLogger().debug("Unable to instantiate job", (Throwable)ie);
                }
            }
            finally {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassign() {
        block9: {
            QueueConfigurationManager.QueueInfo queueInfo = this.configuration.getQueueConfigurationManager().getQueueInfo(this.job.getTopic());
            TopologyCapabilities caps = this.configuration.getTopologyCapabilities();
            String targetId = caps == null ? null : caps.detectTarget(this.job.getTopic(), this.job.getProperties(), queueInfo);
            ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                Resource jobResource = resolver.getResource(this.job.getResourcePath());
                if (jobResource == null) break block9;
                try {
                    ValueMap vm = ResourceHelper.getValueMap(jobResource);
                    String newPath = this.configuration.getUniquePath(targetId, this.job.getTopic(), this.job.getId(), this.job.getProperties());
                    HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                    props.remove("event.job.queuename");
                    if (targetId == null) {
                        props.remove("event.job.application");
                    } else {
                        props.put("event.job.application", targetId);
                    }
                    props.remove("event.job.started.time");
                    try {
                        ResourceHelper.getOrCreateResource(resolver, newPath, props);
                        resolver.delete(jobResource);
                        resolver.commit();
                    }
                    catch (PersistenceException pe) {
                        this.configuration.getMainLogger().warn("Unable to reassign job " + this.job.getId(), (Throwable)pe);
                    }
                }
                catch (InstantiationException ie) {
                    this.configuration.getMainLogger().debug("Unable to instantiate job", (Throwable)ie);
                }
            }
            finally {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persistJobProperties(String ... propNames) {
        if (propNames != null) {
            ResourceResolver resolver = this.configuration.createResourceResolver();
            try {
                Resource jobResource = resolver.getResource(this.job.getResourcePath());
                if (jobResource != null) {
                    ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                    for (String propName : propNames) {
                        Object val = this.job.getProperty(propName);
                        if (val != null) {
                            if (val.getClass().isEnum()) {
                                mvm.put((Object)propName, (Object)val.toString());
                                continue;
                            }
                            mvm.put((Object)propName, val);
                            continue;
                        }
                        mvm.remove((Object)propName);
                    }
                    resolver.commit();
                    boolean bl = true;
                    return bl;
                }
                this.configuration.getMainLogger().debug("No job resource found at {}", (Object)this.job.getResourcePath());
            }
            catch (PersistenceException ignore) {
                this.configuration.getMainLogger().debug("Unable to persist properties", (Throwable)ignore);
            }
            finally {
                resolver.close();
            }
            return false;
        }
        return true;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void stop() {
        this.isStopped = true;
    }

    public void addToRetryList() {
        this.configuration.addJobToRetryList(this.job);
    }

    public boolean removeFromRetryList() {
        return this.configuration.removeJobFromRetryList(this.job);
    }

    public int hashCode() {
        return this.job.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobHandler)) {
            return false;
        }
        return this.job.getId().equals(((JobHandler)obj).job.getId());
    }

    public String toString() {
        return "JobHandler(" + this.job.getId() + ")";
    }
}

