/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyCapabilities {
    public static final String PROPERTY_TOPICS = "org.apache.sling.event.jobs.consumer.topics";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<InstanceDescription>> instanceCapabilities;
    private final Map<String, Integer> roundRobinMap = new HashMap<String, Integer>();
    private final Map<String, InstanceDescription> instanceMap = new HashMap<String, InstanceDescription>();
    private final boolean isLeader;
    private volatile boolean active = true;
    private final Map<String, String> allInstances;
    private final InstanceDescriptionComparator instanceComparator;
    private final JobManagerConfiguration jobManagerConfiguration;
    private final TopologyView view;

    public static Map<String, String> getAllInstancesMap(TopologyView view) {
        TreeMap<String, String> allInstances = new TreeMap<String, String>();
        for (InstanceDescription desc : view.getInstances()) {
            String topics = desc.getProperty(PROPERTY_TOPICS);
            if (topics != null && topics.length() > 0) {
                allInstances.put(desc.getSlingId(), topics);
                continue;
            }
            allInstances.put(desc.getSlingId(), "");
        }
        return allInstances;
    }

    public TopologyCapabilities(TopologyView view, JobManagerConfiguration config) {
        this.jobManagerConfiguration = config;
        this.instanceComparator = new InstanceDescriptionComparator(view.getLocalInstance().getClusterView().getId());
        this.isLeader = view.getLocalInstance().isLeader();
        this.allInstances = TopologyCapabilities.getAllInstancesMap(view);
        HashMap<String, List<InstanceDescription>> newCaps = new HashMap<String, List<InstanceDescription>>();
        for (InstanceDescription desc : view.getInstances()) {
            String topics = desc.getProperty(PROPERTY_TOPICS);
            if (topics != null && topics.length() > 0) {
                this.logger.debug("Detected capabilities of {} : {}", (Object)desc.getSlingId(), (Object)topics);
                for (String topic : topics.split(",")) {
                    ArrayList<InstanceDescription> list = (ArrayList<InstanceDescription>)newCaps.get(topic);
                    if (list == null) {
                        list = new ArrayList<InstanceDescription>();
                        newCaps.put(topic, list);
                    }
                    list.add(desc);
                    Collections.sort(list, this.instanceComparator);
                }
            }
            this.instanceMap.put(desc.getSlingId(), desc);
        }
        this.instanceCapabilities = newCaps;
        this.view = view;
    }

    public boolean isSame(Map<String, String> newAllInstancesMap) {
        return this.allInstances.equals(newAllInstancesMap);
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active && this.jobManagerConfiguration.isActive() && this.view.isCurrent();
    }

    public boolean isActive(String instanceId) {
        return this.allInstances.containsKey(instanceId);
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    private void addAll(List<InstanceDescription> potentialTargets, List<InstanceDescription> newTargets) {
        if (newTargets != null) {
            for (InstanceDescription desc : newTargets) {
                boolean found = false;
                for (InstanceDescription existingDesc : potentialTargets) {
                    if (!desc.getSlingId().equals(existingDesc.getSlingId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                potentialTargets.add(desc);
            }
        }
    }

    public List<InstanceDescription> getPotentialTargets(String jobTopic, Map<String, Object> jobProperties) {
        List<InstanceDescription> bridgedTargets;
        ArrayList<InstanceDescription> potentialTargets = new ArrayList<InstanceDescription>();
        this.addAll(potentialTargets, this.instanceCapabilities.get(jobTopic));
        int pos = jobTopic.lastIndexOf(47);
        if (pos > 0) {
            String category = jobTopic.substring(0, pos + 1).concat("*");
            this.addAll(potentialTargets, this.instanceCapabilities.get(category));
            do {
                String subCategory = jobTopic.substring(0, pos + 1).concat("**");
                this.addAll(potentialTargets, this.instanceCapabilities.get(subCategory));
            } while ((pos = jobTopic.lastIndexOf(47, pos - 1)) > 0);
        }
        List<InstanceDescription> list = bridgedTargets = jobProperties != null && jobProperties.containsKey("slingevent:eventadmin") ? this.instanceCapabilities.get("/") : null;
        if (bridgedTargets != null) {
            potentialTargets.addAll(bridgedTargets);
        }
        Collections.sort(potentialTargets, this.instanceComparator);
        return potentialTargets;
    }

    public String detectTarget(String jobTopic, Map<String, Object> jobProperties, QueueConfigurationManager.QueueInfo queueInfo) {
        List<InstanceDescription> potentialTargets = this.getPotentialTargets(jobTopic, jobProperties);
        this.logger.debug("Potential targets for {} : {}", (Object)jobTopic, potentialTargets);
        String createdOn = null;
        if (jobProperties != null) {
            createdOn = (String)jobProperties.get("slingevent:application");
        }
        if (createdOn == null) {
            createdOn = Environment.APPLICATION_ID;
        }
        InstanceDescription createdOnInstance = this.instanceMap.get(createdOn);
        if (potentialTargets != null && potentialTargets.size() > 0) {
            if (createdOnInstance != null) {
                ArrayList<InstanceDescription> localTargets = new ArrayList<InstanceDescription>();
                for (InstanceDescription desc : potentialTargets) {
                    if (!desc.getClusterView().getId().equals(createdOnInstance.getClusterView().getId()) || this.jobManagerConfiguration.disableDistribution() && !desc.isLeader()) continue;
                    localTargets.add(desc);
                }
                if (localTargets.size() > 0) {
                    potentialTargets.clear();
                    potentialTargets.addAll(localTargets);
                    this.logger.debug("Potential targets filtered for {} : {}", (Object)jobTopic, potentialTargets);
                }
            }
            if (queueInfo.queueConfiguration.isPreferRunOnCreationInstance()) {
                InstanceDescription creationDesc = null;
                for (InstanceDescription desc : potentialTargets) {
                    if (!desc.getSlingId().equals(createdOn)) continue;
                    creationDesc = desc;
                    break;
                }
                if (creationDesc != null) {
                    potentialTargets.clear();
                    potentialTargets.add(creationDesc);
                    this.logger.debug("Potential targets reduced to creation instance for {} : {}", (Object)jobTopic, potentialTargets);
                }
            }
            if (queueInfo.queueConfiguration.getType() == QueueConfiguration.Type.ORDERED) {
                String result = potentialTargets.get(0).getSlingId();
                this.logger.debug("Target for {} : {}", (Object)jobTopic, (Object)result);
                return result;
            }
            Integer index = this.roundRobinMap.get(jobTopic);
            if (index == null) {
                index = 0;
            }
            if (index >= potentialTargets.size()) {
                index = 0;
            }
            this.roundRobinMap.put(jobTopic, index + 1);
            String result = potentialTargets.get(index).getSlingId();
            this.logger.debug("Target for {} : {}", (Object)jobTopic, (Object)result);
            return result;
        }
        return null;
    }

    public Map<String, List<InstanceDescription>> getInstanceCapabilities() {
        return this.instanceCapabilities;
    }

    public static final class InstanceDescriptionComparator
    implements Comparator<InstanceDescription> {
        private final String localClusterId;

        public InstanceDescriptionComparator(String clusterId) {
            this.localClusterId = clusterId;
        }

        @Override
        public int compare(InstanceDescription o1, InstanceDescription o2) {
            if (o1.getSlingId().equals(o2.getSlingId())) {
                return 0;
            }
            boolean o1IsLocalCluster = this.localClusterId.equals(o1.getClusterView().getId());
            boolean o2IsLocalCluster = this.localClusterId.equals(o2.getClusterView().getId());
            if (o1IsLocalCluster && !o2IsLocalCluster) {
                return -1;
            }
            if (!o1IsLocalCluster && o2IsLocalCluster) {
                return 1;
            }
            if (o1IsLocalCluster) {
                if (o1.isLeader() && !o2.isLeader()) {
                    return -1;
                }
                if (o2.isLeader() && !o1.isLeader()) {
                    return 1;
                }
            }
            return o1.getSlingId().compareTo(o2.getSlingId());
        }
    }
}

