/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={TopologyEventListener.class})
public class TopologyHandler
implements TopologyEventListener,
Runnable {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private JobManagerConfiguration configuration;
    private final BlockingQueue<QueueItem> queue = new LinkedBlockingQueue<QueueItem>();
    private final AtomicBoolean isActive = new AtomicBoolean(false);

    @Activate
    protected void activate() {
        this.isActive.set(true);
        Thread thread = new Thread((Runnable)this, "Apache Sling Job Topology Listener Thread");
        thread.setDaemon(true);
        thread.start();
    }

    @Deactivate
    protected void deactivate() {
        this.isActive.set(false);
        this.queue.clear();
        try {
            this.queue.put(new QueueItem());
        }
        catch (InterruptedException ie) {
            this.logger.warn("Thread got interrupted.", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    public void handleTopologyEvent(TopologyEvent event) {
        QueueItem item = new QueueItem();
        item.event = event;
        try {
            this.queue.put(item);
        }
        catch (InterruptedException ie) {
            this.logger.warn("Thread got interrupted.", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        while (this.isActive.get()) {
            JobManagerConfiguration config;
            QueueItem item = null;
            try {
                item = this.queue.take();
            }
            catch (InterruptedException ie) {
                this.logger.warn("Thread got interrupted.", (Throwable)ie);
                Thread.currentThread().interrupt();
                this.isActive.set(false);
            }
            if (!this.isActive.get() || item == null || item.event == null || (config = this.configuration) == null) continue;
            config.handleTopologyEvent(item.event);
        }
    }

    protected void bindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        this.configuration = jobManagerConfiguration;
    }

    protected void unbindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        if (this.configuration == jobManagerConfiguration) {
            this.configuration = null;
        }
    }

    public static final class QueueItem {
        public TopologyEvent event;
    }
}

