/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.event.impl.jobs.JobTopicTraverser;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private final TopologyCapabilities caps;

    public UpgradeTask(JobManagerConfiguration config) {
        this.configuration = config;
        this.caps = this.configuration.getTopologyCapabilities();
    }

    public void run() {
        if (this.caps.isLeader()) {
            this.processJobsFromPreviousVersions();
        }
        this.upgradeBridgedJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeBridgedJobs() {
        String path = this.configuration.getLocalJobsPath() + '/' + "slingevent:eventadmin";
        ResourceResolver resolver = this.configuration.createResourceResolver();
        if (resolver != null) {
            try {
                Resource unassignedRoot;
                Resource rootResource = resolver.getResource(path);
                if (rootResource != null) {
                    this.upgradeBridgedJobs(rootResource);
                }
                if (this.caps.isLeader() && (unassignedRoot = resolver.getResource(this.configuration.getUnassignedJobsPath() + '/' + "slingevent:eventadmin")) != null) {
                    this.upgradeBridgedJobs(unassignedRoot);
                }
            }
            finally {
                resolver.close();
            }
        }
    }

    private void upgradeBridgedJobs(final Resource topicResource) {
        final String topicName = topicResource.getName().replace('.', '/');
        QueueConfigurationManager qcm = this.configuration.getQueueConfigurationManager();
        if (qcm == null) {
            return;
        }
        final QueueConfigurationManager.QueueInfo info = qcm.getQueueInfo(topicName);
        JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.ResourceCallback(){

            @Override
            public boolean handle(Resource rsrc) {
                try {
                    String newPath;
                    ValueMap vm = ResourceHelper.getValueMap(rsrc);
                    String targetId = UpgradeTask.this.caps.detectTarget(topicName, (Map<String, Object>)vm, info);
                    HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                    if (targetId != null) {
                        newPath = UpgradeTask.this.configuration.getAssginedJobsPath() + '/' + targetId + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                        props.put("event.job.queuename", info.queueName);
                        props.put("event.job.application", targetId);
                    } else {
                        newPath = UpgradeTask.this.configuration.getUnassignedJobsPath() + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                        props.remove("event.job.queuename");
                        props.remove("event.job.application");
                    }
                    props.remove("event.job.started.time");
                    try {
                        ResourceHelper.getOrCreateResource(topicResource.getResourceResolver(), newPath, props);
                        topicResource.getResourceResolver().delete(rsrc);
                        topicResource.getResourceResolver().commit();
                    }
                    catch (PersistenceException pe) {
                        UpgradeTask.this.logger.warn("Unable to move job from previous version " + rsrc.getPath(), (Throwable)pe);
                        topicResource.getResourceResolver().refresh();
                        topicResource.getResourceResolver().revert();
                    }
                }
                catch (InstantiationException ie) {
                    UpgradeTask.this.logger.warn("Unable to move job from previous version " + rsrc.getPath(), (Throwable)ie);
                    topicResource.getResourceResolver().refresh();
                    topicResource.getResourceResolver().revert();
                }
                return UpgradeTask.this.caps.isActive();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJobsFromPreviousVersions() {
        ResourceResolver resolver = this.configuration.createResourceResolver();
        if (resolver != null) {
            try {
                this.processJobsFromPreviousVersions(resolver.getResource(this.configuration.getPreviousVersionAnonPath()));
                this.processJobsFromPreviousVersions(resolver.getResource(this.configuration.getPreviousVersionIdentifiedPath()));
            }
            catch (PersistenceException pe) {
                this.logger.warn("Problems moving jobs from previous version.", (Throwable)pe);
            }
            finally {
                resolver.close();
            }
        }
    }

    private void processJobsFromPreviousVersions(Resource rsrc) throws PersistenceException {
        if (rsrc != null && this.caps.isActive()) {
            if (rsrc.isResourceType("slingevent:Job")) {
                this.moveJobFromPreviousVersion(rsrc);
            } else {
                for (Resource child : rsrc.getChildren()) {
                    this.processJobsFromPreviousVersions(child);
                }
                if (this.caps.isActive()) {
                    rsrc.getResourceResolver().delete(rsrc);
                    rsrc.getResourceResolver().commit();
                    rsrc.getResourceResolver().refresh();
                }
            }
        }
    }

    private void moveJobFromPreviousVersion(Resource jobResource) throws PersistenceException {
        ResourceResolver resolver = jobResource.getResourceResolver();
        try {
            ValueMap vm = ResourceHelper.getValueMap(jobResource);
            HashMap<String, Object> binaryProperties = new HashMap<String, Object>();
            ObjectInputStream ois = (ObjectInputStream)vm.get("slingevent:properties", ObjectInputStream.class);
            if (ois != null) {
                try {
                    int length = ois.readInt();
                    for (int i = 0; i < length; ++i) {
                        String key = (String)ois.readObject();
                        Object value = ois.readObject();
                        binaryProperties.put(key, value);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PersistenceException("Class not found.", (Throwable)cnfe);
                }
                catch (InvalidClassException ice) {
                    throw new PersistenceException("Invalid class.", (Throwable)ice);
                }
                catch (IOException ioe) {
                    throw new PersistenceException("Unable to deserialize job properties.", (Throwable)ioe);
                }
                finally {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {
                        throw new PersistenceException("Unable to deserialize job properties.", (Throwable)ioe);
                    }
                }
            }
            Map<String, Object> properties = ResourceHelper.cloneValueMap(vm);
            properties.put("slingevent:eventadmin", true);
            String topic = (String)properties.remove("slingevent:topic");
            properties.put("event.job.topic", topic);
            properties.remove("event.job.queuename");
            properties.remove("event.job.application");
            properties.putAll(binaryProperties);
            properties.remove("slingevent:properties");
            if (!properties.containsKey("event.job.retries")) {
                properties.put("event.job.retries", 10);
            }
            if (!properties.containsKey("event.job.retrycount")) {
                properties.put("event.job.retrycount", 0);
            }
            List<InstanceDescription> potentialTargets = this.caps.getPotentialTargets("/", null);
            String targetId = null;
            if (potentialTargets != null && potentialTargets.size() > 0) {
                QueueConfigurationManager qcm = this.configuration.getQueueConfigurationManager();
                if (qcm == null) {
                    resolver.revert();
                    return;
                }
                QueueConfigurationManager.QueueInfo info = qcm.getQueueInfo(topic);
                this.logger.debug("Found queue {} for {}", (Object)info.queueConfiguration, (Object)topic);
                targetId = this.caps.detectTarget(topic, (Map<String, Object>)vm, info);
                if (targetId != null) {
                    properties.put("event.job.queuename", info.queueName);
                    properties.put("event.job.application", targetId);
                    properties.put("event.job.retries", info.queueConfiguration.getMaxRetries());
                }
            }
            properties.put("slingevent:application", "old:" + Environment.APPLICATION_ID);
            properties.put("sling:resourceType", "slingevent:Job");
            String jobId = this.configuration.getUniqueId(topic);
            properties.put("slingevent:eventId", jobId);
            properties.remove("event.job.started.time");
            String newPath = this.configuration.getUniquePath(targetId, topic, jobId, (Map<String, Object>)vm);
            this.logger.debug("Moving 'old' job from {} to {}", (Object)jobResource.getPath(), (Object)newPath);
            ResourceHelper.getOrCreateResource(resolver, newPath, properties);
            resolver.delete(jobResource);
            resolver.commit();
        }
        catch (InstantiationException ie) {
            throw new PersistenceException("Exception while reading reasource: " + ie.getMessage(), ie.getCause());
        }
    }
}

