/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.event.impl.jobs.JobTopicTraverser;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckTopologyTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private final TopologyCapabilities caps;

    public CheckTopologyTask(JobManagerConfiguration config) {
        this.configuration = config;
        this.caps = this.configuration.getTopologyCapabilities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignJobsFromStoppedInstances() {
        if (this.caps.isLeader() && this.caps.isActive()) {
            this.logger.debug("Checking for stopped instances...");
            ResourceResolver resolver = this.configuration.createResourceResolver();
            if (resolver != null) {
                try {
                    Resource jobsRoot = resolver.getResource(this.configuration.getAssginedJobsPath());
                    this.logger.debug("Got jobs root {}", (Object)jobsRoot);
                    if (jobsRoot != null) {
                        Iterator instanceIter = jobsRoot.listChildren();
                        while (this.caps.isActive() && instanceIter.hasNext()) {
                            Resource instanceResource = (Resource)instanceIter.next();
                            String instanceId = instanceResource.getName();
                            if (this.caps.isActive(instanceId)) continue;
                            this.logger.debug("Found stopped instance {}", (Object)instanceId);
                            this.assignJobs(instanceResource, true);
                        }
                    }
                }
                finally {
                    resolver.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignStaleJobs() {
        block8: {
            if (this.caps.isActive()) {
                this.logger.debug("Checking for stale jobs...");
                final ResourceResolver resolver = this.configuration.createResourceResolver();
                if (resolver != null) {
                    try {
                        Resource jobsRoot = resolver.getResource(this.configuration.getLocalJobsPath());
                        if (jobsRoot == null) break block8;
                        Iterator topicIter = jobsRoot.listChildren();
                        while (this.caps.isActive() && topicIter.hasNext()) {
                            final Resource topicResource = (Resource)topicIter.next();
                            final String topicName = topicResource.getName().replace('.', '/');
                            this.logger.debug("Checking topic {}...", (Object)topicName);
                            List<InstanceDescription> potentialTargets = this.caps.getPotentialTargets(topicName);
                            boolean reassign = true;
                            for (InstanceDescription desc : potentialTargets) {
                                if (!desc.isLocal()) continue;
                                reassign = false;
                                break;
                            }
                            if (!reassign) continue;
                            QueueConfigurationManager qcm = this.configuration.getQueueConfigurationManager();
                            if (qcm == null) {
                                break;
                            }
                            final QueueConfigurationManager.QueueInfo info = qcm.getQueueInfo(topicName);
                            JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.ResourceCallback(){

                                @Override
                                public boolean handle(Resource rsrc) {
                                    block7: {
                                        try {
                                            String newPath;
                                            ValueMap vm = ResourceHelper.getValueMap(rsrc);
                                            String targetId = CheckTopologyTask.this.caps.detectTarget(topicName, (Map<String, Object>)vm, info);
                                            HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                                            props.remove("event.job.started.time");
                                            if (targetId != null) {
                                                newPath = CheckTopologyTask.this.configuration.getAssginedJobsPath() + '/' + targetId + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                                props.put("event.job.queuename", info.queueName);
                                                props.put("event.job.application", targetId);
                                            } else {
                                                newPath = CheckTopologyTask.this.configuration.getUnassignedJobsPath() + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                                props.remove("event.job.queuename");
                                                props.remove("event.job.application");
                                            }
                                            try {
                                                ResourceHelper.getOrCreateResource(resolver, newPath, props);
                                                resolver.delete(rsrc);
                                                resolver.commit();
                                                String jobId = (String)vm.get("slingevent:eventId", String.class);
                                                if (targetId != null) {
                                                    CheckTopologyTask.this.configuration.getAuditLogger().debug("REASSIGN OK {} : {}", (Object)targetId, (Object)jobId);
                                                    break block7;
                                                }
                                                CheckTopologyTask.this.configuration.getAuditLogger().debug("REUNASSIGN OK : {}", (Object)jobId);
                                            }
                                            catch (PersistenceException pe) {
                                                CheckTopologyTask.this.logger.warn("Unable to move stale job from " + rsrc.getPath() + " to " + newPath, (Throwable)pe);
                                                resolver.refresh();
                                                resolver.revert();
                                            }
                                        }
                                        catch (InstantiationException ie) {
                                            CheckTopologyTask.this.logger.warn("Unable to move stale job from " + rsrc.getPath(), (Throwable)ie);
                                            resolver.refresh();
                                            resolver.revert();
                                        }
                                    }
                                    return CheckTopologyTask.this.caps.isActive();
                                }
                            });
                        }
                    }
                    finally {
                        resolver.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignUnassignedJobs() {
        if (this.caps != null && this.caps.isLeader() && this.caps.isActive()) {
            this.logger.debug("Checking unassigned jobs...");
            ResourceResolver resolver = this.configuration.createResourceResolver();
            if (resolver != null) {
                try {
                    Resource unassignedRoot = resolver.getResource(this.configuration.getUnassignedJobsPath());
                    this.logger.debug("Got unassigned root {}", (Object)unassignedRoot);
                    if (unassignedRoot != null) {
                        this.assignJobs(unassignedRoot, false);
                    }
                }
                finally {
                    resolver.close();
                }
            }
        }
    }

    private void assignJobs(Resource jobsRoot, boolean unassign) {
        final ResourceResolver resolver = jobsRoot.getResourceResolver();
        Iterator topicIter = jobsRoot.listChildren();
        while (this.caps.isActive() && topicIter.hasNext()) {
            final Resource topicResource = (Resource)topicIter.next();
            final String topicName = topicResource.getName().replace('.', '/');
            this.logger.debug("Found topic {}", (Object)topicName);
            List<InstanceDescription> potentialTargets = this.caps.getPotentialTargets(topicName);
            if (potentialTargets != null && potentialTargets.size() > 0) {
                QueueConfigurationManager qcm = this.configuration.getQueueConfigurationManager();
                if (qcm == null) break;
                final QueueConfigurationManager.QueueInfo info = qcm.getQueueInfo(topicName);
                this.logger.debug("Found queue {} for {}", (Object)info.queueConfiguration, (Object)topicName);
                JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.ResourceCallback(){

                    @Override
                    public boolean handle(Resource rsrc) {
                        try {
                            ValueMap vm = ResourceHelper.getValueMap(rsrc);
                            String targetId = CheckTopologyTask.this.caps.detectTarget(topicName, (Map<String, Object>)vm, info);
                            if (targetId != null) {
                                String newPath = CheckTopologyTask.this.configuration.getAssginedJobsPath() + '/' + targetId + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                                HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                                props.put("event.job.queuename", info.queueName);
                                props.put("event.job.application", targetId);
                                props.remove("event.job.started.time");
                                try {
                                    ResourceHelper.getOrCreateResource(resolver, newPath, props);
                                    resolver.delete(rsrc);
                                    resolver.commit();
                                    String jobId = (String)vm.get("slingevent:eventId", String.class);
                                    CheckTopologyTask.this.configuration.getAuditLogger().debug("REASSIGN OK {} : {}", (Object)targetId, (Object)jobId);
                                }
                                catch (PersistenceException pe) {
                                    CheckTopologyTask.this.logger.warn("Unable to move unassigned job from " + rsrc.getPath() + " to " + newPath, (Throwable)pe);
                                    resolver.refresh();
                                    resolver.revert();
                                }
                            }
                        }
                        catch (InstantiationException ie) {
                            CheckTopologyTask.this.logger.warn("Unable to move unassigned job from " + rsrc.getPath(), (Throwable)ie);
                            resolver.refresh();
                            resolver.revert();
                        }
                        return CheckTopologyTask.this.caps.isActive();
                    }
                });
            }
            if (!this.caps.isActive() || !unassign) continue;
            JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.ResourceCallback(){

                @Override
                public boolean handle(Resource rsrc) {
                    try {
                        ValueMap vm = ResourceHelper.getValueMap(rsrc);
                        String newPath = CheckTopologyTask.this.configuration.getUnassignedJobsPath() + '/' + topicResource.getName() + rsrc.getPath().substring(topicResource.getPath().length());
                        HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)vm);
                        props.remove("event.job.queuename");
                        props.remove("event.job.application");
                        props.remove("event.job.started.time");
                        try {
                            ResourceHelper.getOrCreateResource(resolver, newPath, props);
                            resolver.delete(rsrc);
                            resolver.commit();
                            String jobId = (String)vm.get("slingevent:eventId", String.class);
                            CheckTopologyTask.this.configuration.getAuditLogger().debug("REUNASSIGN OK : {}", (Object)jobId);
                        }
                        catch (PersistenceException pe) {
                            CheckTopologyTask.this.logger.warn("Unable to unassigned job from " + rsrc.getPath() + " to " + newPath, (Throwable)pe);
                            resolver.refresh();
                            resolver.revert();
                        }
                    }
                    catch (InstantiationException ie) {
                        CheckTopologyTask.this.logger.warn("Unable to unassigned job from " + rsrc.getPath(), (Throwable)ie);
                        resolver.refresh();
                        resolver.revert();
                    }
                    return CheckTopologyTask.this.caps.isActive();
                }
            });
        }
    }

    public void fullRun(boolean topologyChanged, boolean configChanged) {
        if (this.caps != null) {
            if (topologyChanged) {
                this.reassignJobsFromStoppedInstances();
            }
            this.reassignStaleJobs();
            this.assignUnassignedJobs();
        }
    }
}

