/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.impl.jobs.InternalJobState;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.stats.StatisticsImpl;
import org.apache.sling.event.impl.jobs.stats.TopicStatisticsImpl;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;

@Component
@Service(value={StatisticsManager.class})
public class StatisticsManager {
    @Reference
    private JobManagerConfiguration configuration;
    private final StatisticsImpl globalStatistics = new StatisticsImpl(){

        @Override
        public synchronized void reset() {
            super.reset();
            StatisticsManager.this.topicStatistics.clear();
            for (Statistics s : StatisticsManager.this.queueStatistics.values()) {
                s.reset();
            }
        }
    };
    private final ConcurrentMap<String, TopicStatistics> topicStatistics = new ConcurrentHashMap<String, TopicStatistics>();
    private final ConcurrentMap<String, Statistics> queueStatistics = new ConcurrentHashMap<String, Statistics>();

    public Statistics getGlobalStatistics() {
        return this.globalStatistics;
    }

    public Map<String, TopicStatistics> getTopicStatistics() {
        return this.topicStatistics;
    }

    public Statistics getQueueStatistics(String queueName) {
        Statistics queueStats = (Statistics)this.queueStatistics.get(queueName);
        if (queueStats == null) {
            queueStats = new StatisticsImpl();
        }
        return queueStats;
    }

    private StatisticsImpl getStatisticsForQueue(String queueName) {
        if (queueName == null) {
            return null;
        }
        StatisticsImpl queueStats = (StatisticsImpl)this.queueStatistics.get(queueName);
        if (queueStats == null) {
            this.queueStatistics.putIfAbsent(queueName, new StatisticsImpl());
            queueStats = (StatisticsImpl)this.queueStatistics.get(queueName);
        }
        return queueStats;
    }

    public void jobEnded(String queueName, String topic, InternalJobState state, long processingTime) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        TopicStatisticsImpl ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        if (ts == null) {
            this.topicStatistics.putIfAbsent(topic, new TopicStatisticsImpl(topic));
            ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        }
        if (state == InternalJobState.CANCELLED) {
            ts.addCancelled();
            this.globalStatistics.cancelledJob();
            if (queueStats != null) {
                queueStats.cancelledJob();
            }
        } else if (state == InternalJobState.FAILED) {
            ts.addFailed();
            this.globalStatistics.failedJob();
            if (queueStats != null) {
                queueStats.failedJob();
            }
        } else if (state == InternalJobState.SUCCEEDED) {
            ts.addFinished(processingTime);
            this.globalStatistics.finishedJob(processingTime);
            if (queueStats != null) {
                queueStats.finishedJob(processingTime);
            }
        }
    }

    public void jobStarted(String queueName, String topic, long queueTime) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        TopicStatisticsImpl ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        if (ts == null) {
            this.topicStatistics.putIfAbsent(topic, new TopicStatisticsImpl(topic));
            ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        }
        ts.addActivated(queueTime);
        this.globalStatistics.addActive(queueTime);
        if (queueStats != null) {
            queueStats.addActive(queueTime);
        }
    }

    public void jobQueued(String queueName, String topic) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        this.globalStatistics.incQueued();
        if (queueStats != null) {
            queueStats.incQueued();
        }
    }

    public void jobDequeued(String queueName, String topic) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        this.globalStatistics.decQueued();
        if (queueStats != null) {
            queueStats.decQueued();
        }
    }

    protected void bindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        this.configuration = jobManagerConfiguration;
    }

    protected void unbindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        if (this.configuration == jobManagerConfiguration) {
            this.configuration = null;
        }
    }
}

