/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.scheduling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.ConfigurationChangeListener;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.scheduling.JobScheduleBuilderImpl;
import org.apache.sling.event.impl.jobs.scheduling.ScheduledJobHandler;
import org.apache.sling.event.impl.jobs.scheduling.ScheduledJobInfoImpl;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerImpl
implements ConfigurationChangeListener,
ResourceChangeListener,
ExternalResourceChangeListener,
Job {
    private static final String PROPERTY_READ_JOB = "properties";
    private static final String PROPERTY_SCHEDULE_INDEX = "index";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final JobManagerConfiguration configuration;
    private final Scheduler scheduler;
    private final JobManagerImpl jobManager;
    private final ScheduledJobHandler scheduledJobHandler;
    private final Map<String, ScheduledJobInfoImpl> scheduledJobs = new HashMap<String, ScheduledJobInfoImpl>();

    public JobSchedulerImpl(JobManagerConfiguration configuration, Scheduler scheduler, JobManagerImpl jobManager) {
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.jobManager = jobManager;
        this.configuration.addListener(this);
        this.scheduledJobHandler = new ScheduledJobHandler(configuration, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        this.configuration.removeListener(this);
        this.scheduledJobHandler.deactivate();
        if (this.active.compareAndSet(true, false)) {
            this.stopScheduling();
        }
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            this.scheduledJobs.clear();
        }
    }

    @Override
    public void configurationChanged(boolean processingActive) {
        TopologyCapabilities caps;
        boolean schedulingActive = processingActive ? ((caps = this.configuration.getTopologyCapabilities()) != null && caps.isActive() ? caps.isLeader() : false) : false;
        if (schedulingActive) {
            if (this.active.compareAndSet(false, true)) {
                this.startScheduling();
            }
        } else if (this.active.compareAndSet(true, false)) {
            this.stopScheduling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScheduling() {
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            for (ScheduledJobInfo scheduledJobInfo : this.scheduledJobs.values()) {
                this.startScheduledJob((ScheduledJobInfoImpl)scheduledJobInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScheduling() {
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            for (ScheduledJobInfo scheduledJobInfo : this.scheduledJobs.values()) {
                this.stopScheduledJob((ScheduledJobInfoImpl)scheduledJobInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleJob(ScheduledJobInfoImpl info) {
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            this.scheduledJobs.put(info.getName(), info);
            this.startScheduledJob(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleJob(ScheduledJobInfoImpl info) {
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            if (this.scheduledJobs.remove(info.getName()) != null) {
                this.stopScheduledJob(info);
            }
        }
    }

    public void removeJob(ScheduledJobInfoImpl info) {
        this.unscheduleJob(info);
        this.scheduledJobHandler.remove(info);
    }

    private void startScheduledJob(ScheduledJobInfoImpl info) {
        if (this.active.get()) {
            if (!info.isSuspended()) {
                this.configuration.getAuditLogger().debug("SCHEDULED OK name={}, topic={}, properties={} : {}", (Object)new Object[]{info.getName(), info.getJobTopic(), info.getJobProperties()}, info.getSchedules());
                int index = 0;
                for (ScheduleInfo si : info.getSchedules()) {
                    String name = info.getSchedulerJobId() + "-" + String.valueOf(index);
                    ScheduleOptions options = null;
                    switch (si.getType()) {
                        case DAILY: 
                        case WEEKLY: 
                        case HOURLY: 
                        case MONTHLY: 
                        case YEARLY: 
                        case CRON: {
                            options = this.scheduler.EXPR(((ScheduleInfoImpl)si).getCronExpression());
                            break;
                        }
                        case DATE: {
                            options = this.scheduler.AT(((ScheduleInfoImpl)si).getNextScheduledExecution());
                        }
                    }
                    HashMap<String, Serializable> config = new HashMap<String, Serializable>();
                    config.put(PROPERTY_READ_JOB, info);
                    config.put(PROPERTY_SCHEDULE_INDEX, Integer.valueOf(index));
                    this.scheduler.schedule((Object)this, options.name(name).config(config).canRunConcurrently(false));
                    ++index;
                }
            } else {
                this.configuration.getAuditLogger().debug("SCHEDULED SUSPENDED name={}, topic={}, properties={} : {}", new Object[]{info.getName(), info.getJobTopic(), info.getJobProperties(), info.getSchedules()});
            }
        }
    }

    private void stopScheduledJob(ScheduledJobInfoImpl info) {
        Scheduler localScheduler = this.scheduler;
        if (localScheduler != null) {
            this.configuration.getAuditLogger().debug("SCHEDULED STOP name={}, topic={}, properties={} : {}", new Object[]{info.getName(), info.getJobTopic(), info.getJobProperties(), info.getSchedules()});
            for (int index = 0; index < info.getSchedules().size(); ++index) {
                String name = info.getSchedulerJobId() + "-" + String.valueOf(index);
                localScheduler.unschedule(name);
            }
        }
    }

    public void execute(JobContext context) {
        if (!this.active.get()) {
            return;
        }
        ScheduledJobInfoImpl info = (ScheduledJobInfoImpl)context.getConfiguration().get(PROPERTY_READ_JOB);
        if (info.isSuspended()) {
            return;
        }
        this.jobManager.addJob(info.getJobTopic(), info.getJobProperties());
        int index = (Integer)context.getConfiguration().get(PROPERTY_SCHEDULE_INDEX);
        Iterator<ScheduleInfo> iter = info.getSchedules().iterator();
        ScheduleInfo si = iter.next();
        for (int i = 0; i < index; ++i) {
            si = iter.next();
        }
        if (si.getType() == ScheduleInfo.ScheduleType.DATE) {
            if (index == 0 && info.getSchedules().size() == 1) {
                this.scheduledJobHandler.remove(info);
            } else {
                ArrayList<ScheduleInfo> infos = new ArrayList<ScheduleInfo>();
                for (ScheduleInfo i : info.getSchedules()) {
                    if (i == si) continue;
                    infos.add(i);
                }
                info.update(infos);
                this.scheduledJobHandler.updateSchedule(info.getName(), infos);
            }
        }
    }

    public void handleEvent(Event event) {
        if ("org/osgi/framework/BundleEvent/STARTED".equals(event.getTopic()) || "org/osgi/framework/BundleEvent/UPDATED".equals(event.getTopic())) {
            this.scheduledJobHandler.bundleEvent();
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    public JobBuilder.ScheduleBuilder createJobBuilder(ScheduledJobInfoImpl info) {
        JobScheduleBuilderImpl sb = new JobScheduleBuilderImpl(info.getJobTopic(), info.getJobProperties(), info.getName(), this);
        return info.isSuspended() ? sb.suspend() : sb;
    }

    private boolean match(ScheduledJobInfoImpl job, Map<String, Object> template) {
        if (template != null) {
            for (Map.Entry<String, Object> current : template.entrySet()) {
                Operation op;
                String propName;
                char firstChar;
                String key = current.getKey();
                char c = firstChar = key.length() > 0 ? key.charAt(0) : (char)'\u0000';
                if (firstChar == '=') {
                    propName = key.substring(1);
                    op = Operation.EQUALS;
                } else if (firstChar == '<') {
                    char secondChar;
                    char c2 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                    if (secondChar == '=') {
                        op = Operation.LESS_OR_EQUALS;
                        propName = key.substring(2);
                    } else {
                        op = Operation.LESS;
                        propName = key.substring(1);
                    }
                } else if (firstChar == '>') {
                    char secondChar;
                    char c3 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                    if (secondChar == '=') {
                        op = Operation.GREATER_OR_EQUALS;
                        propName = key.substring(2);
                    } else {
                        op = Operation.GREATER;
                        propName = key.substring(1);
                    }
                } else {
                    propName = key;
                    op = Operation.EQUALS;
                }
                Object value = current.getValue();
                if (op == Operation.EQUALS) {
                    if (value.equals(job.getJobProperties().get(propName))) continue;
                    return false;
                }
                if (value instanceof Comparable) {
                    int result = ((Comparable)value).compareTo(job.getJobProperties().get(propName));
                    if (op == Operation.LESS && result > -1) {
                        return false;
                    }
                    if (op == Operation.LESS_OR_EQUALS && result > 0) {
                        return false;
                    }
                    if (op == Operation.GREATER_OR_EQUALS && result < 0) {
                        return false;
                    }
                    if (op != Operation.GREATER || result >= 1) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ScheduledJobInfo> getScheduledJobs(String topic, long limit, Map<String, Object> ... templates) {
        ArrayList<ScheduledJobInfo> jobs = new ArrayList<ScheduledJobInfo>();
        long count = 0L;
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            for (ScheduledJobInfoImpl job : this.scheduledJobs.values()) {
                boolean add = true;
                if (topic != null && !topic.equals(job.getJobTopic())) {
                    add = false;
                }
                if (add && templates != null && templates.length != 0) {
                    Map<String, Object> template;
                    add = false;
                    Map<String, Object>[] arr$ = templates;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && !(add = this.match(job, template = arr$[i$])); ++i$) {
                    }
                }
                if (!add) continue;
                jobs.add(job);
                if (limit <= 0L || ++count != limit) continue;
                break;
            }
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(ScheduledJobInfoImpl info, boolean flag) {
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            StringBuilder sb = new StringBuilder(this.configuration.getScheduledJobsPath(true));
            sb.append(ResourceHelper.filterName(info.getName()));
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                ModifiableValueMap mvm = (ModifiableValueMap)eventResource.adaptTo(ModifiableValueMap.class);
                if (flag) {
                    mvm.put((Object)"slingevent:scheduleSuspended", (Object)Boolean.TRUE);
                } else {
                    mvm.remove((Object)"slingevent:scheduleSuspended");
                }
                resolver.commit();
            }
            if (flag) {
                this.stopScheduledJob(info);
            } else {
                this.startScheduledJob(info);
            }
        }
    }

    public ScheduledJobInfo addScheduledJob(String topic, Map<String, Object> properties, String scheduleName, boolean isSuspended, List<ScheduleInfoImpl> scheduleInfos, List<String> errors) {
        String errorMessage;
        ArrayList<String> msgs = new ArrayList<String>();
        if (scheduleName == null || scheduleName.length() == 0) {
            msgs.add("Schedule name not specified");
        }
        if ((errorMessage = Utility.checkJob(topic, properties)) != null) {
            msgs.add(errorMessage);
        }
        if (scheduleInfos.size() == 0) {
            msgs.add("No schedule defined for " + scheduleName);
        }
        for (ScheduleInfoImpl info : scheduleInfos) {
            info.check(msgs);
        }
        if (msgs.size() == 0) {
            try {
                ScheduledJobInfoImpl info = this.scheduledJobHandler.addOrUpdateJob(topic, properties, scheduleName, isSuspended, scheduleInfos);
                if (info != null) {
                    return info;
                }
                msgs.add("Unable to persist scheduled job.");
            }
            catch (PersistenceException pe) {
                msgs.add("Unable to persist scheduled job: " + scheduleName);
                this.logger.warn("Unable to persist scheduled job", (Throwable)pe);
            }
        } else {
            for (String msg : msgs) {
                this.logger.warn(msg);
            }
        }
        if (errors != null) {
            errors.addAll(msgs);
        }
        return null;
    }

    public void maintenance() {
        this.scheduledJobHandler.maintenance();
    }

    public void onChange(List<ResourceChange> changes) {
        for (ResourceChange change : changes) {
            if (change.getPath() == null || !change.getPath().startsWith(this.configuration.getScheduledJobsPath(true))) continue;
            if (change.getType() == ResourceChange.ChangeType.REMOVED) {
                this.logger.debug("Remove scheduled job {}", (Object)change.getPath());
                this.scheduledJobHandler.handleRemove(change.getPath());
                continue;
            }
            this.logger.debug("Add or update scheduled job {}, event {}", (Object)change.getPath(), (Object)change.getType());
            this.scheduledJobHandler.handleAddUpdate(change.getPath());
        }
    }

    private static enum Operation {
        LESS,
        LESS_OR_EQUALS,
        EQUALS,
        GREATER_OR_EQUALS,
        GREATER;

    }
}

