/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Job Default Queue", description="The configuration of the default job queue.", name="org.apache.sling.event.impl.jobs.DefaultJobManager", metatype=true)
@Service(value={MainQueueConfiguration.class})
@Properties(value={@Property(name="queue.priority", value={"NORM"}, options={@PropertyOption(name="NORM", value="Norm"), @PropertyOption(name="MIN", value="Min"), @PropertyOption(name="MAX", value="Max")}, label="Priority", description="The priority for the threads used by this queue. Default is norm."), @Property(name="queue.retries", intValue={10}, label="Maximum Retries", description="The maximum number of times a failed job slated for retries is actually retried. If a job has been retried this number of times and still fails, it is not rescheduled and assumed to have failed. The default value is 10."), @Property(name="queue.retrydelay", longValue={2000L}, label="Retry Delay", description="The number of milliseconds to sleep between two consecutive retries of a job which failed and was set to be retried. The default value is 2 seconds. This value is only relevant if there is a single failed job in the queue. If there are multiple failed jobs, each job is retried in turn without an intervening delay."), @Property(name="queue.maxparallel", intValue={15}, label="Maximum Parallel Jobs", description="The maximum number of parallel jobs started for this queue. A value of -1 is substituted with the number of available processors.")})
public class MainQueueConfiguration {
    public static final String MAIN_QUEUE_NAME = "<main queue>";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private InternalQueueConfiguration mainConfiguration;

    @Activate
    protected void activate(Map<String, Object> props) {
        this.update(props);
    }

    @Modified
    protected void update(Map<String, Object> props) {
        HashMap<String, Object> queueProps = new HashMap<String, Object>(props);
        queueProps.put("queue.topics", "*");
        queueProps.put("queue.name", MAIN_QUEUE_NAME);
        queueProps.put("queue.type", (Object)QueueConfiguration.Type.UNORDERED);
        int maxParallel = PropertiesUtil.toInteger(queueProps.get("queue.maxparallel"), 15);
        if (maxParallel < 2) {
            this.logger.debug("Ignoring invalid setting of {} for {}. Setting to minimum value: 2", (Object)maxParallel, (Object)"queue.maxparallel");
            queueProps.put("queue.maxparallel", 2);
        }
        queueProps.put("service.pid", "org.apache.sling.event.impl.jobs.DefaultJobManager");
        this.mainConfiguration = InternalQueueConfiguration.fromConfiguration(queueProps);
    }

    public InternalQueueConfiguration getMainConfiguration() {
        return this.mainConfiguration;
    }
}

