/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.notifications;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class NewJobSender
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private JobManagerConfiguration configuration;
    @Reference
    private EventAdmin eventAdmin;
    private volatile ServiceRegistration<ResourceChangeListener> listenerRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Apache Sling Job Topic Manager Event Handler");
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)properties).put("resource.change.types", ResourceChange.ChangeType.ADDED.toString());
        ((Dictionary)properties).put("resource.paths", this.configuration.getLocalJobsPath());
        this.listenerRegistration = bundleContext.registerService(ResourceChangeListener.class, (Object)this, properties);
    }

    @Deactivate
    protected void deactivate() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.unregister();
            this.listenerRegistration = null;
        }
    }

    public void onChange(List<ResourceChange> resourceChanges) {
        for (ResourceChange resourceChange : resourceChanges) {
            int topicStart;
            this.logger.debug("Received event {}", (Object)resourceChange);
            String path = resourceChange.getPath();
            int topicEnd = path.indexOf(47, topicStart = this.configuration.getLocalJobsPath().length() + 1);
            if (topicEnd == -1) continue;
            String topic = path.substring(topicStart, topicEnd).replace('.', '/');
            String jobId = path.substring(topicEnd + 1);
            if (path.indexOf("_", topicEnd + 1) == -1) continue;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("slingevent:eventId", jobId);
            ((Dictionary)properties).put("event.job.topic", topic);
            String queueName = this.configuration.getQueueConfigurationManager().getQueueInfo((String)topic).queueName;
            ((Dictionary)properties).put("event.job.queuename", queueName);
            Event jobEvent = new Event("org/apache/sling/event/notification/job/ADDED", properties);
            this.eventAdmin.sendEvent(jobEvent);
        }
    }

    protected void bindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        this.configuration = jobManagerConfiguration;
    }

    protected void unbindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        if (this.configuration == jobManagerConfiguration) {
            this.configuration = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

