/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.lang.annotation.Annotation;
import java.util.Collections;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.event.impl.jobs.DefaultJobManager", service={MainQueueConfiguration.class}, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class MainQueueConfiguration {
    public static final String MAIN_QUEUE_NAME = "<main queue>";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private InternalQueueConfiguration mainConfiguration;

    @Activate
    protected void activate(Config config) {
        this.update(config);
    }

    @Modified
    protected void update(final Config config) {
        this.logger.debug("properties for queue {}: {}", (Object)MAIN_QUEUE_NAME, (Object)config);
        this.mainConfiguration = InternalQueueConfiguration.fromConfiguration(Collections.singletonMap("service.pid", "org.apache.sling.event.impl.jobs.DefaultJobManager"), new InternalQueueConfiguration.Config(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return InternalQueueConfiguration.Config.class;
            }

            @Override
            public int service_ranking() {
                return 0;
            }

            @Override
            public String queue_type() {
                return QueueConfiguration.Type.UNORDERED.name();
            }

            @Override
            public String[] queue_topics() {
                return new String[]{"*"};
            }

            @Override
            public int queue_threadPoolSize() {
                return 0;
            }

            @Override
            public long queue_retrydelay() {
                return config.queue_retrydelay();
            }

            @Override
            public int queue_retries() {
                return config.queue_retries();
            }

            @Override
            public String queue_priority() {
                return config.queue_priority();
            }

            @Override
            public boolean queue_preferRunOnCreationInstance() {
                return false;
            }

            @Override
            public String queue_name() {
                return MainQueueConfiguration.MAIN_QUEUE_NAME;
            }

            @Override
            public double queue_maxparallel() {
                return config.queue_maxparallel();
            }

            @Override
            public boolean queue_keepJobs() {
                return false;
            }

            @Override
            public String webconsole_configurationFactory_nameHint() {
                return "Queue: {queue.name}";
            }
        });
    }

    public InternalQueueConfiguration getMainConfiguration() {
        return this.mainConfiguration;
    }

    @ObjectClassDefinition(name="Apache Sling Job Default Queue", description="The configuration of the default job queue.")
    public static @interface Config {
        @AttributeDefinition(name="Priority", description="The priority for the threads used by this queue. Default is norm.", options={@Option(label="NORM", value="Norm"), @Option(label="MIN", value="Min"), @Option(label="MAX", value="Max")})
        public String queue_priority() default "NORM";

        @AttributeDefinition(name="Maximum Retries", description="The maximum number of times a failed job slated for retries is actually retried. If a job has been retried this number of times and still fails, it is not rescheduled and assumed to have failed. The default value is 10.")
        public int queue_retries() default 10;

        @AttributeDefinition(name="Retry Delay", description="The number of milliseconds to sleep between two consecutive retries of a job which failed and was set to be retried. The default value is 2 seconds. This value is only relevant if there is a single failed job in the queue. If there are multiple failed jobs, each job is retried in turn without an intervening delay.")
        public long queue_retrydelay() default 2000L;

        @AttributeDefinition(name="Maximum Parallel Jobs", description="The maximum number of parallel jobs started for this queue. A value of -1 is substituted with the number of available processors.")
        public int queue_maxparallel() default 15;
    }
}

