/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class}, property={"job.topics=org/apache/sling/event/impl/jobs/tasks/HistoryCleanUpTask", "service.vendor=The Apache Software Foundation"})
public class HistoryCleanUpTask
implements JobExecutor {
    private static final String PROPERTY_AGE = "age";
    private static final String PROPERTY_TOPIC = "topic";
    private static final String PROPERTY_STATE = "state";
    private static final int DEFAULT_AGE = 2880;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private JobManagerConfiguration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecutionResult process(Job job, JobExecutionContext context) {
        ArrayList<String> stateList;
        int age = job.getProperty(PROPERTY_AGE, 2880);
        if (age < 1) {
            age = 2880;
        }
        Calendar removeDate = Calendar.getInstance();
        removeDate.add(12, -age);
        Object[] topics = (String[])job.getProperty(PROPERTY_TOPIC, String[].class);
        Object[] states = (String[])job.getProperty(PROPERTY_STATE, String[].class);
        String logTopics = topics == null ? "ALL" : Arrays.toString(topics);
        String logStates = states == null ? "ALL" : Arrays.toString(states);
        context.log("Cleaning up job history. Removing all jobs older than {0}, with topics {1} and states {2}", removeDate, logTopics, logStates);
        if (states != null) {
            stateList = new ArrayList<String>();
            for (Object s : states) {
                stateList.add((String)s);
            }
        } else {
            stateList = null;
        }
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            if (stateList == null || stateList.contains(Job.JobState.SUCCEEDED.name())) {
                this.cleanup(removeDate, resolver, context, this.configuration.getStoredSuccessfulJobsPath(), (String[])topics, null);
            }
            if (stateList == null || stateList.contains(Job.JobState.DROPPED.name()) || stateList.contains(Job.JobState.ERROR.name()) || stateList.contains(Job.JobState.GIVEN_UP.name()) || stateList.contains(Job.JobState.STOPPED.name())) {
                this.cleanup(removeDate, resolver, context, this.configuration.getStoredCancelledJobsPath(), (String[])topics, stateList);
            }
        }
        return context.result().succeeded();
    }

    private void cleanup(Calendar removeDate, ResourceResolver resolver, JobExecutionContext context, String basePath, String[] topics, List<String> stateList) throws PersistenceException {
        Resource baseResource = resolver.getResource(basePath);
        if (baseResource != null) {
            Iterator topicIter = baseResource.listChildren();
            while (!context.isStopped() && topicIter.hasNext()) {
                Resource topicResource = (Resource)topicIter.next();
                boolean found = topics == null;
                for (int index = 0; !found && index < topics.length; ++index) {
                    if (!topicResource.getName().equals(topics[index])) continue;
                    found = true;
                }
                if (!found) continue;
                int removeYear = removeDate.get(1);
                int removeMonth = removeDate.get(2) + 1;
                int removeDay = removeDate.get(5);
                int removeHour = removeDate.get(11);
                int removeMinute = removeDate.get(12);
                Iterator yearIter = topicResource.listChildren();
                while (!context.isStopped() && yearIter.hasNext()) {
                    Resource yearResource = (Resource)yearIter.next();
                    int year = Integer.valueOf(yearResource.getName());
                    if (year > removeYear) continue;
                    boolean oldYear = year < removeYear;
                    Iterator monthIter = yearResource.listChildren();
                    while (!context.isStopped() && monthIter.hasNext()) {
                        Resource monthResource = (Resource)monthIter.next();
                        int month = Integer.valueOf(monthResource.getName());
                        if (!oldYear && month > removeMonth) continue;
                        boolean oldMonth = oldYear || month < removeMonth;
                        Iterator dayIter = monthResource.listChildren();
                        while (!context.isStopped() && dayIter.hasNext()) {
                            Resource dayResource = (Resource)dayIter.next();
                            int day = Integer.valueOf(dayResource.getName());
                            if (!oldMonth && day > removeDay) continue;
                            boolean oldDay = oldMonth || day < removeDay;
                            Iterator hourIter = dayResource.listChildren();
                            while (!context.isStopped() && hourIter.hasNext()) {
                                Resource hourResource = (Resource)hourIter.next();
                                int hour = Integer.valueOf(hourResource.getName());
                                if (!oldDay && hour > removeHour) continue;
                                boolean oldHour = oldDay || hour < removeHour;
                                Iterator minuteIter = hourResource.listChildren();
                                while (!context.isStopped() && minuteIter.hasNext()) {
                                    Resource minuteResource = (Resource)minuteIter.next();
                                    int minute = Integer.valueOf(minuteResource.getName());
                                    boolean oldMinute = oldHour || minute <= removeMinute;
                                    if (!oldMinute) continue;
                                    Iterator jobIter = minuteResource.listChildren();
                                    while (!context.isStopped() && jobIter.hasNext()) {
                                        ValueMap vm;
                                        String state;
                                        boolean remove;
                                        Resource jobResource = (Resource)jobIter.next();
                                        boolean bl = remove = stateList == null;
                                        if (!remove && (state = (String)(vm = ResourceUtil.getValueMap((Resource)jobResource)).get("slingevent:finishedState", String.class)) != null && stateList.contains(state)) {
                                            remove = true;
                                        }
                                        if (!remove) continue;
                                        resolver.delete(jobResource);
                                        resolver.commit();
                                    }
                                    if (context.isStopped() || minuteResource.listChildren().hasNext()) continue;
                                    resolver.delete(minuteResource);
                                    resolver.commit();
                                }
                                if (context.isStopped() || !oldHour || hourResource.listChildren().hasNext()) continue;
                                resolver.delete(hourResource);
                                resolver.commit();
                            }
                            if (context.isStopped() || !oldDay || dayResource.listChildren().hasNext()) continue;
                            resolver.delete(dayResource);
                            resolver.commit();
                        }
                        if (context.isStopped() || !oldMonth || monthResource.listChildren().hasNext()) continue;
                        resolver.delete(monthResource);
                        resolver.commit();
                    }
                    if (context.isStopped() || !oldYear || yearResource.listChildren().hasNext()) continue;
                    resolver.delete(yearResource);
                    resolver.commit();
                }
            }
        }
    }
}

