/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.util.xml.serialize.AttributeNameComparator;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.jackrabbit.vault.util.xml.serialize.XMLSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DocViewFormat {
    private final OutputFormat format = new OutputFormat("xml", "UTF-8", true);
    private WeakReference<ByteArrayOutputStream> formattingBuffer;

    public DocViewFormat() {
        this.format.setIndent(4);
        this.format.setLineWidth(0);
        this.format.setBreakEachAttribute(true);
        this.format.setSortAttributeNamesBy(AttributeNameComparator.INSTANCE);
    }

    public OutputFormat getXmlOutputFormat() {
        return this.format;
    }

    public boolean format(File file, boolean dryRun) throws IOException {
        boolean changed;
        CRC32 originalCrc32 = new CRC32();
        CRC32 formattedCrc32 = new CRC32();
        byte[] formatted = this.format(file, originalCrc32, formattedCrc32);
        boolean bl = changed = originalCrc32.getValue() != formattedCrc32.getValue();
        if (changed && !dryRun) {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                IOUtils.copy((InputStream)new ByteArrayInputStream(formatted), (OutputStream)out);
            }
        }
        return changed;
    }

    public List<String> format(File directory, List<Pattern> filenamePatterns, final boolean dryRun) throws IOException {
        final LinkedList<String> changed = new LinkedList<String>();
        Files.walkFileTree(directory.toPath(), new AbstractFormattingVisitor(filenamePatterns){

            @Override
            protected void process(File file) throws IOException {
                if (DocViewFormat.this.format(file, dryRun)) {
                    changed.add(file.getPath());
                }
            }
        });
        return changed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] format(File file, Checksum original, Checksum formatted) throws IOException {
        try (CheckedInputStream in = new CheckedInputStream(new BufferedInputStream(new FileInputStream(file)), original);){
            ByteArrayOutputStream buffer;
            ByteArrayOutputStream byteArrayOutputStream = buffer = this.formattingBuffer != null ? (ByteArrayOutputStream)this.formattingBuffer.get() : null;
            if (buffer == null) {
                buffer = new ByteArrayOutputStream();
                this.formattingBuffer = new WeakReference<ByteArrayOutputStream>(buffer);
            } else {
                buffer.reset();
            }
            XMLSerializer serializer = new XMLSerializer(new CheckedOutputStream(buffer, formatted), this.format);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(serializer);
            reader.setDTDHandler(serializer);
            reader.parse(new InputSource(in));
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    private static abstract class AbstractFormattingVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Pattern> patterns;

        AbstractFormattingVisitor(List<Pattern> patterns) {
            this.patterns = patterns;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Files.isRegularFile(file, new LinkOption[0]) && this.isIncluded(file)) {
                this.process(file.toFile());
            }
            return super.visitFile(file, attrs);
        }

        private boolean isIncluded(Path file) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(file.getFileName().toString()).matches()) continue;
                return true;
            }
            return false;
        }

        protected abstract void process(File var1) throws IOException;
    }
}

