/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;

public class ImportOptions {
    private boolean strict;
    private ProgressTrackerListener listener;
    private String patchParentPath = "/var/crxpatches/";
    private File patchDirectory;
    private boolean patchKeepInRepo = true;
    private boolean nonRecursive = false;
    private boolean dryRun;
    private int autoSave = -1;
    private AccessControlHandling acHandling = null;
    private ImportMode importMode;
    private Pattern cndPattern = Pattern.compile("^/(apps|libs)/([^/]+/){1,2}nodetypes/.+\\.cnd$");
    private WorkspaceFilter filter = null;
    private ClassLoader hookClassLoader;
    private PathMapping pathMapping = null;
    private DependencyHandling dependencyHandling = null;

    public ImportOptions() {
    }

    @Deprecated
    public ImportOptions(ImportOptions base) {
        if (base != null) {
            this.strict = base.strict;
            this.listener = base.listener;
            this.patchParentPath = base.patchParentPath;
            this.patchDirectory = base.patchDirectory;
            this.patchKeepInRepo = base.patchKeepInRepo;
            this.nonRecursive = base.nonRecursive;
            this.dryRun = base.dryRun;
            this.autoSave = base.autoSave;
            this.acHandling = base.acHandling;
            this.importMode = base.importMode;
            this.cndPattern = base.cndPattern;
            this.filter = base.filter;
            this.hookClassLoader = base.hookClassLoader;
            this.pathMapping = base.pathMapping;
            this.dependencyHandling = base.dependencyHandling;
        }
    }

    public ImportOptions copy() {
        ImportOptions ret = new ImportOptions();
        ret.strict = this.strict;
        ret.listener = this.listener;
        ret.patchParentPath = this.patchParentPath;
        ret.patchDirectory = this.patchDirectory;
        ret.patchKeepInRepo = this.patchKeepInRepo;
        ret.nonRecursive = this.nonRecursive;
        ret.dryRun = this.dryRun;
        ret.autoSave = this.autoSave;
        ret.acHandling = this.acHandling;
        ret.importMode = this.importMode;
        ret.cndPattern = this.cndPattern;
        ret.filter = this.filter;
        ret.hookClassLoader = this.hookClassLoader;
        ret.pathMapping = this.pathMapping;
        ret.dependencyHandling = this.dependencyHandling;
        return ret;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public ProgressTrackerListener getListener() {
        return this.listener;
    }

    public void setListener(ProgressTrackerListener listener) {
        this.listener = listener;
    }

    public String getPatchParentPath() {
        return this.patchParentPath;
    }

    public void setPatchParentPath(String patchParentPath) {
        this.patchParentPath = patchParentPath;
    }

    public File getPatchDirectory() {
        return this.patchDirectory;
    }

    public void setPatchDirectory(File patchDirectory) throws IOException {
        this.patchDirectory = patchDirectory == null ? null : patchDirectory.getCanonicalFile();
    }

    public boolean isPatchKeepInRepo() {
        return this.patchKeepInRepo;
    }

    public void setPatchKeepInRepo(boolean patchKeepInRepo) {
        this.patchKeepInRepo = patchKeepInRepo;
    }

    public AccessControlHandling getAccessControlHandling() {
        return this.acHandling;
    }

    public void setAccessControlHandling(AccessControlHandling acHandling) {
        this.acHandling = acHandling;
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean nonRecursive) {
        this.nonRecursive = nonRecursive;
    }

    public Pattern getCndPattern() {
        return this.cndPattern;
    }

    public void setCndPattern(String cndPattern) throws PatternSyntaxException {
        this.cndPattern = Pattern.compile(cndPattern);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setAutoSaveThreshold(int threshold) {
        this.autoSave = threshold;
    }

    public int getAutoSaveThreshold() {
        return this.autoSave;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WorkspaceFilter filter) {
        this.filter = filter;
    }

    public ClassLoader getHookClassLoader() {
        return this.hookClassLoader;
    }

    public void setHookClassLoader(ClassLoader hookClassLoader) {
        this.hookClassLoader = hookClassLoader;
    }

    public PathMapping getPathMapping() {
        return this.pathMapping;
    }

    public void setPathMapping(PathMapping pathMapping) {
        this.pathMapping = pathMapping;
    }

    public DependencyHandling getDependencyHandling() {
        return this.dependencyHandling;
    }

    public void setDependencyHandling(DependencyHandling dependencyHandling) {
        this.dependencyHandling = dependencyHandling;
    }
}

