/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.PackageEventListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PackageEventListener.class}, immediate=true, property={"service.vendor=The Apache Software Foundation"})
public class ActivityLog
implements PackageEventListener {
    private static final Logger log = LoggerFactory.getLogger(ActivityLog.class);

    @Activate
    private void activate() {
        log.info("Package Activity Log Started");
    }

    @Override
    public void onPackageEvent(@Nonnull PackageEvent event) {
        String msg = event.getRelatedIds() != null ? String.format("%s: %s (%s)", new Object[]{event.getId(), event.getType(), PackageId.toString(event.getRelatedIds())}) : String.format("%s: %s", new Object[]{event.getId(), event.getType()});
        if (log.isTraceEnabled()) {
            msg = msg + "\nThe event was triggered here:";
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stackTrace.length; ++i) {
                StackTraceElement s = stackTrace[i];
                msg = msg + String.format("\n\tat %s.%s(%s:%d)", s.getClassName(), s.getMethodName(), s.getFileName(), s.getLineNumber());
            }
        }
        log.info("{}", (Object)msg);
    }
}

