/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Manifest;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.impl.BundleDescriptorImpl;

public class ArtifactDescriptorImpl
extends ArtifactDescriptor {
    private final Manifest manifest;
    private final URL artifactFile;
    private final Artifact artifact;

    public ArtifactDescriptorImpl(String name, Artifact artifact, URL url, boolean hasManifest, boolean isManifestOptional) throws IOException {
        Manifest mf;
        block6: {
            super(name != null ? name : artifact.getId().toMvnId());
            this.artifact = artifact;
            this.artifactFile = url;
            mf = null;
            if (hasManifest) {
                try {
                    Manifest origMf = BundleDescriptorImpl.getManifest(url);
                    if (origMf != null) {
                        mf = new Manifest(origMf);
                    } else if (!isManifestOptional) {
                        throw new IOException(url + " : No manifest found.");
                    }
                }
                catch (IOException ioe) {
                    if (isManifestOptional) break block6;
                    throw ioe;
                }
            }
        }
        this.manifest = mf;
    }

    @Override
    public URL getArtifactFile() {
        return this.artifactFile;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }
}

