/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.List;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AddGroupMembers
extends Operation {
    private final String groupname;
    private final List<String> members;

    public AddGroupMembers(List<String> members, String groupname) {
        this.groupname = groupname;
        this.members = members;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitAddGroupMembers(this);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.members);
        sb.append(" in group ").append(this.groupname);
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        return String.format("add %s to group %s%n", AddGroupMembers.listToString(this.members), this.groupname);
    }

    public String getGroupname() {
        return this.groupname;
    }

    public List<String> getMembers() {
        return this.members;
    }
}

