/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.extensions;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class AnalyserMetaDataExtension {
    public static final String EXTENSION_NAME = "analyser-metadata";
    private final Map<ArtifactId, Map<String, String>> manifests = new HashMap<ArtifactId, Map<String, String>>();
    private final Map<ArtifactId, Boolean> reportWarnings = new HashMap<ArtifactId, Boolean>();
    private final Map<ArtifactId, Boolean> reportErrors = new HashMap<ArtifactId, Boolean>();

    public static AnalyserMetaDataExtension getAnalyserMetaDataExtension(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return AnalyserMetaDataExtension.getAnalyserMetaDataExtension(ext);
    }

    public static AnalyserMetaDataExtension getAnalyserMetaDataExtension(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        return new AnalyserMetaDataExtension(ext.getJSONStructure().asJsonObject());
    }

    private AnalyserMetaDataExtension(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            ArtifactId id = ArtifactId.fromMvnId((String)((String)entry.getKey()));
            JsonObject headers = ((JsonValue)entry.getValue()).asJsonObject();
            if (headers.containsKey((Object)"manifest")) {
                LinkedHashMap<String, String> manifest = new LinkedHashMap<String, String>();
                JsonObject manifestHeaders = headers.getJsonObject("manifest");
                for (String name : manifestHeaders.keySet()) {
                    manifest.put(name, manifestHeaders.getString(name));
                }
                this.manifests.put(id, manifest);
            }
            if (!headers.containsKey((Object)"report")) continue;
            JsonObject report = headers.getJsonObject("report");
            if (report.containsKey((Object)"warning")) {
                this.reportWarnings.put(id, report.getBoolean("warning"));
            }
            if (!report.containsKey((Object)"error")) continue;
            this.reportErrors.put(id, report.getBoolean("error"));
        }
    }

    public static boolean isAnalyserMetaDataExtension(Extension ext) {
        return ext != null && ext.getName().equals(EXTENSION_NAME) && ext.getType() == ExtensionType.JSON;
    }

    public Map<String, String> getManifest(ArtifactId artifactId) {
        return this.manifests.get(artifactId);
    }

    public boolean reportWarning(ArtifactId artifactId) {
        return !this.reportWarnings.containsKey(artifactId) || this.reportWarnings.get(artifactId) != false;
    }

    public boolean reportError(ArtifactId artifactId) {
        return !this.reportErrors.containsKey(artifactId) || this.reportErrors.get(artifactId) != false;
    }

    public Extension toExtension(Extension extension) {
        if (AnalyserMetaDataExtension.isAnalyserMetaDataExtension(extension)) {
            JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)extension.getJSONStructure().asJsonObject());
            Stream.concat(Stream.concat(this.manifests.keySet().stream(), this.reportErrors.keySet().stream()), this.reportWarnings.keySet().stream()).distinct().forEachOrdered(id -> {
                JsonObjectBuilder metadata = Json.createObjectBuilder();
                if (this.manifests.containsKey(id)) {
                    JsonObjectBuilder manifest = Json.createObjectBuilder();
                    this.manifests.get(id).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)manifest).add(arg_0, arg_1));
                    metadata.add("manifest", manifest);
                }
                if (this.reportErrors.containsKey(id) || this.reportWarnings.containsKey(id)) {
                    JsonObjectBuilder report = Json.createObjectBuilder();
                    if (this.reportErrors.containsKey(id)) {
                        report.add("error", this.reportErrors.get(id).booleanValue());
                    }
                    if (this.reportWarnings.containsKey(id)) {
                        report.add("warning", this.reportWarnings.get(id).booleanValue());
                    }
                    metadata.add("report", report);
                }
                builder.add(id.toMvnId(), metadata);
            });
            extension.setJSONStructure((JsonStructure)builder.build());
        }
        return extension;
    }

    public void add(BundleDescriptor ... bundleDescriptors) {
        for (BundleDescriptor descriptor : bundleDescriptors) {
            LinkedHashMap manifest = new LinkedHashMap();
            descriptor.getManifest().getMainAttributes().entrySet().stream().forEachOrdered(entry -> manifest.put(entry.getKey().toString(), (String)entry.getValue()));
            this.manifests.put(descriptor.getArtifact().getId(), manifest);
        }
    }

    public void setReportWarnings(ArtifactId id, boolean enabled) {
        this.reportWarnings.put(id, enabled);
    }

    public void setReportErrors(ArtifactId id, boolean enabled) {
        this.reportErrors.put(id, enabled);
    }
}

