/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class CheckBundleExportsImports
implements AnalyserTask {
    @Override
    public String getName() {
        return "Bundle Import/Export Check";
    }

    @Override
    public String getId() {
        return "bundle-packages";
    }

    private Report getReport(Map<BundleDescriptor, Report> reports, BundleDescriptor info) {
        return reports.computeIfAbsent(info, key -> new Report());
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws IOException {
        boolean bl;
        HashMap<BundleDescriptor, Report> reports = new HashMap<BundleDescriptor, Report>();
        TreeMap<Integer, List> bundlesMap = new TreeMap<Integer, List>();
        for (BundleDescriptor bundleDescriptor : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            List list = bundlesMap.computeIfAbsent(bundleDescriptor.getArtifact().getStartOrder(), key -> new ArrayList());
            list.add(bundleDescriptor);
        }
        ArrayList<BundleDescriptor> exportingBundles = new ArrayList<BundleDescriptor>();
        if (ctx.getFrameworkDescriptor() != null) {
            exportingBundles.add(ctx.getFrameworkDescriptor());
        }
        for (Map.Entry entry : bundlesMap.entrySet()) {
            for (BundleDescriptor info : (List)entry.getValue()) {
                if (info.getExportedPackages().isEmpty()) continue;
                exportingBundles.add(info);
            }
            for (BundleDescriptor info : (List)entry.getValue()) {
                for (PackageInfo pck : info.getImportedPackages()) {
                    List<BundleDescriptor> candidates = this.getCandidates(exportingBundles, pck);
                    if (candidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExports.add(pck);
                        continue;
                    }
                    ArrayList<BundleDescriptor> matchingCandidates = new ArrayList<BundleDescriptor>();
                    for (BundleDescriptor i : candidates) {
                        if (!i.isExportingPackage(pck)) continue;
                        matchingCandidates.add(i);
                    }
                    if (matchingCandidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExportsWithVersion.add(pck);
                        continue;
                    }
                    if (matchingCandidates.size() <= 1) continue;
                    this.getReport(reports, (BundleDescriptor)info).exportMatchingSeveral.add(pck);
                }
            }
        }
        boolean bl2 = false;
        for (Map.Entry entry : reports.entrySet()) {
            if (!((Report)entry.getValue()).missingExports.isEmpty()) {
                ctx.reportArtifactError(((BundleDescriptor)entry.getKey()).getArtifact().getId(), " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExports, false) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getArtifact().getStartOrder()) + " but no bundle is exporting these for that start level.");
                bl = true;
            }
            if (((Report)entry.getValue()).missingExportsWithVersion.isEmpty()) continue;
            ctx.reportArtifactError(((BundleDescriptor)entry.getKey()).getArtifact().getId(), " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExportsWithVersion, true) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getArtifact().getStartOrder()) + " but no bundle is exporting these for that start level in the required version range.");
            bl = true;
        }
        if (bl && ctx.getFeature().isComplete()) {
            ctx.reportError(ctx.getFeature().getId().toMvnId() + " is marked as 'complete' but has missing imports.");
        }
    }

    private String getPackageInfo(List<PackageInfo> pcks, boolean includeVersion) {
        if (pcks.size() == 1) {
            if (includeVersion) {
                return pcks.get(0).toString();
            }
            return pcks.get(0).getName();
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (PackageInfo info : pcks) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (includeVersion) {
                sb.append(info.toString());
                continue;
            }
            sb.append(info.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    private List<BundleDescriptor> getCandidates(List<BundleDescriptor> exportingBundles, PackageInfo pck) {
        ArrayList<BundleDescriptor> candidates = new ArrayList<BundleDescriptor>();
        for (BundleDescriptor info : exportingBundles) {
            if (!info.isExportingPackage(pck.getName())) continue;
            candidates.add(info);
        }
        return candidates;
    }

    public static final class Report {
        public List<PackageInfo> exportMatchingSeveral = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExports = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsWithVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsForOptional = new ArrayList<PackageInfo>();
    }
}

