/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorSettingsImpl;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.impl.contentpackage.PackageValidator;
import org.apache.sling.feature.scanner.ContentPackageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContentPackages
implements AnalyserTask {
    static final String DISABLED_VALIDATORS = "disabled-validators";
    static final String MAX_REPORT_LEVEL = "max-report-level";
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getName() {
        return "Content Package validation";
    }

    @Override
    public String getId() {
        return "content-packages-validation";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        String disabledValidators = ctx.getConfiguration().get(DISABLED_VALIDATORS);
        Map<String, ValidatorSettings> validatorSettings = this.disableValidators(disabledValidators);
        String maxReportLevelSt = ctx.getConfiguration().get(MAX_REPORT_LEVEL);
        ValidationMessageSeverity maxReportLevel = maxReportLevelSt == null ? ValidationMessageSeverity.WARN : ValidationMessageSeverity.valueOf((String)maxReportLevelSt);
        for (ContentPackageDescriptor cp : ctx.getFeatureDescriptor().getDescriptors(ContentPackageDescriptor.class)) {
            URL artifactFile = cp.getArtifactFile();
            if (artifactFile == null) {
                ctx.reportArtifactError(cp.getArtifact().getId(), "Content package " + cp.getName() + " is not resolved and can not be checked.");
                continue;
            }
            this.validatePackage(ctx, cp, artifactFile, validatorSettings, maxReportLevel);
        }
    }

    private Map<String, ValidatorSettings> disableValidators(String disabledValidators) {
        String[] disabledValidatorsAr;
        HashMap<String, ValidatorSettings> validatorSettings = new HashMap<String, ValidatorSettings>();
        if (disabledValidators == null) {
            return validatorSettings;
        }
        for (String validatorId : disabledValidatorsAr = disabledValidators.split(",")) {
            validatorSettings.put(validatorId, (ValidatorSettings)new ValidatorSettingsImpl(true));
        }
        return validatorSettings;
    }

    private void validatePackage(AnalyserTaskContext ctx, ContentPackageDescriptor cp, URL artifactFile, Map<String, ValidatorSettings> validatorSettings, ValidationMessageSeverity maxReportLevel) throws URISyntaxException, IOException {
        URI artifactURI = artifactFile.toURI();
        Path artifactPath = Paths.get(artifactURI);
        PackageValidator validator = new PackageValidator(artifactURI, validatorSettings);
        Collection<ValidationViolation> violations = validator.validate();
        this.reportViolations(ctx, cp, violations, artifactPath, maxReportLevel);
    }

    private void reportViolations(AnalyserTaskContext ctx, ContentPackageDescriptor cp, Collection<ValidationViolation> violations, Path artifactPath, ValidationMessageSeverity maxReportLevel) {
        for (ValidationViolation violation : violations) {
            ValidationMessageSeverity severity = this.getMin(maxReportLevel, violation.getSeverity());
            this.reportViolation(ctx, cp, violation, artifactPath, severity);
        }
    }

    private ValidationMessageSeverity getMin(ValidationMessageSeverity a, ValidationMessageSeverity b) {
        return a.compareTo((Enum)b) < 0 ? a : b;
    }

    private void reportViolation(AnalyserTaskContext ctx, ContentPackageDescriptor cp, ValidationViolation violation, Path artifactPath, ValidationMessageSeverity severity) {
        String msg = CheckContentPackages.getDetailMessage(violation, artifactPath);
        ArtifactId id = cp.getArtifact().getId();
        switch (severity) {
            case ERROR: {
                this.log.error(msg);
                ctx.reportArtifactError(id, msg);
                break;
            }
            case WARN: {
                this.log.warn(msg);
                ctx.reportArtifactWarning(id, msg);
                break;
            }
            case INFO: {
                this.log.info(msg);
                break;
            }
            default: {
                this.log.debug(msg);
            }
        }
    }

    private static String getDetailMessage(ValidationViolation violation, Path baseDirectory) {
        StringBuilder message = new StringBuilder("ValidationViolation: \"" + CheckContentPackages.getMessage(violation) + "\"");
        if (violation.getFilePath() != null) {
            message.append(", filePath=").append(baseDirectory.relativize(violation.getAbsoluteFilePath()));
        }
        if (violation.getNodePath() != null) {
            message.append(", nodePath=").append(violation.getNodePath());
        }
        if (violation.getLine() > 0) {
            message.append(", line=").append(violation.getLine());
        }
        if (violation.getColumn() > 0) {
            message.append(", column=").append(violation.getColumn());
        }
        return message.toString();
    }

    private static String getMessage(ValidationViolation violation) {
        StringBuilder message = new StringBuilder();
        if (violation.getValidatorId() != null) {
            message.append(violation.getValidatorId()).append(": ");
        }
        message.append(violation.getMessage());
        return message.toString();
    }
}

