/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.impl.BundleDescriptorImpl;
import org.apache.sling.feature.scanner.impl.ContentPackageDescriptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPackageScanner {
    private static final String FILE_PACKAGE_PROPS = "META-INF/vault/properties.xml";
    private static final String FILE_MANIFEST = "META-INF/MANIFEST.MF";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final byte[] buffer = new byte[65536];
    private static final List<String> CFG_EXTENSIONS = Arrays.asList(".config", ".cfg", ".cfg.json", ".xml");

    public Set<ContentPackageDescriptorImpl> scan(Artifact artifact, URL url) throws IOException {
        HashSet<ContentPackageDescriptorImpl> contentPackages = new HashSet<ContentPackageDescriptorImpl>();
        if (url != null) {
            String path = url.getPath();
            int lastDotInUrl = path.lastIndexOf(".");
            String name = path.substring(path.lastIndexOf("/") + 1, lastDotInUrl);
            this.extractContentPackage(null, null, artifact, name, url, contentPackages);
        }
        return contentPackages;
    }

    FileType detectContentFileType(String contentPath) {
        FileType fileType = null;
        if (contentPath.startsWith("/libs/") || contentPath.startsWith("/apps/")) {
            int endSlashPos;
            int pos;
            boolean isInstall;
            boolean bl = isInstall = contentPath.indexOf("/install/") != -1;
            if (!isInstall && (pos = contentPath.indexOf("/install.")) != -1 && (endSlashPos = contentPath.indexOf(47, pos + 1)) != -1) {
                isInstall = true;
            }
            if (!isInstall) {
                boolean bl2 = isInstall = contentPath.indexOf("/config/") != -1;
                if (!isInstall && (pos = contentPath.indexOf("/config.")) != -1 && (endSlashPos = contentPath.indexOf(47, pos + 1)) != -1) {
                    isInstall = true;
                }
            }
            if (isInstall) {
                if (contentPath.endsWith(".jar")) {
                    fileType = FileType.BUNDLE;
                } else if (contentPath.endsWith(".zip")) {
                    fileType = FileType.PACKAGE;
                } else {
                    for (String ext : CFG_EXTENSIONS) {
                        if (!contentPath.endsWith(ext)) continue;
                        fileType = FileType.CONFIG;
                        break;
                    }
                }
            }
        } else if (contentPath.startsWith("/etc/packages/") && contentPath.endsWith(".zip")) {
            fileType = FileType.PACKAGE;
        }
        return fileType;
    }

    private ContentPackageDescriptorImpl extractContentPackage(ContentPackageDescriptorImpl parentPackage, String parentContentPath, Artifact packageArtifact, String name, URL archiveUrl, Set<ContentPackageDescriptorImpl> infos) throws IOException {
        this.logger.debug("Analyzing Content Package {}", (Object)archiveUrl);
        File tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        try {
            ContentPackageDescriptorImpl contentPackageDescriptorImpl;
            block44: {
                File toDir = new File(tempDir, archiveUrl.getPath().substring(archiveUrl.getPath().lastIndexOf("/") + 1));
                toDir.mkdirs();
                Manifest manifest = null;
                ArrayList<File> toProcess = new ArrayList<File>();
                ArrayList<String> contentPaths = new ArrayList<String>();
                ArrayList<BundleDescriptor> bundles = new ArrayList<BundleDescriptor>();
                ArrayList<Configuration> configs = new ArrayList<Configuration>();
                Properties packageProps = new Properties();
                JarFile zipFile = IOUtils.getJarFileFromURL((URL)archiveUrl, (boolean)true, null);
                try {
                    Enumeration<JarEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        InputStream zis;
                        ZipEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (entryName.endsWith("/")) continue;
                        this.logger.debug("Content package entry {}", (Object)entryName);
                        if (entryName.startsWith("jcr_root/")) {
                            String contentPath = entryName.substring(8);
                            contentPaths.add(contentPath);
                            FileType fileType = this.detectContentFileType(contentPath);
                            if (fileType == null) continue;
                            this.logger.debug("- extracting : {}", (Object)contentPath);
                            File newFile = new File(toDir, entryName.replace('/', File.separatorChar));
                            newFile.getParentFile().mkdirs();
                            try (FileOutputStream fos = new FileOutputStream(newFile);
                                 InputStream zis2 = zipFile.getInputStream(entry);){
                                int len;
                                while ((len = zis2.read(this.buffer)) > -1) {
                                    fos.write(this.buffer, 0, len);
                                }
                            }
                            if (fileType == FileType.BUNDLE) {
                                int startLevel = 20;
                                int lastSlash = contentPath.lastIndexOf(47);
                                int nextSlash = contentPath.lastIndexOf(47, lastSlash - 1);
                                String part = contentPath.substring(nextSlash + 1, lastSlash);
                                try {
                                    startLevel = Integer.valueOf(part);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                Artifact bundle = new Artifact(this.extractArtifactId(packageArtifact.getId(), newFile));
                                bundle.setStartOrder(startLevel);
                                BundleDescriptorImpl info = new BundleDescriptorImpl(bundle, newFile.toURI().toURL(), startLevel);
                                bundle.getMetadata().put("content-package", packageArtifact.getId().toMvnId());
                                bundle.getMetadata().put("content-path", contentPath);
                                bundles.add(info);
                                continue;
                            }
                            if (fileType == FileType.CONFIG) {
                                Configuration configEntry = this.processConfiguration(newFile, packageArtifact.getId(), contentPath);
                                if (configEntry == null) continue;
                                configs.add(configEntry);
                                continue;
                            }
                            if (fileType != FileType.PACKAGE) continue;
                            toProcess.add(newFile);
                            continue;
                        }
                        if (FILE_MANIFEST.equals(entry.getName())) {
                            try {
                                zis = zipFile.getInputStream(entry);
                                try {
                                    manifest = new Manifest(zis);
                                }
                                finally {
                                    if (zis != null) {
                                        zis.close();
                                    }
                                }
                            }
                            catch (IOException ignore) {
                                this.logger.warn("Failure reading manifest from {} : {}", (Object)packageArtifact.getId(), (Object)ignore.getMessage());
                            }
                            continue;
                        }
                        if (!FILE_PACKAGE_PROPS.equals(entry.getName())) continue;
                        zis = zipFile.getInputStream(entry);
                        try {
                            packageProps.loadFromXML(zis);
                        }
                        finally {
                            if (zis == null) continue;
                            zis.close();
                        }
                    }
                    ContentPackageDescriptorImpl desc = new ContentPackageDescriptorImpl(name, packageArtifact, archiveUrl, manifest, bundles, contentPaths, configs, packageProps);
                    if (parentPackage != null) {
                        desc.setParentContentPackageInfo(parentPackage, parentContentPath);
                    }
                    for (File f : toProcess) {
                        int lastDot = f.getName().lastIndexOf(".");
                        String subName = f.getName().substring(0, lastDot);
                        String contentPath = f.getAbsolutePath().substring(toDir.getAbsolutePath().length()).replace(File.separatorChar, '/');
                        Artifact subArtifact = new Artifact(packageArtifact.getId().changeClassifier(subName));
                        this.extractContentPackage(desc, contentPath, subArtifact, subName, f.toURI().toURL(), infos);
                    }
                    infos.add(desc);
                    desc.lock();
                    contentPackageDescriptorImpl = desc;
                    if (zipFile == null) break block44;
                }
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                zipFile.close();
            }
            return contentPackageDescriptorImpl;
        }
        finally {
            this.deleteOnExitRecursive(tempDir);
        }
    }

    private void deleteOnExitRecursive(File file) {
        File[] childs;
        file.deleteOnExit();
        if (file.isDirectory() && (childs = file.listFiles()) != null) {
            for (File child : childs) {
                this.deleteOnExitRecursive(child);
            }
        }
    }

    final List<Properties> getInitialCandidates(File bundleFile) throws IOException {
        this.logger.debug("Extracting Bundle {}", (Object)bundleFile.getName());
        ArrayList<Properties> candidates = new ArrayList<Properties>();
        try (JarFile zipFile = new JarFile(bundleFile);){
            Enumeration<JarEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.endsWith("/") || !entryName.startsWith("META-INF/maven/") || !entryName.endsWith("/pom.properties")) continue;
                this.logger.debug("- extracting : {}", (Object)entryName);
                Properties props = new Properties();
                try (InputStream zis = zipFile.getInputStream(entry);){
                    props.load(zis);
                }
                candidates.add(props);
            }
        }
        return candidates;
    }

    private String adjustVersion(String version) {
        String[] parts = version.split("\\.");
        if (parts.length == 4) {
            int lastDot = version.lastIndexOf(46);
            return version.substring(0, lastDot) + '-' + version.substring(lastDot + 1);
        }
        return version;
    }

    private ArtifactId adjustClassifier(ArtifactId id, String bundleFileName) {
        int versionStart = bundleFileName.indexOf(id.getVersion());
        if (versionStart != -1) {
            int versionEnd = versionStart + id.getVersion().length();
            if (bundleFileName.length() > versionEnd && bundleFileName.charAt(versionEnd) == '-') {
                id = id.changeClassifier(bundleFileName.substring(versionEnd + 1, bundleFileName.lastIndexOf(46)));
            }
        }
        return id;
    }

    private ArtifactId extractArtifactId(ArtifactId packageArtifactId, File bundleFile) throws IOException {
        List<Properties> candidates = this.getInitialCandidates(bundleFile);
        return this.extractArtifactId(candidates, bundleFile.getName(), packageArtifactId);
    }

    private List<ArtifactId> getArtifactIds(List<Properties> candidates) {
        ArrayList<ArtifactId> idCandidates = new ArrayList<ArtifactId>();
        for (Properties props : candidates) {
            String version = props.getProperty("version");
            String groupId = props.getProperty("groupId");
            String artifactId = props.getProperty("artifactId");
            if (version == null || groupId == null || artifactId == null) continue;
            idCandidates.add(new ArtifactId(groupId, artifactId, this.adjustVersion(version), null, null));
        }
        return idCandidates;
    }

    private List<ArtifactId> filterCandidatesByVersion(List<ArtifactId> ids, String bundleFileName) {
        ArrayList<ArtifactId> idCandidates = new ArrayList<ArtifactId>();
        for (ArtifactId id : ids) {
            int versionStart = bundleFileName.indexOf(id.getVersion());
            if (versionStart == -1) continue;
            idCandidates.add(id);
        }
        return idCandidates;
    }

    ArtifactId extractArtifactId(List<Properties> candidates, String bundleFileName, ArtifactId packageArtifactId) throws IOException {
        this.logger.debug("Properties candidates for {} : {}", (Object)bundleFileName, candidates);
        List<ArtifactId> idCandidates = this.getArtifactIds(candidates);
        this.logger.debug("Artifact candidates for {} : {}", (Object)bundleFileName, candidates);
        if (idCandidates.size() == 1) {
            ArtifactId result = this.adjustClassifier(idCandidates.get(0), bundleFileName);
            this.logger.debug("Found single candidate : {}", (Object)result);
            return result;
        }
        List<ArtifactId> versionIds = this.filterCandidatesByVersion(idCandidates, bundleFileName);
        if (versionIds.size() == 1) {
            ArtifactId result = this.adjustClassifier(versionIds.get(0), bundleFileName);
            this.logger.debug("Found single candidate matching version : {}", (Object)result);
            return result;
        }
        for (ArtifactId id : versionIds.isEmpty() ? idCandidates : versionIds) {
            if (!id.getGroupId().equals(packageArtifactId.getGroupId())) continue;
            ArtifactId result = this.adjustClassifier(id, bundleFileName);
            this.logger.debug("Found candidate with parent group id {} : {}", (Object)packageArtifactId.getGroupId(), (Object)result);
            return result;
        }
        if (idCandidates.size() > 0) {
            ArtifactId result = this.adjustClassifier(idCandidates.get(0), bundleFileName);
            this.logger.debug("Picking random candidate : {}", (Object)result);
            return result;
        }
        throw new IOException(bundleFileName + " has no maven coordinates!");
    }

    Configuration processConfiguration(File configFile, ArtifactId packageArtifactId, String contentPath) throws IOException {
        String contents;
        boolean isConfig = true;
        if (contentPath.endsWith(".xml") && (contents = Files.readAllLines(configFile.toPath()).toString()).indexOf("jcr:primaryType=\"sling:OsgiConfig\"") == -1) {
            isConfig = false;
        }
        if (isConfig) {
            String id;
            if (contentPath.endsWith("/.content.xml")) {
                int lastSlash = contentPath.lastIndexOf(47);
                int previousSlash = contentPath.lastIndexOf(47, lastSlash - 1);
                id = contentPath.substring(previousSlash + 1, lastSlash);
            } else {
                String name = contentPath;
                int lastSlash = contentPath.lastIndexOf(47);
                for (String ext : CFG_EXTENSIONS) {
                    if (!name.endsWith(ext)) continue;
                    name = name.substring(lastSlash + 1, name.length() - ext.length());
                }
                id = name;
            }
            int slashPos = id.indexOf(45);
            String pid = slashPos == -1 ? id : id.substring(0, slashPos) + '~' + id.substring(slashPos + 1);
            Configuration cfg = new Configuration(pid);
            cfg.getProperties().put(":configurator:feature-content-path", contentPath);
            cfg.getProperties().put(":configurator:feature-content-package", packageArtifactId.toMvnId());
            return cfg;
        }
        return null;
    }

    static enum FileType {
        BUNDLE,
        CONFIG,
        PACKAGE;

    }
}

