/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.accesscontrol;

import java.util.LinkedList;
import java.util.List;
import org.apache.sling.feature.cpconverter.shared.RepoPath;

public final class AccessControlEntry {
    private final boolean isAllow;
    private final String privileges;
    private final RepoPath path;
    private final RepoPath repositoryPath;
    private final List<String> restrictions = new LinkedList<String>();

    public AccessControlEntry(boolean isAllow, String privileges, RepoPath path, RepoPath repositoryPath) {
        this.isAllow = isAllow;
        this.privileges = privileges;
        this.path = path;
        this.repositoryPath = repositoryPath;
    }

    public void addRestriction(String restriction) {
        if (restriction != null && !restriction.isEmpty()) {
            this.restrictions.add(restriction);
        }
    }

    public String getOperation() {
        return this.isAllow ? "allow" : "deny";
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public RepoPath getPath() {
        return this.path;
    }

    public RepoPath getRepositoryPath() {
        return this.repositoryPath;
    }

    public List<String> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        return "Acl [isAllow=" + this.isAllow + ", privileges=" + this.privileges + ", path=" + this.path + ", restrictions=" + this.restrictions + "]";
    }
}

