/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.artifacts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactWriter;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.MavenPomSupplierWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultArtifactsDeployer
implements ArtifactsDeployer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File artifactsDirectory;

    public DefaultArtifactsDeployer(File outputDirectory) {
        this.artifactsDirectory = outputDirectory;
        if (!this.artifactsDirectory.exists()) {
            this.artifactsDirectory.mkdirs();
        }
    }

    @Override
    public File getBundlesDirectory() {
        return this.artifactsDirectory;
    }

    @Override
    public void deploy(ArtifactWriter artifactWriter, ArtifactId id) throws IOException {
        Objects.requireNonNull(artifactWriter, "Null ArtifactWriter can not install an artifact to a Maven repository.");
        Objects.requireNonNull(id, "Bundle can not be installed to a Maven repository without specifying a valid id.");
        File targetDir = this.artifactsDirectory;
        StringTokenizer tokenizer = new StringTokenizer(id.getGroupId(), ".");
        while (tokenizer.hasMoreTokens()) {
            String current = tokenizer.nextToken();
            targetDir = new File(targetDir, current);
        }
        targetDir = new File(targetDir, id.getArtifactId());
        targetDir = new File(targetDir, id.getVersion());
        targetDir.mkdirs();
        StringBuilder nameBuilder = new StringBuilder().append(id.getArtifactId()).append('-').append(id.getVersion());
        if (id.getClassifier() != null) {
            nameBuilder.append('-').append(id.getClassifier());
        }
        nameBuilder.append('.').append(id.getType());
        File targetFile = new File(targetDir, nameBuilder.toString());
        this.logger.info("Writing data to {}...", (Object)targetFile);
        try (FileOutputStream targetStream = new FileOutputStream(targetFile);){
            artifactWriter.write(targetStream);
        }
        this.logger.info("Data successfully written to {}.", (Object)targetFile);
        targetFile = new File(targetDir, String.format("%s-%s.pom", id.getArtifactId(), id.getVersion()));
        if (!targetFile.exists()) {
            targetStream = new FileOutputStream(targetFile);
            try {
                new MavenPomSupplierWriter(id).write(targetStream);
            }
            finally {
                targetStream.close();
            }
        }
    }
}

